package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class CompanyServerRelationServiceImpl extends BaseDaoServiceImpl implements CompanyServerRelationService {

 

	private static final Log log = LogFactory.getLog(CompanyServerRelationServiceImpl.class);



		   
		@Override
		public Long insert(CompanyServerRelation companyServerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + companyServerRelation);

		if (companyServerRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		companyServerRelation.setCreateAt(currentTimeMillis);
		companyServerRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(companyServerRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + companyServerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<CompanyServerRelation> insertList(List<CompanyServerRelation> companyServerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (companyServerRelationList == null ? "null" : companyServerRelationList.size()));
      
		List<CompanyServerRelation> resultList = null;

		if (CollectionUtils.isEmpty(companyServerRelationList)) {
			return new ArrayList<CompanyServerRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CompanyServerRelation companyServerRelation : companyServerRelationList) {
			companyServerRelation.setCreateAt(currentTimeMillis);
			companyServerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CompanyServerRelation>) dao.batchSave(companyServerRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + companyServerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CompanyServerRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(CompanyServerRelation companyServerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (companyServerRelation == null ? "null" : companyServerRelation.getId()));

		boolean result = false;

		if (companyServerRelation == null) {
			return true;
		}

		companyServerRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(companyServerRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + companyServerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + companyServerRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<CompanyServerRelation> companyServerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (companyServerRelationList == null ? "null" : companyServerRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(companyServerRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CompanyServerRelation companyServerRelation : companyServerRelationList) {
			companyServerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(companyServerRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + companyServerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + companyServerRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public CompanyServerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		CompanyServerRelation companyServerRelation = null;

		if (id == null) {
			return companyServerRelation;
		}

		try {
			companyServerRelation = (CompanyServerRelation) dao.get(CompanyServerRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return companyServerRelation;		
		}	
		  
    	   
		@Override
		public List<CompanyServerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<CompanyServerRelation> companyServerRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CompanyServerRelation>();
		}

		try {
			companyServerRelation = (List<CompanyServerRelation>) dao.getList(CompanyServerRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (companyServerRelation == null ? "null" : companyServerRelation.size()));
    
		return companyServerRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getCompanyServerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCompanyServerRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCompanyServerRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCompanyServerRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCompanyServerRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

