/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.service.ServerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerServiceImpl
extends BaseDaoServiceImpl
implements ServerService {
    private static final Log log = LogFactory.getLog(ServerServiceImpl.class);

    public Long insert(Server server) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + server));
        if (server == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        server.setCreateAt(Long.valueOf(currentTimeMillis));
        server.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)server);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + server));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Server> insertList(List<Server> serverList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (serverList == null ? "null" : Integer.valueOf(serverList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(serverList)) {
            return new ArrayList<Server>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Server server : serverList) {
            server.setCreateAt(Long.valueOf(currentTimeMillis));
            server.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(serverList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + serverList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Server.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Server server) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (server == null ? "null" : server.getId())));
        boolean result = false;
        if (server == null) {
            return true;
        }
        server.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)server);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + server));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + server));
        }
        return result;
    }

    public boolean updateList(List<Server> serverList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (serverList == null ? "null" : Integer.valueOf(serverList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(serverList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Server server : serverList) {
            server.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(serverList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + serverList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + serverList.size()));
        return result;
    }

    public Server getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Server server = null;
        if (id == null) {
            return server;
        }
        try {
            server = (Server)this.dao.get(Server.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return server;
    }

    public List<Server> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List server = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Server>();
        }
        try {
            server = this.dao.getList(Server.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (server == null ? "null" : Integer.valueOf(server.size()))));
        return server;
    }

    public List<Long> getServerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countServerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getServerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getServerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

