package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.service.UserCompanyRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserCompanyRelationServiceImpl extends BaseDaoServiceImpl implements UserCompanyRelationService {

 

	private static final Log log = LogFactory.getLog(UserCompanyRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserCompanyRelation userCompanyRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userCompanyRelation);

		if (userCompanyRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userCompanyRelation.setCreateAt(currentTimeMillis);
		userCompanyRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userCompanyRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userCompanyRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserCompanyRelation> insertList(List<UserCompanyRelation> userCompanyRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userCompanyRelationList == null ? "null" : userCompanyRelationList.size()));
      
		List<UserCompanyRelation> resultList = null;

		if (CollectionUtils.isEmpty(userCompanyRelationList)) {
			return new ArrayList<UserCompanyRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCompanyRelation userCompanyRelation : userCompanyRelationList) {
			userCompanyRelation.setCreateAt(currentTimeMillis);
			userCompanyRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserCompanyRelation>) dao.batchSave(userCompanyRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userCompanyRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserCompanyRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserCompanyRelation userCompanyRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userCompanyRelation == null ? "null" : userCompanyRelation.getId()));

		boolean result = false;

		if (userCompanyRelation == null) {
			return true;
		}

		userCompanyRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userCompanyRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userCompanyRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userCompanyRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserCompanyRelation> userCompanyRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userCompanyRelationList == null ? "null" : userCompanyRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userCompanyRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCompanyRelation userCompanyRelation : userCompanyRelationList) {
			userCompanyRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userCompanyRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userCompanyRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userCompanyRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserCompanyRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserCompanyRelation userCompanyRelation = null;

		if (id == null) {
			return userCompanyRelation;
		}

		try {
			userCompanyRelation = (UserCompanyRelation) dao.get(UserCompanyRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userCompanyRelation;		
		}	
		  
    	   
		@Override
		public List<UserCompanyRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserCompanyRelation> userCompanyRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserCompanyRelation>();
		}

		try {
			userCompanyRelation = (List<UserCompanyRelation>) dao.getList(UserCompanyRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userCompanyRelation == null ? "null" : userCompanyRelation.size()));
    
		return userCompanyRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserCompanyRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserCompanyRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserCompanyRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserCompanyRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserCompanyRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

