package com.ptteng.graship.home.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.graship.home.model.RoleModuleRelation;
import com.ptteng.graship.home.service.RoleModuleRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class RoleModuleRelationServiceImpl extends BaseDaoServiceImpl implements RoleModuleRelationService {

 

	private static final Log log = LogFactory.getLog(RoleModuleRelationServiceImpl.class);



		   
		@Override
		public Long insert(RoleModuleRelation roleModuleRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + roleModuleRelation);

		if (roleModuleRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		roleModuleRelation.setCreateAt(currentTimeMillis);
		roleModuleRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(roleModuleRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + roleModuleRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<RoleModuleRelation> insertList(List<RoleModuleRelation> roleModuleRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (roleModuleRelationList == null ? "null" : roleModuleRelationList.size()));
      
		List<RoleModuleRelation> resultList = null;

		if (CollectionUtils.isEmpty(roleModuleRelationList)) {
			return new ArrayList<RoleModuleRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RoleModuleRelation roleModuleRelation : roleModuleRelationList) {
			roleModuleRelation.setCreateAt(currentTimeMillis);
			roleModuleRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<RoleModuleRelation>) dao.batchSave(roleModuleRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + roleModuleRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(RoleModuleRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(RoleModuleRelation roleModuleRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (roleModuleRelation == null ? "null" : roleModuleRelation.getId()));

		boolean result = false;

		if (roleModuleRelation == null) {
			return true;
		}

		roleModuleRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(roleModuleRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + roleModuleRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + roleModuleRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<RoleModuleRelation> roleModuleRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (roleModuleRelationList == null ? "null" : roleModuleRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(roleModuleRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RoleModuleRelation roleModuleRelation : roleModuleRelationList) {
			roleModuleRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(roleModuleRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + roleModuleRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + roleModuleRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public RoleModuleRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		RoleModuleRelation roleModuleRelation = null;

		if (id == null) {
			return roleModuleRelation;
		}

		try {
			roleModuleRelation = (RoleModuleRelation) dao.get(RoleModuleRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return roleModuleRelation;		
		}	
		  
    	   
		@Override
		public List<RoleModuleRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<RoleModuleRelation> roleModuleRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<RoleModuleRelation>();
		}

		try {
			roleModuleRelation = (List<RoleModuleRelation>) dao.getList(RoleModuleRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (roleModuleRelation == null ? "null" : roleModuleRelation.size()));
    
		return roleModuleRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getRoleModuleRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getRoleModuleRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countRoleModuleRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getRoleModuleRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getRoleModuleRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

