package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;


import com.gemantic.common.model.Message;
import com.gemantic.common.util.hash.Hash;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.service.ModulsService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created by Administrator on 2016/6/14.
 */
public class ModulsServiceImpl extends BaseDaoServiceImpl implements ModulsService {

    private static final Log log = LogFactory.getLog(ModulsServiceImpl.class);
    private ModulsService modulsService;

    @Override
    public Long insert(Moduls moduls) throws ServiceException, ServiceDaoException {
        log.info("insert moduls" + moduls);
        if (moduls == null) {
            return null;
        }
        Long currentTimeMillis = System.currentTimeMillis();
        moduls.setCreateAt(currentTimeMillis);
        Long result = null;
        try {
            log.info(moduls);
            result = (Long) dao.save(moduls);
        } catch (DaoException e) {
            log.error("insert error" + moduls);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info("insert moduls success :" + moduls);
        return result;
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info("delete moduls  id=" + id);
        if (id == null) {
            log.info("id is null,delete false");
            return false;
        }
        Boolean result = false;
        try {
            result = dao.delete(Moduls.class, id);
        } catch (DaoException e) {
            log.error("delete moduls false");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info("delete success id=" + id);
        return result;
    }

    @Override
    public boolean update(Moduls moduls) throws ServiceException, ServiceDaoException {
        log.info("update moduls id is" + moduls.getId());
        if (moduls == null) {
            return false;
        }
        moduls.setUpdateAt(System.currentTimeMillis());
        Boolean result = null;
        try {
            result = dao.update(moduls);
        } catch (DaoException e) {
            log.error("update false id is" + moduls.getId());
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + moduls);
        }
        return result;
    }

    @Override
    public Moduls getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info("get object by id and id is" + id);

        Moduls moduls = null;
        if (id == null) {
            return moduls;
        }
        try {
            moduls = (Moduls) dao.get(Moduls.class, id);
        } catch (DaoException e) {
            log.error("get moduls false id is " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info("get moduls success id is" + id);
        return moduls;
    }

    @Override
    public List<Moduls> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Moduls> moduls = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Moduls>();
        }

        try {
            moduls = (List<Moduls>) dao.getList(Moduls.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (moduls == null ? "null" : moduls.size()));

        return moduls;
    }
    public List<Long> getModulsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException{
        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try{
            idList=dao.getIdList("getModulsServeaAll",new Object[] {},start, limit, false);
            log.info("get List success the list is"+idList);
        }
        catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        System.out.println(idList);
        return idList;

    }

    @Override
    public List<Long> getModulsAllByGrade(Integer grade) throws ServiceException, ServiceDaoException {

        List<Long> idList = null;

        try{
            idList=dao.getIdList("getModulsAllByGrade",new Object[] {grade},0, Integer.MAX_VALUE, false);
            log.info("get List success the list is"+idList);
        }
        catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        System.out.println(idList);
        return idList;

    }

    @Override
    public List<Long> getModulsIdsByParent(Long parentId) throws ServiceException, ServiceDaoException {
        log.info(" get ids   by parentID  ================== " +parentId);
        List<Long> idList = null;


        try{
            idList=dao.getIdList("getModulsByParent",new Object[] {parentId},0, Integer.MAX_VALUE, false);
            log.info("get List success the list is"+idList);
        }
        catch (DaoException e) {
            log.error(" get ids  wrong by parentID)  : " + parentId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        System.out.println(idList);
        return idList;
    }

	@Override
	public List<Long> getModulsIdsByFather(Long parentId) throws ServiceException, ServiceDaoException {
		 log.info(" get ids   by parentID  ================== " +parentId);
	        List<Long> idList = null;


	        try{
	            idList=dao.getIdList("getModulsIdsByFather",new Object[] {parentId},0, Integer.MAX_VALUE, false);
	            log.info("get List success the list is"+idList);
	        }
	        catch (DaoException e) {
	            log.error(" get ids  wrong by parentID)  : " + parentId);
	            log.error(e);
	            e.printStackTrace();
	            throw new ServiceDaoException(e);
	        }
	        if (log.isInfoEnabled()) {
	            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
	        }
	        System.out.println(idList);
	        return idList;
	    }

	
	
	
	
	
	//===================自己写的方法==========================
	@Override
	public List<Long> getSonIdsByParents(Long parentId) throws ServiceException, ServiceDaoException {
		 log.info(" 自己写的 ================== " +parentId);
	        List<Long> idList = null;


	        try{
	            idList=dao.getIdList("getSonIdsByParents",new Object[] {parentId},0, Integer.MAX_VALUE, false);
	            log.info("get List success the list is"+idList);
	        }
	        catch (DaoException e) {
	            log.error(" get ids  wrong by parentID)  : " + parentId);
	            log.error(e);
	            e.printStackTrace();
	            throw new ServiceDaoException(e);
	        }
	        if (log.isInfoEnabled()) {
	            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
	        }
	        System.out.println(idList);
	        return idList;
	    }

	//未使用
	@Override
	public List<String> getModulsNameByIds(Long id) throws ServiceException, ServiceDaoException {
		 log.info(" 自己写的 ===获取名字通过id=============== " +id);
	        List<Long> idList = null;


	        try{
	            idList=dao.getIdList("getModulsNameByIds",new Object[] {id},0, Integer.MAX_VALUE, false);
	            log.info("get List success the list is"+idList);
	        }
	        catch (DaoException e) {
	            log.error(" get ids  wrong by parentID)  : " + id);
	            log.error(e);
	            e.printStackTrace();
	            throw new ServiceDaoException(e);
	        }
	        if (log.isInfoEnabled()) {
	            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
	        }
	        System.out.println(idList);
	        return null;
	}

    
//    public List<Long> getModulsServeb(String servea,Integer start, Integer limit) throws ServiceException, ServiceDaoException{
//        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
//        List<Long> idList = null;
//        HashSet<String> s=null;
//
//        if (start == null) {
//            start = 0;
//        }
//
//        if (limit == null) {
//            limit = Integer.MAX_VALUE;
//        }
//        try{
//            idList=dao.getIdList("getModulsServeaAll",new Object[] {servea},start, limit, false);
//            log.info("get List success the list is"+idList);
//        }
//        catch (DaoException e) {
//            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
//            log.error(e);
//            e.printStackTrace();
//            throw new ServiceDaoException(e);
//        }
//        if (log.isInfoEnabled()) {
//            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
//        }
//        System.out.println(idList);
//        return idList;
//
//    };
}
