package com.ptteng.graship.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.service.ComponentService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ComponentServiceImpl extends BaseDaoServiceImpl implements ComponentService {



	private static final Log log = LogFactory.getLog(ComponentServiceImpl.class);




	@Override
	public Long insert(Component component)throws ServiceException, ServiceDaoException{
		


		log.info(" insert data : " + component);

		if (component == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		component.setCreateAt(currentTimeMillis);
		component.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(component);
		} catch (DaoException e) {
			log.error(" insert wrong : " + component);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Component> insertList(List<Component> componentList)throws ServiceException, ServiceDaoException{
		


		log.info(" insert lists : " + (componentList == null ? "null" : componentList.size()));

		List<Component> resultList = null;

		if (CollectionUtils.isEmpty(componentList)) {
			return new ArrayList<Component>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Component component : componentList) {
			component.setCreateAt(currentTimeMillis);
			component.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Component>) dao.batchSave(componentList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + componentList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;
		
		

	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		


		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Component.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;
		
	}


	@Override
	public boolean update(Component component)throws ServiceException, ServiceDaoException{
		


		log.info(" update data : " + (component == null ? "null" : component.getId()));

		boolean result = false;

		if (component == null) {
			return true;
		}

		component.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(component);
		} catch (DaoException e) {
			log.error(" update wrong : " + component);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + component);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Component> componentList)throws ServiceException, ServiceDaoException{
		

		log.info(" update lists : " + (componentList == null ? "null" : componentList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(componentList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Component component : componentList) {
			component.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(componentList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + componentList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + componentList.size());

		return result;
	}


	@Override
	public Component getObjectById(Long id)throws ServiceException, ServiceDaoException{
		


		log.info(" get data : " + id);

		Component component = null;

		if (id == null) {
			return component;
		}

		try {
			component = (Component) dao.get(Component.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return component;
	}


	@Override
	public List<Component> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		


		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Component> component = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Component>();
		}

		try {
			component = (List<Component>) dao.getList(Component.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (component == null ? "null" : component.size()));

		return component;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getComponentIdsByPidAndStatusOrderByCreateAt(Long pid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		if(log.isInfoEnabled()){
			log.info(" get ids by pid,status,start,limit  : " + pid+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getComponentIdsByPidAndStatusOrderByCreateAt", new Object[] { pid,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by pid,status,start,limit)  : " + pid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
		


	}
	




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countComponentIdsByPidAndStatusOrderByCreateAt(Long pid,Integer status)throws ServiceException, ServiceDaoException{
		
		if(log.isInfoEnabled()){
			log.info(" count ids by pid,status  : " + pid+" , "+status );
		}
		Integer count=null;



		try {

			count = dao.count("getComponentIdsByPidAndStatusOrderByCreateAt", new Object[] { pid,status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by pid,status)  : " + pid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;
		


	}
	





	@Override
	public List<Long> getComponentIds(Integer start, Integer limit)
		throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getComponentIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countComponentIds() throws ServiceException,
		                                          ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getComponentIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getComponentIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

