package com.ptteng.graship.home.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.graship.home.model.Component;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ComponentService extends BaseDaoService {







	public Long insert(Component component)throws ServiceException, ServiceDaoException;



	public List<Component> insertList(List<Component> componentList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(Component component)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<Component> componentList)throws ServiceException, ServiceDaoException;



	public Component getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<Component> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countComponentIdsByPidAndStatusOrderByCreateAt(Long pid, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getComponentIdsByPidAndStatusOrderByCreateAt(Long pid, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getComponentIds(Integer start, Integer limit)
		throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countComponentIds() throws ServiceException, ServiceDaoException;


}

