/**
 *
 */
package com.ptteng.sca.graship.home.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.service.ComponentService;

import java.util.List;
import java.util.Map;

public class ComponentSCAClient implements ComponentService {

	private ComponentService componentService;

	public ComponentService getComponentService() {
		return componentService;
	}
	
	
	public void setComponentService(ComponentService componentService) {
		this.componentService =componentService;
	}
	
	

	@Override
	public Long insert(Component component)throws ServiceException, ServiceDaoException{
		
		return componentService.insert(component);


	}


	@Override
	public List<Component> insertList(List<Component> componentList)throws ServiceException, ServiceDaoException{
		
		return componentService.insertList(componentList);


	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return componentService.delete(id);


	}


	@Override
	public boolean update(Component component)throws ServiceException, ServiceDaoException{
		
		return componentService.update(component);


	}


	@Override
	public boolean updateList(List<Component> componentList)throws ServiceException, ServiceDaoException{
		
		return componentService.updateList(componentList);


	}


	@Override
	public Component getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return componentService.getObjectById(id);


	}


	@Override
	public List<Component> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return componentService.getObjectsByIds(ids);


	}








	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getComponentIdsByPidAndStatusOrderByCreateAt(Long pid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return componentService.getComponentIdsByPidAndStatusOrderByCreateAt(pid,status,start,limit);


	}
	





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countComponentIdsByPidAndStatusOrderByCreateAt(Long pid,Integer status)throws ServiceException, ServiceDaoException{
		
		return componentService.countComponentIdsByPidAndStatusOrderByCreateAt(pid,status);


	}
	


	@Override
	public List<Long> getComponentIds(Integer start, Integer limit)
		throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return componentService.getComponentIds(start, limit);
	}

	@Override
	public Integer countComponentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return componentService.countComponentIds();
	}

	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
		throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return componentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return componentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		componentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
	                                          Map<String, Object> conditions, Integer start, Integer limit)
		throws ServiceException, ServiceDaoException {

		return this.componentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}



}

