package com.ptteng.graship.admin.controller;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.ex.ApplyServicesEX;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.MessageService;
import com.ptteng.graship.home.service.ServerService;
import com.ptteng.graship.home.service.UserServerRelationService;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.DataUtils;

/**
 * UserServerRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserServerRelationController {
	private static final Log log = LogFactory.getLog(UserServerRelationController.class);

	@Autowired
	private UserServerRelationService userServerRelationService;
    @Autowired
    private MessageService messageService;
	@Autowired
	private UserService userService;

	@Autowired
	private ServerService serverService;

	@Autowired
	private CompanyService companyService;



    /**
	 * 使用服务申请列表
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/service/apply/list", method = RequestMethod.GET)
	public String getuserServerRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String name,Long parentId,Long id,String mobile,Long startAt,Long endAt,Long companyId,Long applyStart,Long applyEnd,Integer status,Integer page,Integer size,Long uid,String companyName) {
		log.info(" name:"+name+", parentId:"+parentId+", id:"+id+", mobile:"+mobile+", startAt:"+startAt+", endAt:"+endAt+", companyId:"+companyId+", applyStart:"+applyStart+", applyEnd:"+applyEnd+", status:"+status+",companyName:"+companyName);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String,Object> param = DynamicUtil.getUserServerIdsList(companyName, name, parentId, id, mobile, startAt, endAt, companyId, applyStart, applyEnd, status,uid);
		try {
			List<Long> usrList = userServerRelationService.getIdsByDynamicCondition(UserServerRelation.class, param, start, size);
			List<UserServerRelation> userServerList = userServerRelationService.getObjectsByIds(usrList);
			List<Long> uList = new ArrayList<Long>();
			List<Long> cList = new ArrayList<Long>();
			List<Long> sList = new ArrayList<Long>();
			List<ApplyServicesEX> userServerRelationList = new ArrayList<ApplyServicesEX>();
			for(UserServerRelation usr:userServerList){
				ApplyServicesEX applyEX = new ApplyServicesEX();
				User u = userService.getObjectById(usr.getUid());
				Company c = companyService.getObjectById(usr.getCid());
				Server s = serverService.getObjectById(usr.getSid());
				if(DataUtils.isNotNullOrEmpty(c))
				{
				applyEX.setCid(c.getId());
				applyEX.setCname(c.getCname());
				}
				Server s2 = serverService.getObjectById(s.getParentId());
				applyEX.setUid(u.getId());
				applyEX.setName(u.getName());
				applyEX.setMobile(u.getMobile());
				if(s2==null){
					applyEX.setSname(s.getName());
				}else{
				applyEX.setSname(s2.getName()+"-"+s.getName());
				}
				applyEX.setSid(s.getId());
				applyEX.setUsrid(usr.getId());
				applyEX.setApplyDate(usr.getCreateAt());
				if(DataUtils.isNullOrEmpty(usr.getPreDate())){
					usr.setPreDate(0L);
				}else{
				applyEX.setPreDate(usr.getPreDate());
				}
				applyEX.setStatus(usr.getStatus());
				userServerRelationList.add(applyEX);
			}
			List<Long> allList = userServerRelationService.getIdsByDynamicCondition(UserServerRelation.class, param, 0, Integer.MAX_VALUE);
			int total = allList.size();
			int totalPage = 0;
			if(total%size==0){
				totalPage = total/size;
			}else{
				totalPage = total/size+1;
			}
		
		model.addAttribute("code",1);
		model.addAttribute("message","success");
		model.addAttribute("total",total);
		model.addAttribute("totalPage",totalPage);
		model.addAttribute("userServerRelationList",userServerRelationList);
		} catch (ServiceException | ServiceDaoException e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code",0);
			model.addAttribute("message","error");
		}
		
		return "/graship-home-service/userServerRelation/json/userServerRelationListJson";
	}
    
	 /**
		 * 查看
		 * @param
		 * @return
		 * @throws ServiceException
		 * @throws ServiceDaoException
		 */

		@RequestMapping(value = " /a/user/company/server/{usrid}", method = RequestMethod.GET)
		public String getuserServerRelationList(HttpServletRequest request,
				HttpServletResponse response, ModelMap model,@PathVariable Long usrid) {
			log.info("usrid:"+usrid);
			try {
				UserServerRelation usr = userServerRelationService.getObjectById(usrid);
				ApplyServicesEX applyEX = new ApplyServicesEX();
				User u = userService.getObjectById(usr.getUid());
				Company c = companyService.getObjectById(usr.getCid());
				Server s = serverService.getObjectById(usr.getSid());
				applyEX.setCid(c.getId());
				applyEX.setCname(c.getCname());
				Server s2 = serverService.getObjectById(s.getParentId());
				applyEX.setUid(u.getId());
				applyEX.setName(u.getName());
				applyEX.setMobile(u.getMobile());
				if(s2==null){
					log.info("是单级目录!");
					applyEX.setSname(s.getName());
				}else{
					log.info("是双级目录!");
				applyEX.setSname(s2.getName()+"-"+s.getName());
				}
				applyEX.setSid(s.getId());
				applyEX.setUsrid(usr.getId());
				applyEX.setApplyDate(usr.getCreateAt());
				if(DataUtils.isNullOrEmpty(usr.getPreDate())){
					usr.setPreDate(0L);
				}else{
				applyEX.setPreDate(usr.getPreDate());
				}
				applyEX.setStatus(usr.getStatus());
				model.addAttribute("code",1);
				model.addAttribute("message","success");
				model.addAttribute("userServerRelation",applyEX);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				log.info(e.getMessage());
				e.printStackTrace();
				model.addAttribute("code",0);
				model.addAttribute("message","error");
			} 
			return "/graship-home-service/userServerRelation/json/userServerRelationDetailJson"; 
		}
	    
	    

	/**
	 * 查看申请
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	
	@RequestMapping(value = " /a/user/company/server/{usrid}", method = RequestMethod.PUT)
	public String updateUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long usrid,Integer status,Long preDate) throws Exception {
		log.info(" usrid:"+usrid+", status:"+status+", preDate:"+preDate);
		try {
			UserServerRelation userServerRelation = userServerRelationService.getObjectById(usrid);
			userServerRelation.setStatus(status);
			userServerRelation.setPreDate(preDate);
			userServerRelationService.update(userServerRelation);
			//1表示未处理2表示成功3失败
			if(status==2){
				log.info("认证成功!总数加1");
				Company company = companyService.getObjectById(userServerRelation.getCid());
				Long count = company.getCount();
				company.setCount(count+1);
				companyService.update(company);
			}
			model.addAttribute("code", 1);

			model.addAttribute("message", "success");

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message","error");
		}

		return "/data/json";
	}

	/**
	 * 删除公司服务
	 * @param request
	 * @param response
	 * @param model
	 * @param usrid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/user/company/server/{usrid}", method = RequestMethod.DELETE)
	public String deleteUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long usrid)
			throws Exception {
		log.info("usrid:"+usrid);
		try {
			userServerRelationService.delete(usrid);

			log.info("add userServerRelation success");
			model.addAttribute("code",1);
			model.addAttribute("message","success");
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message","error");
		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userServerRelation", method = RequestMethod.GET)
	public String getMultiUserServerRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			log.info("ids:"+ids);
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserServerRelation> userServerRelationList = userServerRelationService.getObjectsByIds(idList);
			log.info("get  userServerRelation data is " + userServerRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userServerRelationList.size());

			model.addAttribute("userServerRelationList", userServerRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userServerRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/userServerRelation/json/userServerRelationListJson";
	}
	
	
	
	
	
}

