package com.ptteng.graship.admin.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.graship.home.model.Information;
import com.ptteng.graship.home.service.InformationService;

/**
 * Information  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class InformationController {
	private static final Log log = LogFactory.getLog(InformationController.class);

	@Autowired
	private InformationService informationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/information", method = RequestMethod.GET)
	public String getinformationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/information  to /information/view/informationList");

		return "/graship-home-service/information/view/informationList";
	}
    
    

    
	
	@RequestMapping(value = "/c/information/{id}", method = RequestMethod.GET)
	public String getInformation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/information/" + id + "  to /information/view/informationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/information/view/informationDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/information/{id}", method = RequestMethod.GET)
	public String getInformationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Information information = informationService.getObjectById(id);
			log.info("get information data is " + information);

			model.addAttribute("code", 0);

			model.addAttribute("information", information);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get information error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/information/json/informationDetailJson";
	}

	@RequestMapping(value = "/a/information/{id}", method = RequestMethod.PUT)
	public String updateInformationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Information information) throws Exception {
		
		log.info("update information : information= " + information);
		
		try {
			
			informationService.update(information);

			model.addAttribute("code", 0);

			model.addAttribute("information", information);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update information error,id is  " + information.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/information", method = RequestMethod.POST)
	public String addInformationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Information information) throws Exception {
		
		log.info("update information : information= " + information);
		
		try { 
			information.setId(null);

			informationService.insert(information);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add information error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/information/{id}", method = RequestMethod.DELETE)
	public String deleteInformationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete information : id= " + id);
		try {
			informationService.delete(id);

			log.info("add information success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete information error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/information", method = RequestMethod.GET)
	public String getMultiInformationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Information> informationList = informationService.getObjectsByIds(idList);
			log.info("get  information data is " + informationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",informationList.size());

			model.addAttribute("informationList", informationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get information error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/information/json/informationListJson";
	}
	
	
	
	
	
}

