package com.ptteng.graship.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Product;
import com.ptteng.graship.home.service.ComponentService;
import com.ptteng.graship.home.service.ProductService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.*;

/**
 * Component  crud
 * 
 * @author shixing ^_^
 * @Date 2017-4-11 16:43
 * @description 组件相关
 */
@Controller
public class ComponentController {
	private static final Log log = LogFactory.getLog(ComponentController.class);

	@Autowired
	private ComponentService componentService;

	@Autowired
	private ProductService productService;




    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/component", method = RequestMethod.GET)
	public String getcomponentList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/component  to /component/view/componentList");

		return "/graship-home-service/component/view/componentList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/component1 ", method = RequestMethod.GET)
	public String getComponentIdsByPidAndStatusOrderByCreateAtList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long pid,Integer status) throws Exception {

		log.info("/component  to /component/view/componentList");

		return "/graship-home-service/component/view/componentList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/component/{id}", method = RequestMethod.GET)
	public String getComponent(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/component/" + id + "  to /component/view/componentDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/component/view/componentDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/component1 ", method = RequestMethod.GET)
	public String getComponentIdsByPidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long pid,Integer status) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= componentService.getComponentIdsByPidAndStatusOrderByCreateAt(pid,status,start,size);
		log.info("get countComponentIdsByPidAndStatusOrderByCreateAt size is " + ids.size());

			List<Component> componentList = componentService.getObjectsByIds(ids);
			log.info("get component data is " + componentList.size());

			Integer total = componentService. countComponentIdsByPidAndStatusOrderByCreateAt(pid,status);
			log.info("get component count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("componentList", componentList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get component list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/component/json/componentListJson";
	}

	/*
	*更改组件状态
	* @param:id
	* @return
	* */
	@RequestMapping(value = "/a/u/component/status/{status}/{id}", method = RequestMethod.PUT)
	public String updateComponentStatus(HttpServletRequest request, HttpServletResponse reponse, ModelMap model,
										@PathVariable Long id, @PathVariable Integer status){
			log.info("id is :" + id);
			log.info("status is :" +status);
			log.info("the url is : /a/u/component/status/"+status+"/"+id);
			//入参校验
			if(id == null){
				log.error("id is null,please checkout your incoming parameter!");
				model.addAttribute("code",-10100);
				return "/common/success";
			}
			if(status == null){
				log.error("status is null,please checkout your incoming parameter!");
				model.addAttribute("code",-10111);
			}
			if(status == 0 || status == 1) {
				log.info("change id = " + id + "component status to " + status);

				//更新组件状态
				try {
					List<Long> childComponentIdList = new ArrayList<>();
					Component component = componentService.getObjectById(id);
					List<Component> childComponentList = new ArrayList<>();
					if(component == null){
						log.error("组件不存在");
						model.addAttribute("code",-10112);
					}
					//父类的组件状态更改，子组件的状态也跟着改变，如果组件状态是0，更改为1后，所有子组件也是变为1，反之同。
					//更改子组件的状态
					if(component.getParentId() == -1){
						Map<String, Object> params = DynamicUtil.getChildComponentIdsByComponentId(component.getId());
						log.info("params is :" + params);
						childComponentIdList = componentService.getIdsByDynamicCondition(Component.class, params, 0 ,
							Integer.MAX_VALUE);
						log.info("idList size is :" + childComponentIdList.size());
						log.info("childComponentIdList are :" + childComponentIdList);
						childComponentList = componentService.getObjectsByIds(childComponentIdList);
						log.info("componentList size is :" + childComponentList.size());
						for(Component childComponent : childComponentList){
							childComponent.setStatus(status);
							log.info("childComponent status is :" + childComponent.getStatus());
						}
						boolean result = componentService.updateList(childComponentList);
						if (result) {
							log.info("update childComponent status success");
							model.addAttribute("code", 0);
						} else {
							log.error("update childComponent status failed");
							model.addAttribute("code", -1);
						}

					}


					//如果是父类，则更新的是父类本身，如果是子类，则更新的是子类
					component.setStatus(status);
					boolean result = componentService.update(component);
					if (result) {
						log.info("update component status success");
						model.addAttribute("code", 0);
					} else {
						log.error("update component status failed");
						model.addAttribute("code", -1);
					}
				} catch (Throwable t) {
					t.printStackTrace();
					log.error(t.getMessage());
					log.error("get component error !!and id is :" + id);
					model.addAttribute("code", -1);
				}
			}else{
				model.addAttribute("code",-1);
				log.error("status is not fit for this place");
			}
			return "/common/success";
		}

	/*查看单个组件
	* @param:id
	* @return
	* */
	//编辑组件前需调用查看接口，所以需要/u/
	@RequestMapping(value = "/a/u/component/{id}", method = RequestMethod.GET)
	public String getComponentJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		//打印入参
		log.info("get data : id= " + id);
		//入参校验
		if(null == id) {
			log.error("id is null");
			model.addAttribute("code",-10110);
			return "/common/success";
		}
		try {
			//得到单个组件
			Component component = componentService.getObjectById(id);
			log.info("get component data is " + component);
			if(null == component){
				log.error("get component by id failed");
				model.addAttribute("code",-10112);
				return "/common/success";
			}

			//通过组件得到产品的pid
			Long pid = component.getPid();
			log.info("the id : "+ id +" reffers to component's pid is :" + pid);
			//通过pid得到产品对象
			Product product = productService.getObjectById(pid);
			//如果产品不为空，则得到产品的pname，临时字段pname返回给前端，因为查看接口需要看到产品名
			if(null == product){
				log.error("product is null");
				model.addAttribute("code",-10202);
			}
			String pname =  product.getName();
			if(null == pname){
				log.error("pname is null");
				model.addAttribute("code",-10203);
			}
			component.setPname(pname);
			model.addAttribute("code", 0);
			model.addAttribute("component",component);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get component error,id is  " + id);
			model.addAttribute("code", -10114);
		}

		return "/graship-home-service/component/json/componentDetailJson";
	}

	/*
	*  编辑组件/子组件
	* @param id
	* @param name
	* @param detail
	* @param edition
	*
	* */
	@RequestMapping(value = "/a/u/component/{id}", method = RequestMethod.PUT)
	public String updateComponentJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, String name, String detail,
			Integer edition) throws Exception {
		//打印入参
		log.info("the id is :" + id + ",name is :" + name + ",detail is :" + detail + ",edition is :" + edition);
		if(DataUtils.isNullOrEmpty(id)){
			log.error("id is null  *_*");
			model.addAttribute("code",-10100);
			return "/common/success";
		}
		Component component = componentService.getObjectById(id);
		log.info("component is :" + component);
		if(null == component){
			log.error("the component doesn't exist, *_*  please checkout the id is avaiable or not");
			model.addAttribute("code",-10112);
			return "/common/success";
		}
		log.info("updating component : original component = " + component);
		
		try {
			if(DataUtils.isNotNullOrEmpty(name)){
				component.setName(name);
			}else{
				log.error("name is null,please checkout the parameter *_* ");
				model.addAttribute("code",-10116);
				return "/common/success";
			}
			//子组件的parentId大于0，如果是子组件，则detail不为空,edition如果为空，则赋值1，如果不为空，则为传入的值
			if(component.getParentId()>0) {
				if(detail != null && (detail.length()<15)){
					component.setDetail(detail);
				}else{
					log.error("detail is null,please checkout the parameter *_* ");
					model.addAttribute("code",-10119);
					return "/common/success";

				}

				if((edition == 0) || (edition == 1) || (edition == 2) || (edition == 3)){
					component.setEdition(edition);
					log.info("edition is :" + edition);
				}else{
					log.error("edition is not correct,please checkout the parameter");
					model.addAttribute("code",-10118);
					return "/common/success";
				}

			}
			boolean result = componentService.update(component);
			if(result == true) {
				model.addAttribute("code", 0);
				model.addAttribute("component", component);
			}else {
				log.error("更新失败，我要报警了");
				model.addAttribute("code",-10120);
			}
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update component error,id is  " + component.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/*新增组件
	* @param component
	* @return
	* */
	@RequestMapping(value = "/a/u/component", method = RequestMethod.POST)
	public String addComponentJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long cid, Long pid, String name, Long parentId, String
			  detail, Integer edition) throws Exception {

		Component component = new Component();
		Product product = new Product();
		log.info("update component :  cid is :" + cid + ", pid is :" + pid + "，name" + name + ",parentId is :" +
			         parentId + ",detail is :" + detail +",edition" +edition);
		//参数验证,parentId不为空
		if(DataUtils.isNotNullOrEmpty(parentId)){
			log.info("parentId is :" + parentId);
		}else{
			log.error("parentId is null");
			model.addAttribute("code",-10125);
			return "/common/success";
		}
		//子类的cid,detail,edition不为空,edition如果没传就赋一个默认值：1,组件和子组件的status设置初值1：下架
		if(parentId > 0){
			if(DataUtils.isNotNullOrEmpty(cid)){
				component.setParentId(cid);
				Component component1 = componentService.getObjectById(cid);
				log.info("component1 is :" + component1);
				component.setPid(component1.getPid());
			}else{
				log.error("child component parentId doesn't exist");
				model.addAttribute("code",-1);
				return "/common/success";
			}
			if(DataUtils.isNotNullOrEmpty(detail)){
				component.setDetail(detail);
			}else{
				log.error("child component parentId doesn't exist");
				model.addAttribute("code",-1);
				return "/common/success";
			}
			//edition只能为0/1/2/3中的一个
			if(DataUtils.isNotNullOrEmpty(edition) && (edition == 0 || edition == 1 || edition == 2 || edition == 3)){
				log.info("edition is :"+ edition);
				component.setEdition(edition);
			}else{
				log.error("Edition is illegal or null");
				model.addAttribute("code",-10121);
				return "/common/success";
			}
		}
		//父类的pid不为空
		else if(parentId == -1){
			component.setParentId(parentId);
			if(DataUtils.isNotNullOrEmpty(pid)){
				component.setPid(pid);
			}else{
				log.error("component's pid doesn't exist");
				model.addAttribute("code",-10115);
				return "/common/success";
			}
		}else{
			log.error("parentId is not null");
			model.addAttribute("code",-10122);
			return "/common/success";
		}
		//name都不为空
		if(DataUtils.isNotNullOrEmpty(name)){
			log.info("name is :" + name);
			component.setName(name);
		}else{
			log.error("name is null");
			model.addAttribute("code",-10116);
			return "/common/success";
		}

		try {
			component.setStatus(Component.STATUS_DOWN);
			Long  result = componentService.insert(component);
			log.info("result is :" + result);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add component error ");
			model.addAttribute("code", -10126);
		}

		return "/data/json";
	}

	/*删除组件
	* @param id
	* @return
	* */
	@RequestMapping(value = "/a/u/component/{id}", method = RequestMethod.DELETE)
	public String deleteComponentJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("I'll delete component : id= " + id);

		List<Long> componentList = new ArrayList<Long>();
		Component component = componentService.getObjectById(id);
		try{
			if(null == component){
				log.error("the id doesn't reffer to a correct component");
				model.addAttribute("code",-10112);
				return "/common/success";
			}
			//删除子组件
			if(-1 == component.getParentId()){
				//组件的id就是子类的parentId，所以查找parentId=传入的这个id，就是对应的子组件列表
				Map<String, Object> params = DynamicUtil.getComponentListIdsByParentId(id);
				componentList = componentService.getIdsByDynamicCondition(Component.class,params,0,
					Integer.MAX_VALUE);
				log.info("componentList is :" + componentList);
				for(Long iL:componentList) {
					boolean result = componentService.delete(iL);
					if (false == result) {
						log.error("delete component error");
						model.addAttribute("code", -1);
						return "/common/success";
					}
					log.info("delete component success,id is :" + iL);
				}
				//删除父组件
				boolean result = componentService.delete(id);
				if (false == result) {
					log.error("delete component error");
					model.addAttribute("code", -1);
					return "/common/success";
				}
			    model.addAttribute("code", 0);
			}else {
				//如果是父类组件，只要删除该父类即可
				boolean result = componentService.delete(id);
				if (false == result) {
					log.error("delete component error");
					model.addAttribute("code", -1);
					return "/common/success";
				}
				model.addAttribute("code",0);
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete component error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}




	/*
	* 模糊搜索接口
	* @param:name
	* @param:sname
	* @param:status
	* @param:pid
	* @param:parentId
	* @return
	* @
	*
	* */
	//组件列表模糊搜索：在component表中添加临时字段pname代表产品名字，sname指子组件和组件同时出现时的子组件名
	@RequestMapping(value = "/a/component/search", method = RequestMethod.GET)
	public String getMultiComponentJson(HttpServletRequest request,HttpServletResponse response, ModelMap model,
	                                    String name, String sname,Integer status, Long pid, Long parentId, Long cid, Integer page,
	                                    Integer size) throws Exception {
		//打印入参
		log.info("component name is:" + name + ",the child component name is :" + sname + ",status is " +
			         status + ",pid is " + pid + ",parentId is :" + parentId + ",cid is :" + cid);


		//入参校验
		if(null == parentId){
			parentId = Component.PARENT_ID;
			log.info("parentId is null,and I set it equal to -1 ^_^");
		}

		if(page == null){
			page = 1;
		}

		if(size == null){
			size = 10;
		}
		int start = (page - 1) * size;

		Product product = new Product();

		List<Long> idList = new ArrayList();
		List<Long> totals = null;
		Integer totalPage = null;
		try {
			//查询组件、根据输入条件查组件
			if (parentId == -1) {
				Map<String, Object> params = DynamicUtil.getComponentIdsByNameAndPidAndStatus(name,pid,status);
				idList = componentService.getIdsByDynamicCondition(Component.class,params,start,size);
				totals = componentService.getIdsByDynamicCondition(Component.class,params,0,Integer.MAX_VALUE);
				log.info("parentId = -1 and idList is   :" + idList);
			}else if(parentId == -2){
				//-2时查询所有的子组件
				Map<String, Object> params = DynamicUtil.getChildComponentIdsParams(name, sname, pid, status);
				idList = componentService.getIdsByDynamicCondition(Component.class, params, start, size);
				totals = componentService.getIdsByDynamicCondition(Component.class,params,0,Integer.MAX_VALUE);
				log.info("parentId = -2 and idList is :" + idList);
			}else if(parentId > 0){
				//查询单个组件的所有子组件
				Map<String, Object>  params = DynamicUtil.getChildComponentIdsByComponentId(parentId);
				idList = componentService.getIdsByDynamicCondition(Component.class,params,start,size);
				totals = componentService.getIdsByDynamicCondition(Component.class,params,0,Integer.MAX_VALUE);
				}

			log.info("idList id :" + idList);
			//当parentId=-1时：idList为组件id，得到组件列表,其余情况得到子组件的列表
			List<Component> componentList = componentService.getObjectsByIds(idList);
			if(null == componentList){
				log.error("get componentList error, and the idList is :" + idList);
				model.addAttribute("code",-10123);
			}

			//通过idList得到产品的名字列表,添加到componentList中
			for(Component component : componentList){
				log.info("componet id is :" + component.getId());
				product = productService.getObjectById(component.getPid());
				log.info("product is : " + product);
				String pname = product.getName();
				log.info("pname is :" + pname);

				component.setPname(pname);
				//当parentId=-1时，即查询父组件时不需要知道子组件名，所以下面只是在查询子组件列表时需要设置sname
				if(parentId != -1) {
					//在子组件列表中需要同时返回组件和子组件名，所以添加临时字段sname表示父组件名，更新子类的parentId
					parentId = component.getParentId();
					log.info("parentId is :" + parentId);

					//获得父组件的名字
					Component component2 = componentService.getObjectById(parentId);
					log.info("component2 is : " + component2 );
					component.setSname(component2.getName());

				}
			}

			//计算总条数
			log.info("get  componentList data is " + componentList);
			Integer total = totals.size();
			totalPage = (total/size) + 1;
			log.info("total is :" + total + ",totalPage is :" + totalPage);

			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("size",size);
			model.addAttribute("totalPage",totalPage);
			model.addAttribute("componentList", componentList);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get component error,id is  " + idList);
			model.addAttribute("code", -10124);
		}

		return "/graship-home-service/component/json/componentListJson";
	}
}

