package com.ptteng.graship.admin.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.ex.CompanyServerEX;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Server;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.MessageService;
import com.ptteng.graship.home.service.ServerService;
import com.ptteng.graship.home.service.UserCompanyRelationService;
import com.ptteng.graship.home.service.UserServerRelationService;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Server crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ServerController {
	private static final Log log = LogFactory.getLog(ServerController.class);

	@Autowired
	private ServerService serverService;

	@Autowired
	private CompanyService companyService;

	@Autowired
	private UserService userService;

	@Autowired
	private UserServerRelationService userServerRelationService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private MessageService messageService;
	@Autowired
	private CompanyServerRelationService companyServerRelationService;

	/**
	 * 服务列表
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param cname
	 * @param id
	 * @param parentId
	 * @param page
	 * @param size
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/list", method = RequestMethod.GET)
	public String getcompanyList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String cname,
			Long id, Long parentId, Long cid, Integer page, Integer size) {
		log.info(" cname:" + cname + ", id:" + id + ", cid:" + cid);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		// 解决选择父级服务问题
				String parentIds = "";
				if (DataUtils.isNotNullOrEmpty(id)) {
					parentIds = parentId + "";
				} else {
					Map<String, Object> sParam = DynamicUtil.getServerListByparentId(parentId);
					List<Long> sIds = new ArrayList<Long>();
					try {
						sIds = serverService.getIdsByDynamicCondition(Server.class, sParam, 0, Integer.MAX_VALUE);
					} catch (ServiceException | ServiceDaoException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}

					for (int i = 0; i < sIds.size(); i++) {
						if (i == sIds.size() - 1) {
							parentIds += sIds.get(i) ;
						} else {
							parentIds += sIds.get(i) + ",";
						}
					}
				}
		Map<String, Object> param = DynamicUtil.getCompanyServerIdsList(cname, cid, id, parentIds);
		try {
			List<Long> cList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class, param,
					start, size);
			List<Long> allList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
					param, 0, Integer.MAX_VALUE);
			int total = allList.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(cList);
			List<CompanyServerEX> comSerList = new ArrayList<CompanyServerEX>();
			for (CompanyServerRelation csr : companyServerList) {
				CompanyServerEX ex = new CompanyServerEX();
				Company c = companyService.getObjectById(csr.getCid());
				Server s = serverService.getObjectById(csr.getSid());
				if (s.getParentId() != 0) {
					log.info("是单级目录");
					Server ps = serverService.getObjectById(s.getParentId());
					ex.setSname(ps.getName() + "-" + s.getName());
				} else {
					log.info("不是双层目录!");
					ex.setSname(s.getName());
				}
				ex.setCid(c.getId());
				ex.setCname(c.getCname());
				ex.setCsrid(csr.getId());
				ex.setSid(s.getId());
				comSerList.add(ex);
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("companyServerList", comSerList);
		} catch (ServiceException | ServiceDaoException e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/companyServerRelation/json/companyServerRelationListJson";
	}

	/**
	 * 查看
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/a/company/server", method = RequestMethod.GET)
	public String getcompanyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id) {
		log.info("id:" + id);
		try {
			CompanyServerRelation csr = companyServerRelationService.getObjectById(id);
			Company company = companyService.getObjectById(csr.getCid());
			Server server = serverService.getObjectById(csr.getSid());
			Server server2 = null;
			if (server.getParentId() != 0) {
				server2 = serverService.getObjectById(server.getParentId());
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("company", company);
			model.addAttribute("server", server);
			model.addAttribute("parentServer", server2);
			model.addAttribute("companyServer", csr);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/serverListJson";

	}

	/**
	 * 编辑
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param csrid
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/{csrid}", method = RequestMethod.PUT)
	public String changeCompanyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long csrid, String favo, Long sid) {
		log.info("csrid:" + csrid + ",favo:" + favo);
		try {
			CompanyServerRelation companyServerRelation = companyServerRelationService.getObjectById(csrid);
			companyServerRelation.setFavo(favo);
			companyServerRelation.setSid(sid);
			companyServerRelationService.update(companyServerRelation);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");

		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	/**
	 * 删除
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param csrid
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/{csrid}", method = RequestMethod.DELETE)
	public String deleteCompanyServer1(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long csrid) {
		log.info("csrid:" + csrid);
		try {
			companyServerRelationService.delete(csrid);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");

		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	/**
	 * 服务认证列表
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param cname
	 * @param id
	 * @param parentId
	 * @param status
	 * @param startAt
	 * @param endAt
	 * @param page
	 * @param size
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/certifacat/search", method = RequestMethod.GET)
	public String getCertifacatedCompanyList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String cname, Long id, Long parentId, String status, Long startAt, Long endAt, Integer page, Integer size,
			Long cid) {
		log.info(" cname:" + cname + ", id:" + id + ", parentId:" + parentId + ", status:" + status + ", startAt:"
				+ startAt + ", endAt:" + endAt);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		// 解决选择父级服务问题
		String parentIds = "";
		if (DataUtils.isNotNullOrEmpty(id)) {
			parentIds = parentId + "";
		} else {
			Map<String, Object> sParam = DynamicUtil.getServerListByparentId(parentId);
			List<Long> sIds = new ArrayList<Long>();
			try {
				sIds = serverService.getIdsByDynamicCondition(Server.class, sParam, 0, Integer.MAX_VALUE);
			} catch (ServiceException | ServiceDaoException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			for (int i = 0; i < sIds.size(); i++) {
				if (i == sIds.size() - 1) {
					parentIds += sIds.get(i) ;
				} else {
					parentIds += sIds.get(i) + ",";
				}
			}
		}
		log.info("parentIds:"+parentIds);
		Map<String, Object> param = DynamicUtil.getAllCompanyServerIdsList(cname, id, parentIds, status, startAt, endAt,
				cid);
		try {

			List<Long> cList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class, param,
					start, size);
			List<Long> allList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class,
					param, 0, Integer.MAX_VALUE);
			int total = allList.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<CompanyServerRelation> companyServerList = companyServerRelationService.getObjectsByIds(cList);
			List<CompanyServerEX> comSerList = new ArrayList<CompanyServerEX>();
			for (CompanyServerRelation csr : companyServerList) {
				CompanyServerEX ex = new CompanyServerEX();
				Company c = companyService.getObjectById(csr.getCid());
				Server s = serverService.getObjectById(csr.getSid());
				if (s.getParentId() != 0) {
					log.info("是双级目录!");
					Server ps = serverService.getObjectById(s.getParentId());
					ex.setSname(ps.getName() + "-" + s.getName());
				} else {
					log.info("是单级目录!");
					ex.setSname(s.getName());
				}
				ex.setStatus(csr.getStatus());
				ex.setCreateAt(csr.getCreateAt());
				ex.setCid(c.getId());
				ex.setCname(c.getCname());
				ex.setCsrid(csr.getId());
				ex.setSid(s.getId());
				comSerList.add(ex);
			}
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("companyServerList", comSerList);
		} catch (ServiceException | ServiceDaoException e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/companyServerRelation/json/companyServerRelationListJson";
	}

	/**
	 * 申请认证
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param csrid
	 * @param favo
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/certifacat/{csrid}", method = RequestMethod.PUT)
	public String changeCompanyServerStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long csrid, Integer status) {
		log.info("csrid:" + csrid + ",status:" + status);
		try {
			CompanyServerRelation csr = companyServerRelationService.getObjectById(csrid);
			csr.setStatus(status);
			companyServerRelationService.update(csr);
			Long userId = Long
					.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			if ("-1".equals(status + "")) {
				// 未通过
				Message message = new Message();
				if (DataUtils.isNotNullOrEmpty(csr.getUid())) {
					message.setUid(csr.getUid());
				}
				message.setIfRead(1);
				message.setTitle("服务认证");
				message.setContent("对不起，贵公司提供的信息有误，服务认证申请未能通过。");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
			} else if ("2".equals(status + "")) {
				// 申请通过
				Message message = new Message();
				if (DataUtils.isNotNullOrEmpty(csr.getUid())) {
					message.setUid(csr.getUid());
				}
				message.setIfRead(1);
				message.setTitle("服务认证");
				message.setContent("恭喜您！服务认证申请已通过！现在其它企业已能在本站查找并申请贵公司提供的服务！");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	// 删除
	@RequestMapping(value = "/a/company/server/certifacat/{csrid}", method = RequestMethod.DELETE)
	public String deleteCompanyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long csrid) {
		log.info("csrid:" + csrid);
		try {
			companyServerRelationService.delete(csrid);

			model.addAttribute("code", 0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error(e.getMessage());
			model.addAttribute("code", -10000);
		}
		return "/graship-home-service/company/json/result";

	}

	/**
	 * 查看
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param csrid
	 * @return
	 */
	@RequestMapping(value = "/a/company/server/certifacat/detail", method = RequestMethod.GET)
	public String changeCompanyServerStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long csrid) {
		log.info("csrid:" + csrid);
		try {
			CompanyServerRelation csr = companyServerRelationService.getObjectById(csrid);
			CompanyServerEX ex = new CompanyServerEX();
			Company c = companyService.getObjectById(csr.getCid());
			Server s = serverService.getObjectById(csr.getSid());
			if (s.getParentId() != 0) {
				log.info("是双级目录！");
				Server ps = serverService.getObjectById(s.getParentId());
				ex.setSname(ps.getName());
				ex.setSsonname(s.getName());
			} else {
				log.info("是单级目录!");
				ex.setSname(s.getName());
			}
			ex.setStatus(csr.getStatus());
			ex.setCreateAt(csr.getCreateAt());
			ex.setCid(c.getId());
			ex.setCname(c.getCname());
			ex.setCsrid(csr.getId());
			ex.setSid(s.getId());
			ex.setFavo(csr.getFavo());
			model.addAttribute("code", 0);
			model.addAttribute("companyServerEX", ex);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", -10000);
		}
		return "/graship-home-service/companyServerRelation/json/companyServerEXDetail";

	}

	/**
	 * 删除接口
	 */
	@RequestMapping(value = "/a/server", method = RequestMethod.DELETE)
	public String deleteServer(HttpServletRequest request, HttpServletResponse response, ModelMap model, String id) {
		log.info(" ids:" + id);

		try {
			if (DataUtils.isNotNullOrEmpty(id)) {
				List<Long> idss = new ArrayList<Long>();
				String[] array = id.split(",");
				for (int i = 0; i < array.length; i++) {
					idss.add(Long.parseLong(array[i]));
				}
				serverService.deleteList(Server.class, idss);
			}
			model.addAttribute("code", 0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", -10000);
		}
		return "/common/success";

	}

	/**
	 * 查询接口
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param parentId
	 * @param cateName
	 * @param startAt
	 * @param endAt
	 * @return
	 */
	@RequestMapping(value = "/a/server/category/search", method = RequestMethod.GET)
	public String childListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String cateName, Long parentId, Long startAt, Long endAt, Integer page, Integer size) {
		log.info(" cateName:" + cateName + ", startAt:" + startAt + ", endAt:" + endAt + ",parentId:" + parentId);
		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		Map<String, Object> param = new HashMap<String, Object>();

		param = DynamicUtil.getIdsBycateName(parentId, cateName, startAt, endAt);

		List<Long> slist;
		try {
			slist = serverService.getIdsByDynamicCondition(Server.class, param, start, size);
			List<Long> alist = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			int total = alist.size();
			int totalPage = 0;
			if (total % size == 0) {
				totalPage = total / size;
			} else {
				totalPage = total / size + 1;
			}
			List<Server> childList = serverService.getObjectsByIds(slist);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("childList", childList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/childListJson";

	}

	/**
	 * 向上向下移动
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param sid
	 * @param move
	 * @return
	 */
	@RequestMapping(value = "/a/server/move/{sid}", method = RequestMethod.PUT)
	public String childListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long sid, Integer move) {
		log.info("sid:" + sid + ",move:" + move);
		try {
			Server s = serverService.getObjectById(sid);
			if (move == 0) {
				log.info("向上移动!");
				if (s.getSort() == 1) {
					model.addAttribute("code", 0);
					model.addAttribute("message", "已经是该级第一个！");
					return "/graship-home-service/company/json/result";

				}
				Map<String, Object> param = new HashMap<String, Object>();
				int sort = s.getSort() - 1;
				int sort2 = s.getSort();
				param = DynamicUtil.getIdsByParentIdAndSort(s.getParentId(), sort);
				List<Long> ids = serverService.getIdsByDynamicCondition(Server.class, param, 0, 10);
				List<Server> sList = serverService.getObjectsByIds(ids);
				Server s2 = sList.get(0);
				s.setSort(sort);
				s2.setSort(sort2);
				serverService.update(s);
				serverService.update(s2);
			} else if (move == 1) {
				log.info("向下移动!");
				Map<String, Object> param = new HashMap<String, Object>();
				param = DynamicUtil.getIdsByParentIdAndSort(s.getParentId(), null);
				List<Long> ids = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
				int total = ids.size();
				if (s.getSort() >= total) {
					model.addAttribute("code", 0);
					model.addAttribute("message", "已经是该级最后一个了！");
					return "/graship-home-service/company/json/result";

				}
				int sort = s.getSort();
				int sort2 = s.getSort() + 1;
				param = DynamicUtil.getIdsByParentIdAndSort(s.getParentId(), sort2);
				List<Long> id = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
				Server s2 = serverService.getObjectById(id.get(0));
				s.setSort(sort2);
				s2.setSort(sort);
				serverService.update(s);
				serverService.update(s2);
			}
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");

		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	/**
	 * 添加目录
	 * 
	 * @param request
	 * @param response
	 * @param model
	 * @param pid
	 * @param name
	 * @return
	 */
	@RequestMapping(value = "/a/parent/server/add", method = RequestMethod.POST)
	public String childListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long pid,
			String name) {
		log.info("pid:" + pid + ",name:" + name);
		try {
			Server s = new Server();
			Map<String, Object> param = new HashMap<String, Object>();
			param = DynamicUtil.getIdsByParentIdAndSort(pid, null);
			List<Long> ids = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			int total = ids.size();
			s.setParentId(pid);
			s.setSort(total + 1);
			s.setName(name);
			s.setId(null);
			serverService.insert(s);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/company/json/result";

	}

	// 下拉框列表
	@RequestMapping(value = "/a/child/server/list", method = RequestMethod.GET)
	public String childListJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long parentId) {
		log.info("parentId:" + parentId);
		Map<String, Object> param = new HashMap<String, Object>();
		if (parentId == null) {
			parentId = 0L;
		}
		param = DynamicUtil.getIdsByparentId(parentId);
		List<Long> slist;
		try {
			slist = serverService.getIdsByDynamicCondition(Server.class, param, 0, Integer.MAX_VALUE);
			List<Server> childList = serverService.getObjectsByIds(slist);
			model.addAttribute("code", 1);
			model.addAttribute("message", "success");
			model.addAttribute("childList", childList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage());
			e.printStackTrace();
			model.addAttribute("code", 0);
			model.addAttribute("message", "error");
		}
		return "/graship-home-service/server/json/childListJson";

	}

}
