/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.dao.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLUtil {
    private static final Log log = LogFactory.getLog(SQLUtil.class);

    public static String convert2Sql(Map<String, Object> conditions, Integer start, Integer limit) {
        String sql;
        if (conditions.containsKey("@union") || conditions.containsKey("@unionall")) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("select ");
            if (conditions.containsKey("@query")) {
                sqlBuffer = sqlBuffer.append(conditions.get("@query"));
            } else {
                sqlBuffer.append(" * ");
            }
            sqlBuffer.append(" from (");
            String concatType = "union all";
            List mapList = new ArrayList();
            if (conditions.containsKey("@union")) {
                concatType = " union ";
                mapList = (List)conditions.get("@union");
            } else if (conditions.containsKey("@unionall")) {
                concatType = " union all ";
                mapList = (List)conditions.get("@unionall");
            }
            int len = mapList.size();
            for (int i = 0; i < len; ++i) {
                Map map = (Map)mapList.get(i);
                sqlBuffer.append("(");
                sqlBuffer.append(SQLUtil.baseConvert2Sql(map, null, null));
                sqlBuffer.append(")");
                if (i == len - 1) continue;
                sqlBuffer.append(concatType);
            }
            sqlBuffer.append(") t");
            sqlBuffer = sqlBuffer.append(" where 1 = 1 ");
            boolean querySentence = false;
            for (String field : conditions.keySet()) {
                String[] ps = field.split("&");
                if (ps.length == 1) {
                    if (field.startsWith("@")) continue;
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(field);
                    sqlBuffer = sqlBuffer.append(" = ");
                } else {
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(ps[0]);
                    sqlBuffer = sqlBuffer.append(ps[1]);
                }
                sqlBuffer = sqlBuffer.append(conditions.get(field));
            }
            if (conditions.containsKey("@group")) {
                sqlBuffer = sqlBuffer.append(" group by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@group"));
            }
            if (conditions.containsKey("@order")) {
                sqlBuffer = sqlBuffer.append(" order by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@order"));
            }
            if (start != null) {
                sqlBuffer = sqlBuffer.append(" limit ");
                sqlBuffer = sqlBuffer.append(start);
                if (limit != null) {
                    sqlBuffer = sqlBuffer.append(" , ");
                    sqlBuffer = sqlBuffer.append(limit);
                }
            }
            sql = sqlBuffer.toString();
        } else {
            sql = SQLUtil.baseConvert2Sql(conditions, start, limit);
        }
        return sql;
    }

    public static String baseConvert2Sql(Map<String, Object> conditions, Integer start, Integer limit) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (conditions.containsKey("@update")) {
            sqlBuffer = sqlBuffer.append("update ");
            if (conditions.containsKey("@table")) {
                String table = (String)conditions.get("@table");
                sqlBuffer = sqlBuffer.append(table);
            } else {
                log.error((Object)"not get any table ");
            }
            sqlBuffer = sqlBuffer.append(" set ");
            boolean querySentence = false;
            if (conditions.containsKey("@field")) {
                String field = (String)conditions.get("@field");
                sqlBuffer = sqlBuffer.append(field);
            } else {
                log.error((Object)"not get any field ");
            }
            sqlBuffer = sqlBuffer.append(" = ");
            if (conditions.containsKey("@value")) {
                String value = (String)conditions.get("@value");
                sqlBuffer = sqlBuffer.append(value);
            } else {
                log.error((Object)"not get any value ");
            }
            sqlBuffer = sqlBuffer.append(" where ");
            boolean first = true;
            for (String field : conditions.keySet()) {
                String[] ps = field.split("&");
                if (ps.length == 1) {
                    if (field.startsWith("@")) continue;
                    if (!first) {
                        sqlBuffer = sqlBuffer.append(" and ");
                    }
                    first = false;
                    sqlBuffer = sqlBuffer.append(field);
                    sqlBuffer = sqlBuffer.append(" = ");
                } else {
                    if (!first) {
                        sqlBuffer = sqlBuffer.append(" and ");
                    }
                    first = false;
                    sqlBuffer = sqlBuffer.append(ps[0]);
                    sqlBuffer = sqlBuffer.append(ps[1]);
                }
                sqlBuffer = sqlBuffer.append(conditions.get(field));
            }
        } else {
            sqlBuffer = sqlBuffer.append("select ");
            sqlBuffer = conditions.containsKey("@query") ? sqlBuffer.append(conditions.get("@query")) : sqlBuffer.append("id");
            sqlBuffer = sqlBuffer.append(" from ");
            if (conditions.containsKey("@table")) {
                String table = (String)conditions.get("@table");
                sqlBuffer = sqlBuffer.append(table);
            } else {
                log.error((Object)"not get any table ");
            }
            sqlBuffer = sqlBuffer.append(" where 1 = 1 ");
            boolean querySentence = false;
            for (String field : conditions.keySet()) {
                String[] ps = field.split("&");
                if (ps.length == 1) {
                    if (field.startsWith("@")) continue;
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(field);
                    sqlBuffer = sqlBuffer.append(" = ");
                } else {
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(ps[0]);
                    sqlBuffer = sqlBuffer.append(ps[1]);
                }
                sqlBuffer = sqlBuffer.append(conditions.get(field));
            }
            if (conditions.containsKey("@group")) {
                sqlBuffer = sqlBuffer.append(" group by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@group"));
            }
            if (conditions.containsKey("@order")) {
                sqlBuffer = sqlBuffer.append(" order by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@order"));
            }
            if (start != null) {
                sqlBuffer = sqlBuffer.append(" limit ");
                sqlBuffer = sqlBuffer.append(start);
                if (limit != null) {
                    sqlBuffer = sqlBuffer.append(" , ");
                    sqlBuffer = sqlBuffer.append(limit);
                }
            }
        }
        return sqlBuffer.toString();
    }

    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        for (String table : tables) {
            tableBuffer = tableBuffer.append(table);
            if (++index >= tables.size()) continue;
            tableBuffer = tableBuffer.append(",");
        }
        return tableBuffer.toString();
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList mapList = new ArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("@table", "stock_in");
        params.put("@query", "id");
        mapList.add(params);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("@table", "stock_out");
        params2.put("@query", "id");
        map.put("@union", mapList);
        map.put("id", 1);
        map.put("@order", "id");
        System.out.println(SQLUtil.convert2Sql(map, 0, 1));
    }
}

