/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.dao.util;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLUtil {
    private static final Log log = LogFactory.getLog(SQLUtil.class);

    public static String convert2Sql(Map<String, Object> conditions, Integer start, Integer limit) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (conditions.containsKey("@update")) {
            sqlBuffer = sqlBuffer.append("update ");
            if (conditions.containsKey("@table")) {
                String table = (String)conditions.get("@table");
                sqlBuffer = sqlBuffer.append(table);
            } else {
                log.error((Object)"not get any table ");
            }
            sqlBuffer = sqlBuffer.append(" set ");
            boolean querySentence = false;
            if (conditions.containsKey("@field")) {
                String field = (String)conditions.get("@field");
                sqlBuffer = sqlBuffer.append(field);
            } else {
                log.error((Object)"not get any field ");
            }
            sqlBuffer = sqlBuffer.append(" = ");
            if (conditions.containsKey("@value")) {
                String value = (String)conditions.get("@value");
                sqlBuffer = sqlBuffer.append(value);
            } else {
                log.error((Object)"not get any value ");
            }
            sqlBuffer = sqlBuffer.append(" where ");
            boolean first = true;
            for (String field : conditions.keySet()) {
                String[] ps = field.split("&");
                if (ps.length == 1) {
                    if (field.startsWith("@")) continue;
                    if (!first) {
                        sqlBuffer = sqlBuffer.append(" and ");
                    }
                    first = false;
                    sqlBuffer = sqlBuffer.append(field);
                    sqlBuffer = sqlBuffer.append(" = ");
                } else {
                    if (!first) {
                        sqlBuffer = sqlBuffer.append(" and ");
                    }
                    first = false;
                    sqlBuffer = sqlBuffer.append(ps[0]);
                    sqlBuffer = sqlBuffer.append(ps[1]);
                }
                sqlBuffer = sqlBuffer.append(conditions.get(field));
            }
        } else {
            sqlBuffer = sqlBuffer.append("select ");
            sqlBuffer = conditions.containsKey("@query") ? sqlBuffer.append(conditions.get("@query")) : sqlBuffer.append("id");
            sqlBuffer = sqlBuffer.append(" from ");
            if (conditions.containsKey("@table")) {
                String table = (String)conditions.get("@table");
                sqlBuffer = sqlBuffer.append(table);
            } else {
                log.error((Object)"not get any table ");
            }
            sqlBuffer = sqlBuffer.append(" where 1 = 1 ");
            boolean querySentence = false;
            for (String field : conditions.keySet()) {
                String[] ps = field.split("&");
                if (ps.length == 1) {
                    if (field.startsWith("@")) continue;
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(field);
                    sqlBuffer = sqlBuffer.append(" = ");
                } else {
                    sqlBuffer = sqlBuffer.append(" and ");
                    sqlBuffer = sqlBuffer.append(ps[0]);
                    sqlBuffer = sqlBuffer.append(ps[1]);
                }
                sqlBuffer = sqlBuffer.append(conditions.get(field));
            }
            if (conditions.containsKey("@group")) {
                sqlBuffer = sqlBuffer.append(" group by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@group"));
            }
            if (conditions.containsKey("@order")) {
                sqlBuffer = sqlBuffer.append(" order by ");
                sqlBuffer = sqlBuffer.append(conditions.get("@order"));
            }
            sqlBuffer = sqlBuffer.append(" limit ");
            sqlBuffer = sqlBuffer.append(start);
            sqlBuffer = sqlBuffer.append(" , ");
            sqlBuffer = sqlBuffer.append(limit);
        }
        return sqlBuffer.toString();
    }

    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        for (String table : tables) {
            tableBuffer = tableBuffer.append(table);
            if (++index >= tables.size()) continue;
            tableBuffer = tableBuffer.append(",");
        }
        return tableBuffer.toString();
    }
}

