package com.qding.commnunity.common.weixin.service.impl;

import com.gemantic.common.util.OpenIDListUtil;
import com.gemantic.common.util.Sign;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.qding.common.util.*;
import com.qding.common.util.json.GsonUtil;
import com.qding.common.vo.ResponseVO;
import com.qding.community.common.weixin.parser.WxMsgKit;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.*;
import com.qding.community.common.weixin.vo.*;
import com.qding.community.common.weixin.vo.customservice.KfEntity;
import com.qding.community.common.weixin.vo.customservice.KfSend;
import com.qding.community.common.weixin.vo.customservice.RecKfSession;
import com.qding.community.common.weixin.vo.customservice.RecKfSessionEntity;
import com.qding.community.common.weixin.vo.pay.*;
import com.qding.community.common.weixin.vo.recv.RecvMessage;
import com.qding.community.common.weixin.vo.request.AppConfigParam;
import com.qding.community.common.weixin.vo.request.RequestParam;
import com.qding.community.common.weixin.vo.request.WxaCodeParam;
import com.qding.community.common.weixin.vo.send.SendMessage;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.*;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.json.JSONObject;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class WeiXinServiceImpl implements WeiXinService {
    private static final Log log = LogFactory.getLog(WeiXinServiceImpl.class);

    private static final Executor exec = Executors.newFixedThreadPool(3);
    private static final String WATERMARK = "watermark";
    private static final String APPID = "appid";

    /**
     * 存儲accessToken 一個半小時刷新一次。
     * 这里的刷新需要在 项目业务中手动调用 updateAccessToken（）方法刷新维护accessToken
     * 可在业务中写接口，通过linux的 crontab 定时任务执行脚本访问接口达到刷新accessToken的目的
     * accessToken 应在业务代码中存储到db里，只在一端更新，所有段均使用db中的accessToken，防止冲突
     * immediately 字段控制是否在启动的时候立即更新accessToken
     */
    private Map<String, String> accessTokenMap;
    private Map<String, String> appid_secret;
    private boolean immediately = true;
    private Map<String, String> jsapi_ticketMap;
    private String spAppId;
    private String spMchId;
    private String spMchApiKey;
    private String spCertPath;
    private String spP12CertPath;
    private String spPrivateKeyPath;
    private String spApiV3Key;
    private String serialNumber;
    private String outputFilePath;

    //配置项
    public WeiXinServiceImpl(Map<String, String> appid_secret, boolean immediately) {
        super();
        this.accessTokenMap = new HashMap<String, String>();
        this.jsapi_ticketMap = new HashMap<String, String>();
        this.appid_secret = appid_secret;
        this.immediately = immediately;
        log.info("appid_secret=" + appid_secret + " ," + "immediately=" + immediately);
        if (immediately) {
            for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
                this.updateAccessToken(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
                this.updateAccessToken(entry.getKey(), entry.getValue());
            }

        }
    }

    public WeiXinServiceImpl(String spAppId, String spMchId, String spMchApiKey, String spCertPath, String spP12CertPath, String spApiV3Key, String spPrivateKeyPath, String serialNumber, String outputFilePath, Map<String, String> appid_secret, boolean immediately) {
        super();
        this.accessTokenMap = new HashMap<String, String>();
        this.jsapi_ticketMap = new HashMap<String, String>();
        this.appid_secret = appid_secret;
        this.immediately = immediately;
        this.spAppId = spAppId;
        this.spMchId = spMchId;
        this.spApiV3Key = spApiV3Key;
        this.spMchApiKey = spMchApiKey;
        this.spCertPath = spCertPath;
        this.spPrivateKeyPath = spPrivateKeyPath;
        this.serialNumber = serialNumber;
        this.outputFilePath = outputFilePath;
        this.spP12CertPath = spP12CertPath;
        log.info("appid_secret=" + appid_secret + " ," + "immediately=" + immediately);
        if (DataUtils.isNotNullOrEmpty(outputFilePath)) {
            File file = new File(outputFilePath);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        if (DataUtils.isNotNullOrEmpty(immediately) && immediately) {
            for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
                this.updateAccessToken(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
                this.updateAccessToken(entry.getKey(), entry.getValue());
            }
        }
    }

    public WeiXinServiceImpl() {
        super();
        // TODO Auto-generated constructor stub
    }


    public Map<String, String> getAppid_secret() {
        return appid_secret;
    }

    public void setAppid_secret(Map<String, String> appid_secret) {
        this.appid_secret = appid_secret;
    }


    public Map<String, String> getAccessTokenMap() {
        return accessTokenMap;
    }

    public void setAccessTokenMap(Map<String, String> accessTokenMap) {
        this.accessTokenMap = accessTokenMap;
    }

    public Map<String, String> getJsapi_ticket() {
        return jsapi_ticketMap;
    }

    public void setJsapi_ticketMap(Map<String, String> jsapi_ticketMap) {
        this.jsapi_ticketMap = jsapi_ticketMap;
    }

    public boolean isImmediately() {
        return immediately;
    }

    public void setImmediately(boolean immediately) {
        this.immediately = immediately;
    }

    @Override
    public boolean access(String token, String signature, String timestamp,
                          String nonce) {
        List<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);

        Collections.sort(ss);

        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashUtil.sha1(builder.toString()));
    }

    @Override
    public RecvMessage recv(InputStream in) throws JDOMException, IOException {
        return WxMsgKit.parse(in);
    }

    @Override
    public void send(SendMessage msg, OutputStream out) throws JDOMException,
            IOException {
        Document doc = WxMsgKit.parse(msg);
        if (null != doc) {
            new XMLOutputter().output(doc, out);
        } else {
            Logger.getAnonymousLogger().warning("发送消息时,解析出dom为空 msg :" + msg);
        }
    }

    @Override
    public SendMessage builderSendByRecv(RecvMessage msg) {
        RecvMessage m = new RecvMessage(msg);
        String from = m.getFromUserName();
        m.setFromUserName(m.getToUserName());
        m.setToUserName(from);
        m.setCreateTime((System.currentTimeMillis() / 1000) + "");
        return new SendMessage(m);
    }

    @Override
    public boolean publishMenu(String appid, String secret, String menu) {
        String accessToken = getToken(appid, secret);

        boolean result = false;

        try {

            log.info(accessToken);
            String menuUrl = WeiXinPropertiesUtil.getProperty("menu");
            menuUrl = menuUrl.replace("{accessToken}", accessToken);
            log.info("menuUrl url is " + menuUrl);

            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(menuUrl, menu);
            log.info("generator:" + httpsresponse);
            String errcode = GsonUtil.get("errcode", httpsresponse);

            log.info("errcode is " + errcode);
            if ("0".equals(errcode)) {
                result = true;
            } else {

            }

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return result;
    }

    @Override
    public String getToken(String appid, String secret) {


        return this.accessTokenMap.get(appid);

    }

    @Override
    public void setToken(String appid, String token) {
        this.accessTokenMap.put(appid, token);
    }

    @Override
    public void putAppid_secret(String appid, String secret) {
        appid_secret.put(appid, secret);
    }

    @Override
    public void updateAccessToken(String appid, String secret) {

        String url = WeiXinPropertiesUtil.getProperty("token");
        url = url.replace("{appid}", appid);
        url = url.replace("{secret}", secret);
        log.info("token url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getToken:" + response);

        Long start = System.currentTimeMillis();
        log.info("load gson use time " + (System.currentTimeMillis() - start));
        String accessToken = GsonUtil.get("access_token", response);
        this.accessTokenMap.put(appid, accessToken);

        log.info(accessToken);

        updateJSAPITicket(appid, secret);

    }

    @Override
    public void updateAccessToken() {
        for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
            this.updateAccessToken(entry.getKey(), entry.getValue());
        }
    }


    private void updateJSAPITicket(String appid, String secret) {

        log.info("update jsapi jsAccessToken is " + this.accessTokenMap.get(appid));
        String jsapiURL = WeiXinPropertiesUtil.getProperty("jsapi");
        jsapiURL = jsapiURL.replace("{accessToken}", this.accessTokenMap.get(appid));

        log.info("upload_news url is " + jsapiURL);

        String response3 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                jsapiURL, null);

        log.info("appid " + appid + " secret " + secret + " result is "
                + response3);

        String jsapi_ticket = GsonUtil.get("ticket", response3);
        if (StringUtils.isBlank(jsapi_ticket)) {
            log.error("not get any ticket ");
        }

        log.info("get jsapi_ticket is  " + jsapi_ticket);
        this.jsapi_ticketMap.put(appid, jsapi_ticket);

    }

    @Override
    public String getQRTicket(String appid, String secret, Long sceneID, String sceneStr) {
        try {
            if (DataUtils.isNotNullOrEmpty(sceneID)) {
                if (sceneID > 100000L || sceneID < 0) {
                    log.error("id " + appid + " secret " + secret + " sceneID "
                            + sceneID + " is wrong format ");
                    return "";
                }
            }
            String accessToken = getToken(appid, secret);

            log.info(accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("qr");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info("getQrCodeUrl url is " + getQrCodeUrl);
            String sendData = "{\"action_name\": \"QR_LIMIT_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": "
                    + sceneID + "}}}";// 生成二维码的post_data
            if (DataUtils.isNotNullOrEmpty(sceneStr)) {
                log.info("sceneStr=" + sceneStr);
                sendData = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \""
                        + sceneStr + "\"}}}";// 生成二维码的post_data
            }
            log.info("send data is " + sendData);
            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(getQrCodeUrl, sendData);
            log.info("generator:" + httpsresponse);
            String ticket = GsonUtil.get("ticket", httpsresponse);
            return ticket;

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return "";

    }

    ;

    @Override
    public String createLimitQRCode(String ticket) {
        if (StringUtils.isBlank(ticket)) {
            return "";
        }

        try {

            String qcImgUrl = WeiXinPropertiesUtil.getProperty("qrImg");

            qcImgUrl = qcImgUrl.replace("{ticket}", ticket);

            return qcImgUrl;

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return "";

    }

    @Override
    public String createCodeRequestUrl(String appid, String secret, String url) {
        log.info(appid + " is appid, " + secret + " is secret and url is "
                + url);

        String codeUrl = WeiXinPropertiesUtil.getProperty("code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}",
                    URLEncoder.encode(url, "utf-8"));
        } catch (UnsupportedEncodingException e) {
            log.error("create code url failure " + appid + " is appid, "
                    + secret + " is secret and url is " + url);
            e.printStackTrace();
        }
        log.info("codeUrl url is " + codeUrl);

        return codeUrl;

    }

    @Override
    public String createUnscribeCodeRequestUrl(String appid, String secret,
                                               String url) {
        log.info(appid + " is appid, " + secret + " is secret and url is "
                + url);


        String codeUrl = WeiXinPropertiesUtil.getProperty("unscribe_code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}",
                    URLEncoder.encode(url, "utf-8"));
        } catch (UnsupportedEncodingException e) {
            log.error("create code url failure " + appid + " is appid, "
                    + secret + " is secret and url is " + url);
            e.printStackTrace();
        }
        log.info("codeUrl url is " + codeUrl);

        return codeUrl;

    }

    @Override
    public WXUser getUserInfo(String appid, String secret, String openID) {

        log.info(appid + " is appid, " + secret + " is secret and openID is "
                + openID);

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info("uinfo url is " + url);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getUserInfo:" + response2);

        String errCode = GsonUtil.get("errcode", response2);
        if (!"42001".equals(errCode)) {
            log.info("ok,not get any token refresh  ");

        } else {
            log.info("bad news .token maybe invalid,dont worry,lets refresh it");
            // refresh access token
            this.updateAccessToken(appid, secret);

            token = this.getToken(appid, secret);
            log.info("after refresh token is  " + token);
            response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                    url, null);

            log.info("after refresh response2 is  " + response2);

        }

        Gson gson = new GsonBuilder().create();

        WXUser user = gson.fromJson(response2, WXUser.class);
        ;

        return user;
    }

    @Override
    public List<WXUser> batchgetUserInfo(String appid, String secret, List<String> openidList) {

        List<WXUser> wxUserList = new ArrayList<WXUser>();
        log.info(appid + " is appid, " + secret + " is secret" + " ,openid size " + openidList.size());

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("batchgetUinfo");
        url = url.replace("{accessToken}", token);
        log.info("batchgetUinfo url is " + url);
        StringBuilder stringBuilder = new StringBuilder();
        for (String i : openidList) {
            stringBuilder.append("{\"openid\": \"").append(i).append("\",\"lang\": \"zh_CN\"}").append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
        String content = "{\n" +
                "    \"user_list\": [\n" +
                stringBuilder.toString() +
                "    ]\n" +
                "}";
        String response2 = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, content);
        log.info("batchgetUinfo:" + response2);
        JSONObject jsonObject = new JSONObject(response2);

        String result = jsonObject.getJSONArray("user_info_list").toString();
        Gson gson = new GsonBuilder().create();

        wxUserList = gson.fromJson(result, new TypeToken<List<WXUser>>() {
        }.getType());

        return wxUserList;
    }

    @Override
    public String getOpenID(String appid, String secret, String code) {

        String defaultOpenID = null;


        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info("code2TokenUrl url is " + code2TokenUrl);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                code2TokenUrl, null);
        log.info("code2TokenUrl:" + response2);

        defaultOpenID = GsonUtil.get("openid", response2);

        return defaultOpenID;
    }


    @Override
    public String getAppletOpenID(String appid, String secret, String code) {

        String defaultOpenID = null;

        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("appletcode2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info("code2TokenUrl url is " + code2TokenUrl);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                code2TokenUrl, null);
        log.info("code2TokenUrl:" + response2);

        defaultOpenID = GsonUtil.get("openid", response2);

        return defaultOpenID;

    }

    @Override
    public ResponseEntity wxaCode2Session(String appid, String secret, String code) {
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("appletcode2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid)
                .replace("{secret}", secret)
                .replace("{code}", code);
        log.info("code2TokenUrl url is " + code2TokenUrl);
        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                code2TokenUrl, null);
        log.info("code2TokenUrl:" + response2);
        return GsonUtil.fromJson(response2, ResponseEntity.class);

    }


    @Override
    public String sendCustomMessage(final String appid, final String secret,
                                    final String content, boolean asynchrony) {
        log.info("appid is " + appid + ",secret=" + secret + ",content is "
                + content);
        String result = "";
        final String token = this.getToken(appid, secret);
        if (asynchrony) {
            Runnable task = new Runnable() {
                @Override
                public void run() {

                    String url = WeiXinPropertiesUtil.getProperty("custom");
                    url = url.replace("{accessToken}", token);
                    log.info("url is " + url);

                    String httpsresponse = com.qding.common.util.HttpClientUtil
                            .sendPostRequestByJava(url, content);

                    log.info("generator:" + httpsresponse);

                }

            };
            exec.execute(task);
        } else {

            String url = WeiXinPropertiesUtil.getProperty("custom");
            url = url.replace("{accessToken}", token);
            log.info("url is " + url);

            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(url, content);

            log.info("generator:" + httpsresponse);
        }

        return result;
    }

    @Override
    public String sendTemplateMessage(String appid, String secret,
                                      final String content, boolean asynchrony) {
        log.info(appid + " is appid, " + secret + " is secret and content is "
                + content);
        String result = "";
        final String token = this.getToken(appid, secret);
        if (asynchrony) {
            Runnable task = new Runnable() {
                @Override
                public void run() {

                    String url = WeiXinPropertiesUtil.getProperty("template");
                    url = url.replace("{accessToken}", token);
                    log.info("url is " + url);
                    String httpsresponse = com.qding.common.util.HttpClientUtil
                            .sendPostRequestByJava(url, content);

                    log.info("generator:" + httpsresponse);
                }

            };
            exec.execute(task);
        } else {

            String url = WeiXinPropertiesUtil.getProperty("template");
            url = url.replace("{accessToken}", token);
            log.info("url is " + url);
            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(url, content);

            log.info("generator:" + httpsresponse);
            return httpsresponse;

        }

        return result;
    }

    @Override
    public String sendAppletMessage(String appid, String secret,
                                    final String content, boolean asynchrony) {
        log.info(appid + " is appid, " + secret + " is secret and content is "
                + content);
        String result = "";
        final String token = this.getToken(appid, secret);
        if (asynchrony) {
            Runnable task = new Runnable() {
                @Override
                public void run() {

                    String url = WeiXinPropertiesUtil.getProperty("applet");
                    url = url.replace("{accessToken}", token);
                    log.info("url is " + url);
                    String httpsresponse = com.qding.common.util.HttpClientUtil
                            .sendPostRequestByJava(url, content);

                    log.info("generator:" + httpsresponse);
                }

            };
            exec.execute(task);
        } else {

            String url = WeiXinPropertiesUtil.getProperty("applet");
            url = url.replace("{accessToken}", token);
            log.info("url is " + url);
            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(url, content);

            log.info("generator:" + httpsresponse);
            return httpsresponse;

        }

        return result;
    }

    @Override
    public ResponseEntity getPaidUnionId(AppConfigParam appConfigParam, RequestParam requestParam) {
        log.info("appConfigParam :" + appConfigParam.toString());
        log.info("requestParam :" + requestParam.toString());
        String token = appConfigParam.getToken();
        if (StringUtils.isBlank(appConfigParam.getToken())) {
            token = this.getToken(appConfigParam.getAppid(), null);
        }
        String url = WeiXinPropertiesUtil.getProperty("getPaidUnionId");
        url = url.replace("{accessToken}", token).replace("{openid}", requestParam.getOpenid())
                .concat(ObjectUtil.toUrlParams(requestParam, new String[]{"openid"}));
        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        return GsonUtil.fromJson(response2, ResponseEntity.class);
    }

    @Override
    public String getWxaCodeUnlimited(AppConfigParam appConfigParam, WxaCodeParam wxaCodeParam) {
        log.info("appConfigParam :" + appConfigParam.toString());
        log.info("wxaCodeParam :" + wxaCodeParam.toString());
        String token = appConfigParam.getToken();
        if (StringUtils.isBlank(appConfigParam.getToken())) {
            token = this.getToken(appConfigParam.getAppid(), null);
        }

        String url = WeiXinPropertiesUtil.getProperty("getUnlimited");
        url = url.replace("{accessToken}", token);

        ResponseVO responseVO = com.qding.common.util.HttpClientUtil.sendPostRequest(
                url, GsonUtil.toJson(wxaCodeParam));
        String responseStr = null;
        if (responseVO != null) {
            if (responseVO.getContentType().contains("application/json")) {
                responseStr = new String(responseVO.getBytes());
                log.info(responseStr);
            } else {
                BASE64Encoder encoder = new BASE64Encoder();
                responseStr = encoder.encode(responseVO.getBytes());
            }
        }

        return responseStr;


    }

    @Override
    public String decryptWxa(String appId, String encryptedData, String sessionKey, String iv) {
        String result = "";
        try {
            AES aes = new AES();
            BASE64Decoder base64Decoder = new BASE64Decoder();
            byte[] resultByte = aes.decrypt(base64Decoder.decodeBuffer(encryptedData), base64Decoder.decodeBuffer(sessionKey), base64Decoder.decodeBuffer(iv));
            if (null != resultByte && resultByte.length > 0) {
                result = new String(WxPKCS7Encoder.decode(resultByte));
                JSONObject jsonObject = new JSONObject(result);
                String decryptAppid = jsonObject.getJSONObject(WATERMARK).getString(APPID);
                if (!appId.equals(decryptAppid)) {
                    result = "";
                }
            }
        } catch (Exception e) {
            result = "";
            log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public boolean removeMenu(String appid, String secret) {
        boolean result = false;
        String token = this.getToken(appid, secret);
        String removeMenuUrl = WeiXinPropertiesUtil.getProperty("menu_delete");
        removeMenuUrl = removeMenuUrl.replace("{accessToken}", token);

        log.info("removeMenuUrl url is " + removeMenuUrl);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                removeMenuUrl, null);
        log.info("removeMenuUrl:" + response2);

        String errcode = GsonUtil.get("errcode", response2);
        log.info("errcode is " + errcode);
        if ("0".equals(errcode)) {
            result = true;
        } else {

        }
        return result;
    }

    @Override
    public String queryMenu(String appid, String secret) {

        String token = this.getToken(appid, secret);
        String queryMenuUrl = WeiXinPropertiesUtil.getProperty("menu_query");
        queryMenuUrl = queryMenuUrl.replace("{accessToken}", token);

        log.info("queryMenuUrl url is " + queryMenuUrl);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                queryMenuUrl, null);
        log.info("queryMenuUrl:" + response2);

        return response2;
    }

    @Override
    public SendMessage processMessage(SendMessage sendMsg, String url) {
        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);

        return sendMsg;
    }

    @Override
    public String uploadNews(String appid, String secret, String content) {
        try {

            String accessToken = getToken(appid, secret);

            log.info(appid + " and secret " + secret + " get accessToken is "
                    + accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil
                    .getProperty("upload_news");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info("upload_news url is " + getQrCodeUrl);

            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(getQrCodeUrl, content);
            log.info("generator:" + httpsresponse);
            String media_id = GsonUtil.get("media_id", httpsresponse);
            log.info(appid + " and secret " + secret + " get media_id is "
                    + media_id);
            return media_id;

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void massSendNewsMessageByOpenID(String appid, String secret,
                                            String content) {

        try {

            String accessToken = getToken(appid, secret);

            log.info(accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("mass");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info("mass url is " + getQrCodeUrl);

            log.info(appid + " and secret " + secret + " want send media "
                    + content + " want send data is " + content);

            String httpsresponse = com.qding.common.util.HttpClientUtil
                    .sendPostRequestByJava(getQrCodeUrl, content);
            log.info("generator:" + httpsresponse);

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    @Override
    public String uploadMedia(String appid, String secret, File file,
                              String type) {
        try {

            String accessToken = getToken(appid, secret);

            log.info(accessToken);
            String upload_media = WeiXinPropertiesUtil
                    .getProperty("upload_media");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{type}", accessToken);
            log.info("upload_news url is " + upload_media);

            String httpsresponse = HttpClientUtil.postFile(file, upload_media,
                    "media");

            String media_id = GsonUtil.get("media_id", httpsresponse);
            log.info("appid " + appid + " secret " + secret + " result is "
                    + httpsresponse);
            return media_id;
            /*
             * = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
             * upload_media, content); log.info("generator:" + httpsresponse);
             * String media_id = GsonUtil.get("media_id", httpsresponse); return
             * media_id;
             */

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String generateMassMPNewsMessage(String mediaID, List<String> openIDS) {

        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);

        String message = WeiXinPropertiesUtil.getProperty("mass_wpnews");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassTextMessage(String text, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);

        String message = WeiXinPropertiesUtil.getProperty("mass_text");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{content}", text);
        return message;
    }

    @Override
    public String generateMassVoiceMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);

        String message = WeiXinPropertiesUtil.getProperty("mass_voice");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassImgMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);

        String message = WeiXinPropertiesUtil.getProperty("mass_img");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public OpenIDList getOpenIDList(String appid, String secret,
                                    String next_openid) {
        try {

            String accessToken = getToken(appid, secret);

            log.info(accessToken);
            String upload_media = WeiXinPropertiesUtil
                    .getProperty("openID_list");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{next_openid}", next_openid);
            log.info("upload_news url is " + upload_media);

            String response2 = com.qding.common.util.HttpClientUtil
                    .sendGetRequest(upload_media, null);

            log.info("appid " + appid + " secret " + secret + " result is "
                    + response2);
            OpenIDList list = OpenIDListUtil.parseContent2OpenIDList(response2);
            return list;
            /*
             * = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
             * upload_media, content); log.info("generator:" + httpsresponse);
             * String media_id = GsonUtil.get("media_id", httpsresponse); return
             * media_id;
             */

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public JSAPI getJSAPI(String appid, String secret, String url) {
        try {

            // 注意 URL 一定要动态获取，不能 hardcode


            Map<String, String> ret = Sign.sign(this.jsapi_ticketMap.get(appid), url);
            log.info(ret);

            JSAPI jsapi = new JSAPI(appid, ret.get("timestamp"),
                    ret.get("nonceStr"), ret.get("signature"));

            return jsapi;

        } catch (Throwable e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

//	public static void main(String[] args) {
//		Map<String,String> map = new HashMap<String, String>();
//		map.put("wx53bc3d04623a459f", "f064bf113b7990e117e3b21aa6db5d55");
//		WeiXinServiceImpl wx = new WeiXinServiceImpl(map,true);
//
//		wx.getUserInfoByCode("wx53bc3d04623a459f", "f064bf113b7990e117e3b21aa6db5d55", "031zceXw0w3AKm1dR0Xw020aXw0zceXc");
//	}

    @Override
    public WXUser getUserInfoByCode(String appid, String secret, String code) {


        log.info(appid + " is appid, " + secret + " is secret and code is "
                + code);
        String defaultOpenID = null;

        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info("code2TokenUrl url is " + code2TokenUrl);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(code2TokenUrl, null);
        log.info("code2TokenUrl:" + response2);

        String token = GsonUtil.get("access_token", response2);
        String openID = GsonUtil.get("openid", response2);
        String url = WeiXinPropertiesUtil.getProperty("code_uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info("uinfo url is " + url);

        String response3 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getUserInfo:" + response3);


        Gson gson = new GsonBuilder().create();

        WXUser user = gson.fromJson(response3, WXUser.class);


        return user;

    }

    @Override
    public List<KfEntity> getKfList(String appid, String secret) {
        List<KfEntity> kfEntityList = new ArrayList<KfEntity>();
        log.info(appid + " is appid, " + secret + " is secret");

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kflist");
        url = url.replace("{accessToken}", token);
        log.info("getKfList url is " + url);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getKfList:" + response2);
        JSONObject jsonObject = new JSONObject(response2);

        String result = jsonObject.getJSONArray("kf_list").toString();
        Gson gson = new GsonBuilder().create();

        kfEntityList = gson.fromJson(result, new TypeToken<List<KfEntity>>() {
        }.getType());

        return kfEntityList;

    }

    @Override
    public List<KfEntity> getOnlineKfList(String appid, String secret) {
        List<KfEntity> kfEntityList = new ArrayList<KfEntity>();

        log.info(appid + " is appid, " + secret + " is secret");

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("onlinekflist");
        url = url.replace("{accessToken}", token);
        log.info("getKfList url is " + url);

        String response2 = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getKfList:" + response2);
        JSONObject jsonObject = new JSONObject(response2);
        String result = jsonObject.getJSONArray("kf_online_list").toString();
        log.info("result=" + result);
        Gson gson = new GsonBuilder().create();

        kfEntityList = gson.fromJson(result, new TypeToken<List<KfEntity>>() {
        }.getType());

        return kfEntityList;

    }

    @Override
    public ErrorMsg addKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();

        String sendData = kfSend.toJson();
        log.info(appid + " is appid, " + secret + " is secret, kfSend=" + sendData);

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount");
        url = url.replace("{accessToken}", token);
        log.info("getKfList url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, sendData);
        log.info("addKfAccount:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }

        return errorMsg;
    }

    @Override
    public ErrorMsg inviteKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info(appid + " is appid, " + secret + " is secret, kfSend=" + sendData);

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_inviteworker");
        url = url.replace("{accessToken}", token);
        log.info("inviteKfAccount url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, sendData);
        log.info("inviteKfAccount:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg updateKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();

        String sendData = kfSend.toJson();
        log.info(appid + " is appid, " + secret + " is secret, kfSend=" + sendData);

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_update");
        url = url.replace("{accessToken}", token);
        log.info("updateKfAccount url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, sendData);
        log.info("updateKfAccount:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;


    }

    @Override
    public ErrorMsg delKfAccount(String appid, String secret, String kfAccount) {
        ErrorMsg errorMsg = new ErrorMsg();

        log.info(appid + " is appid, " + secret + " is secret, kfAccount=" + kfAccount);

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_del");
        url = url.replace("{accessToken}", token);
        url = url.replace("{kfAccount}", kfAccount);
        log.info("kfaccount_del url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("updateKfAccount:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;

    }

    @Override
    public ErrorMsg createKfSession(String appid, String secret, KfSend kfSend) {

        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info(appid + " is appid, " + secret + " is secret, kfSend=" + sendData);


        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("create_kfsession");
        url = url.replace("{accessToken}", token);
        log.info("createKfSession url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, sendData);
        log.info("createKfSession:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;

    }

    @Override
    public ErrorMsg closeKfSession(String appid, String secret, KfSend kfSend) {

        ErrorMsg errorMsg = new ErrorMsg();

        String sendData = kfSend.toJson();
        log.info(appid + " is appid, " + secret + " is secret, kfSend=" + sendData);


        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("close_kfsession");
        url = url.replace("{accessToken}", token);
        log.info("closeKfSession url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, sendData);
        log.info("closeKfSession:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));

        } catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;

    }

    @Override
    public RecKfSessionEntity getKfSession(String appid, String secret, String openid) {
        RecKfSessionEntity recKfSessionEntity = new RecKfSessionEntity();

        log.info(appid + " is appid, " + secret + " is secret, openid=" + openid);


        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("get_kfsession");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openid);
        log.info("getKfSession url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getKfSession:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        if ("0".equals(errcode)) {
            Gson gson = new GsonBuilder().create();
            recKfSessionEntity = gson.fromJson(response, RecKfSessionEntity.class);
        } else {

        }
        return recKfSessionEntity;

    }

    @Override
    public List<RecKfSessionEntity> getKfSessionList(String appid, String secret, String kfAccount) {
        List<RecKfSessionEntity> recKfSessionEntityList = new ArrayList<RecKfSessionEntity>();

        log.info(appid + " is appid, " + secret + " is secret, kfAccount=" + kfAccount);


        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("list_kfsession");
        url = url.replace("{accessToken}", token);
        url = url.replace("{kfAccount}", kfAccount);
        log.info("getKfSession url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getKfSession:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        if ("0".equals(errcode)) {
            JSONObject jsonObject = new JSONObject(response);
            String result = jsonObject.getJSONArray("sessionlist").toString();
            Gson gson = new GsonBuilder().create();
            recKfSessionEntityList = gson.fromJson(result, new TypeToken<List<RecKfSessionEntity>>() {
            }.getType());
        } else {

        }

        return recKfSessionEntityList;

    }

    @Override
    public RecKfSession getWaitcaseKfSessionList(String appid, String secret) {
        RecKfSession recKfSession = new RecKfSession();

        log.info(appid + " is appid, " + secret + " is secret");

        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("wait_kfsession");
        url = url.replace("{accessToken}", token);
        log.info("getWaitcaseKfSessionList url is " + url);

        String response = com.qding.common.util.HttpClientUtil.sendGetRequest(
                url, null);
        log.info("getWaitcaseKfSessionList:" + response);
        String errcode = GsonUtil.get("errcode", response);

        log.info("errcode is " + errcode);
        if ("0".equals(errcode)) {
            Gson gson = new GsonBuilder().create();
            recKfSession = gson.fromJson(response, RecKfSession.class);
        } else {

        }
        return recKfSession;
    }

    @Override
    public Map<String, Object> partnerPayV3(PayParam payParam, String type) {
        //不需要传入微信支付证书，将会自动更新
        //merchantSerialNumber证书序列号
        //私钥merchantPrivateKey
        Map<String, Object> signMap = new HashMap<String, Object>();
        payParam.setSp_appid(spAppId);
        payParam.setSp_mchid(spMchId);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            WechatPayHttpClientBuilder builder = wechatPayHttpClientBuilder(true);
            //读取平台证书
            File file = new File(outputFilePath);
            List<X509Certificate> certificates = new ArrayList<X509Certificate>();
            if (file.isDirectory() && file.listFiles() != null) {
                for (File item : file.listFiles()) {
                    if (item.isFile() && "pem".equals(item.getName().substring(item.getName().lastIndexOf(".") + 1))) {
                        log.info("cert:" + item.getName());
                        certificates.add(PemUtil.loadCertificate(new ByteArrayInputStream(FileUtils.readFileToByteArray(item))));
                    }
                }
            }
            builder.withWechatpay(certificates);
            // 通过WechatPayHttpClientBuilder构造的HttpClient，会自动的处理签名和验签，并进行证书自动更新
            httpClient = builder.build();
//        HttpResponse response = httpClient.execute(...);
            String url = WeiXinPropertiesUtil.getProperty("partner_pay_v3");
            url = url.replace("{TYPE}", type);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
            StringEntity reqEntity = new StringEntity(GsonUtil.toJson(payParam), ContentType.create("application/json", "utf-8"));
            httpPost.setEntity(reqEntity);
            String result = null;
            response = httpClient.execute(httpPost);

            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                result = EntityUtils.toString(response.getEntity());// 返回json格式：
                log.info("微信支付V3 url=" + url + " result=" + result + "params=" + GsonUtil.toJson(payParam));
                Map map = GsonUtil.fromJson(result, Map.class);
                if (map.containsKey("prepay_id")) {
                    log.info(map.get("prepay_id"));
//                    Sign.getToken()]
                    //签名
                    PrivateKey privateKey = Sign.loadPrivateKey(spPrivateKeyPath);
                    signMap = Sign.getToken(payParam.getSub_appid(), null, "prepay_id=" + map.get("prepay_id"), spMchId, serialNumber, privateKey);
                    signMap.put("prepay_id", map.get("prepay_id"));
                    signMap.put("message", "success");
                }
            } else {
                result = EntityUtils.toString(response.getEntity());// 返回json格式：
                log.info("微信支付V3 url=" + url + " result=" + result);
                signMap.put("message", result);
            }
            return signMap;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }

            if (httpClient != null) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public Map<String, Object> refund(RefundInfo refundInfo, String type) {
//
//		WeixinConfig wxConfig = WeixinConfig.getInstance();
//		String nonce_str = new StringWidthWeightRandom().getNextString(32);
//
//		RefundInfo refundInfo = new RefundInfo();
//
//		refundInfo.setAppid(wxConfig.getAppid());
//		refundInfo.setMch_id(wxConfig.getMch_id());
//		refundInfo.setNonce_str(nonce_str);
//		refundInfo.setNotify_url(wxConfig.getWx_refund_notify_url());
//		refundInfo.setRefund_desc(refundParams.getRefund_desc());
//		refundInfo.setRefund_fee(refundParams.getRefund_fee());
//		refundInfo.setTotal_fee(refundParams.getTotal_fee());
//		refundInfo.setTransaction_id(refundParams.getTransaction_id());
//		refundInfo.setOut_refund_no(refundParams.getOut_refund_no());
        Map<String, Object> signMap = new HashMap<String, Object>();
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;

        try {
            WechatPayHttpClientBuilder builder = wechatPayHttpClientBuilder(true);
            //读取平台证书
            File file = new File(outputFilePath);
            List<X509Certificate> certificates = new ArrayList<X509Certificate>();
            if (file.isDirectory() && file.listFiles() != null) {
                for (File item : file.listFiles()) {
                    if (item.isFile() && "pem".equals(item.getName().substring(item.getName().lastIndexOf(".") + 1))) {
                        log.info("cert:" + item.getName());
                        certificates.add(PemUtil.loadCertificate(new ByteArrayInputStream(FileUtils.readFileToByteArray(item))));
                    }
                }
            }
            builder.withWechatpay(certificates);
            httpClient = builder.build();
//        HttpResponse response = httpClient.execute(...);
            String url = WeiXinPropertiesUtil.getProperty("refund");
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/json");
//			StringEntity reqEntity = new StringEntity(GsonUtil.toJson(payParam), ContentType.create("application/json", "utf-8"));
//			httpPost.setEntity(reqEntity);
            String result = null;
            response = httpClient.execute(httpPost);


        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }

            if (httpClient != null) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }
        }


        return null;
    }

    @Override
    public String decryptV3(String associatedData, String nonce, String ciphertext) throws GeneralSecurityException, IOException {
        AesUtil aesUtil = new AesUtil(spApiV3Key.getBytes());
        return aesUtil.decryptToString(associatedData.getBytes(), nonce.getBytes(), ciphertext);
    }

    @Override
    public void downloadPlatformCertificate() {
        log.info("apiV3key=" + spApiV3Key);
        log.info("privateKey file path=" + spPrivateKeyPath);
        log.info("merchant's certificate serial number" + serialNumber);
        try {
            log.info("=== download begin ===");
            List<PlainCertificateItem> plainCerts = downloadCertificate(false);
            log.info("=== download done ===");

            if (plainCerts != null) {
                log.info("=== save begin ===");
                saveCertificate(plainCerts);
                log.info("=== save done ===");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public String profitSharing(String subMchId, String transactionId, String outOrderNo, List<Receiver> receivers, String subAppId) {
        String url = WeiXinPropertiesUtil.getProperty("profit_sharing");
        return profitSharingReq(url, subMchId, null, receivers, transactionId, outOrderNo, null, spAppId, subAppId);
    }

    @Override
    public String multiProfitSharing(String subMchId, String appId, String transactionId, String outOrderNo, List<Receiver> receivers, String subAppId) {
        String url = WeiXinPropertiesUtil.getProperty("multiprofitsharing");
        return profitSharingReq(url, subMchId, null, receivers, transactionId, outOrderNo, null, spAppId, subAppId);
    }

    @Override
    public String profitSharingAddReceiver(String subMchId, Receiver receiver, String subAppId) {
        String url = WeiXinPropertiesUtil.getProperty("profit_sharing_add_dreceiver");
        return profitSharingReq(url, subMchId, receiver, null, null, null, null, spAppId, subAppId);
    }

    @Override
    public String profitSharingReturn(String appId, String subAppId, String subMchId, String orderId, String outOrderNo, String outReturnNo, String returnAccount,
                                      Integer returnAmount, String description) {

        String url = WeiXinPropertiesUtil.getProperty("profitsharing_return");
        return profitSharingReturnReq(url, appId, subAppId, subMchId, orderId, outOrderNo, outReturnNo, returnAccount, returnAmount, description);
    }

    @Override
    public String refund(String appId, String subMchId, String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee, String notifyUrl) {
        String url = WeiXinPropertiesUtil.getProperty("refund");
        return refundReq(url, appId,subMchId, transactionId, outTradeNo, outRefundNo, totalFee, refundFee,notifyUrl);
    }

    public String refundReq(String url, String appId, String subMchId, String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee,String notifyUrl) {

        String result = null;
        try {

            Map<String, String> map = new TreeMap<String, String>();
            map.put("appid", appId);
            map.put("mch_id", spMchId);
            map.put("nonce_str", Sign.getRandomStringByLength(32));
            if (StringUtils.isNotEmpty(subMchId)) {
                map.put("sub_mch_id", subMchId);
            }
            map.put("sign_type", "HMAC-SHA256");
            if (StringUtils.isNotEmpty(outTradeNo)) {
                map.put("out_trade_no", outTradeNo);
            }
            if (StringUtils.isNotEmpty(outRefundNo)) {
                map.put("out_refund_no", outRefundNo);
            }
            map.put("refund_fee", refundFee + "");
            map.put("total_fee", totalFee + "");
            map.put("transaction_id", transactionId);
            map.put("notify_url", notifyUrl);
            map = MapUtil.removeAllNullValueEntry(map);
            String stringSignTemp = Sign.createSign(map, false) + "&key=" + spMchApiKey;
            String sign = HMACSHA256(stringSignTemp, spMchApiKey).toUpperCase();
            map.put("sign", sign);
            log.info("sign=" + sign);
            log.info("stringSignTemp=" + stringSignTemp);

            String xml = XmlUtil.xmlFormat(new TreeMap<String, String>(map), false);
            log.info("xml=" + xml);
            result = HttpClientUtil.sslPost(url, xml, spP12CertPath, spMchId);
            log.info("result=" + result);
        } catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    public String profitSharingReturnReq(String url, String appId, String subAppId, String subMchId, String orderId, String outOrderNo, String outReturnNo, String returnAccount,
                                         Integer returnAmount, String description) {

        String result = null;
        try {

            Map<String, String> map = new TreeMap<String, String>();
            map.put("mch_id", spMchId);
            map.put("sub_mch_id", subMchId);
            map.put("appid", appId);
            map.put("sub_appid", subAppId);
            map.put("nonce_str", Sign.getRandomStringByLength(32));
            String stringSignTemp = Sign.createSign(map, false) + "&key=" + spMchApiKey;
            String sign = HMACSHA256(stringSignTemp, spMchApiKey).toUpperCase();
            log.info("sign=" + sign);
            map.put("sign", sign);
            map.put("sign_type", "HMAC-SHA256");
            map.put("order_id", orderId);
            map.put("out_order_no", outOrderNo);
            map.put("out_return_no", outReturnNo);
            map.put("return_account", returnAccount);
            map.put("return_amount", returnAmount + "");
            map.put("description", description);
            map = MapUtil.removeAllNullValueEntry(map);
            log.info("stringSignTemp=" + stringSignTemp);

            String xml = XmlUtil.xmlFormat(new TreeMap<String, String>(map), false);
            log.info("xml=" + xml);
            result = HttpClientUtil.sslPost(url, xml, spP12CertPath, spMchId);
            log.info("result=" + result);
        } catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return result;

    }

    public String profitSharingReq(String url, String subMchId, Receiver receiver, List<Receiver> receivers, String transactionId, String outOrderNo, String description, String appId, String subAppId) {
        String result = null;
        try {

            String receiversJson = null;
            if (CollectionUtils.isNotEmpty(receivers)) {
                receiversJson = GsonUtil.toJson(receivers);
            }
            String receiverJson = null;
            if (null != receiver) {
                receiverJson = GsonUtil.toJson(receiver);
            }
            Map<String, String> map = new TreeMap<String, String>();
            map.put("appid", appId);
            map.put("mch_id", spMchId);
            map.put("sub_appid", subAppId);
            map.put("sub_mch_id", subMchId);
            map.put("nonce_str", Sign.getRandomStringByLength(32));
            map.put("sign_type", "HMAC-SHA256");
            map.put("receivers", receiversJson);
            map.put("receiver", receiverJson);
            map.put("transaction_id", transactionId);
            map.put("out_order_no", outOrderNo);
            map.put("description", description);
            map = MapUtil.removeAllNullValueEntry(map);
            String stringSignTemp = Sign.createSign(map, false) + "&key=" + spMchApiKey;
            log.info("stringSignTemp=" + stringSignTemp);

            String sign = HMACSHA256(stringSignTemp, spMchApiKey).toUpperCase();
            log.info("sign=" + sign);
            map.put("sign", sign);
            String xml = XmlUtil.xmlFormat(new TreeMap<String, String>(map), false);
            log.info("xml=" + xml);
            result = HttpClientUtil.sslPost(url, xml, spP12CertPath, spMchId);
            log.info("result=" + result);
        } catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String profitSharingRemoveReceiver(String subMchId, Receiver receiver, String subAppId) {
        String url = WeiXinPropertiesUtil.getProperty("profitsharingremovereceiver");
        return profitSharingReq(url, subMchId, receiver, null, null, null, null, spAppId, subAppId);
    }

    public static String HMACSHA256(String data, String key) throws Exception {

        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");

        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");

        sha256_HMAC.init(secret_key);

        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));

        StringBuilder sb = new StringBuilder();

        for (byte item : array) {

            sb.append(Integer.toHexString((item & 0xFF) | 0x100).substring(1, 3));

        }

        return sb.toString().toUpperCase();

    }

    @Override
    public String profitSharingFinish(String subMchId, String transactionId, String outOrderNo, String description) {
        String url = WeiXinPropertiesUtil.getProperty("profit_sharing_finish");
        return profitSharingReq(url, subMchId, null, null, transactionId, outOrderNo, description, spAppId, null);
    }

    @Override
    public String profitSharingMerchantRatioQuery(String subMchId) {
        String url = WeiXinPropertiesUtil.getProperty("profitsharingmerchantratioquery");
        return profitSharingReq(url, subMchId, null, null, null, null, null, null, null);
    }

    @Override
    public String profitSharingOrderAmountQuery(String transactionId) {
        String url = WeiXinPropertiesUtil.getProperty("profitsharingorderamountquery");
        return profitSharingReq(url, null, null, null, transactionId, null, null, null, null);
    }

    @Override
    public String sendSubscribeMessage(String appId, SubscribeMessage subscribeMessage) {
        String token = this.getToken(appId, null);
        String url = WeiXinPropertiesUtil.getProperty("subscribe_message");
        url = url.replace("{accessToken}", token);
        log.info("subscribe message data is " + subscribeMessage.toString());
        String response = com.qding.common.util.HttpClientUtil.sendPostRequestByJava(
                url, subscribeMessage.toString());
        return response;
    }


    private WechatPayHttpClientBuilder wechatPayHttpClientBuilder(boolean autoVerifier) throws IOException {
        //不需要传入微信支付证书，将会自动更新
        //merchantSerialNumber证书序列号
        //私钥merchantPrivateKey
        PrivateKey merchantPrivateKey;
        merchantPrivateKey = Sign.loadPrivateKey(spPrivateKeyPath);
        WechatPayHttpClientBuilder builder = WechatPayHttpClientBuilder.create()
                .withMerchant(spMchId, serialNumber, merchantPrivateKey);
        AutoUpdateCertificatesVerifier verifier = null;
        //不需要传入微信支付证书，将会自动更新
        if (autoVerifier) {
            verifier = new AutoUpdateCertificatesVerifier(
                    new WechatPay2Credentials(spMchId, new PrivateKeySigner(serialNumber, merchantPrivateKey)),
                    spApiV3Key.getBytes("utf-8"));
            builder.withValidator(new WechatPay2Validator(verifier));
        }

        return builder;
    }

    private List<PlainCertificateItem> downloadCertificate(boolean check) throws IOException, GeneralSecurityException {
        WechatPayHttpClientBuilder builder = wechatPayHttpClientBuilder(true);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            if (!check) {
                //不做验签
                builder.withValidator(new Validator() {
                    @Override
                    public boolean validate(CloseableHttpResponse response) throws IOException {
                        return true;
                    }
                });
            } else {
                List<X509Certificate> certs = new ArrayList<X509Certificate>();
                certs.add(PemUtil.loadCertificate(new FileInputStream(spCertPath)));
                builder.withWechatpay(certs);
            }

            HttpGet httpGet = new HttpGet(WeiXinPropertiesUtil.getProperty("cert_download_path"));
            httpGet.addHeader("Accept", "application/json");


            httpClient = builder.build();
            response = httpClient.execute(httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString(response.getEntity());
            if (statusCode == 200) {
                System.out.println("body:" + body);
                //时间格式转换
                CertificateList certList = JsonUtils.convertJsonToCertList(body);
//                        GsonUtil.fromJson(body,CertificateList.class);

                return decryptAndValidate(certList, response);
            } else {
                System.out.println("download failed,resp code=" + statusCode + ",body=" + body);
                throw new IOException("request failed");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }

            if (httpClient != null) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), e);
                }
            }
        }
        return new ArrayList<PlainCertificateItem>();
    }

    private List<PlainCertificateItem> decryptAndValidate(CertificateList certList, CloseableHttpResponse response) throws GeneralSecurityException, IOException {
        List<PlainCertificateItem> plainCerts = new ArrayList<PlainCertificateItem>();
        List<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        AesUtil decryptor = new AesUtil(spApiV3Key.getBytes("UTF-8"));
        for (CertificateItem item : certList.getCerts()) {
            PlainCertificateItem plainCert = new PlainCertificateItem(
                    item.getSerialNo(), item.getEffectiveTime(), item.getExpireTime(),
                    decryptor.decryptToString(
                            item.getEncryptCertificate().getAssociatedData().getBytes("UTF-8"),
                            item.getEncryptCertificate().getNonce().getBytes("UTF-8"),
                            item.getEncryptCertificate().getCiphertext()));
            System.out.println(plainCert.getPlainCertificate());

            ByteArrayInputStream inputStream = new ByteArrayInputStream(plainCert.getPlainCertificate().getBytes("UTF-8"));
            X509Certificate x509Cert = PemUtil.loadCertificate(inputStream);
            plainCerts.add(plainCert);
            x509Certs.add(x509Cert);
        }

        //从下载的证书中，获取对报文签名的私钥所对应的证书，并进行验签来验证证书准确
        Verifier verifier = new CertificatesVerifier(x509Certs);
        Validator validator = new WechatPay2Validator(verifier);
        boolean isCorrectCert = validator.validate(response);
        System.out.println(isCorrectCert ? "=== validate success ===" : "=== validate failed ===");
        return isCorrectCert ? plainCerts : null;
    }

    private void saveCertificate(List<PlainCertificateItem> cert) throws IOException {
        File file = new File(outputFilePath);
        file.mkdirs();
        for (PlainCertificateItem item : cert) {
            String outputAbsoluteFilename = file.getAbsolutePath() + File.separator + "wechatpay_" + item.getSerialNo() + ".pem";


            BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(new FileOutputStream(outputAbsoluteFilename), "UTF-8"));
            writer.write(item.getPlainCertificate());
            writer.flush();
            writer.close();

            System.out.println("save cert file absolute path = " + outputAbsoluteFilename);
        }
    }
}
