package com.qding.community.common.weixin.vo;

import org.apache.commons.lang.StringUtils;

import java.util.Map;

public class SubscribeMessage {

    /**
     * touser : OPENID
     * template_id : TEMPLATE_ID
     * page : index
     * miniprogram_state : developer
     * lang : zh_CN
     * data : {"number01":{"value":"339208499"},"date01":{"value":"2015年01月05日"},"site01":{"value":"TIT创意园"},"site02":{"value":"广州市新港中路397号"}}
     */
    public final String STATE_DEVELOPER = "developer";
    public final String STATE_TRIAL = "trial";
    public final String STATE_FORMAL = "formal";
    private String touser;
    private String template_id;
    private String page;
    private String miniprogram_state;
    private String lang;
    private Map<String, Object> data;


    public SubscribeMessage(String touser, String template_id, Map<String, Object> data) {
        this.touser = touser;
        this.template_id = template_id;
        this.data = data;
    }
    public String getTouser() {
        return touser;
    }

    public void setTouser(String touser) {
        this.touser = touser;
    }

    public String getTemplate_id() {
        return template_id;
    }

    public void setTemplate_id(String template_id) {
        this.template_id = template_id;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getMiniprogram_state() {
        return miniprogram_state;
    }

    public void setMiniprogram_state(String miniprogram_state) {
        this.miniprogram_state = miniprogram_state;
    }

    public String getLang() {
        return lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("{");
        sb.append("\"touser\":\"")
                .append(touser).append('\"');
        sb.append(",\"template_id\":\"")
                .append(template_id).append('\"');
        if (StringUtils.isNotBlank(page)) {
            sb.append(",\"page\":\"")
                    .append(page).append('\"');
        }
        if (StringUtils.isNotBlank(miniprogram_state)) {
            sb.append(",\"miniprogram_state\":\"")
                    .append(miniprogram_state).append('\"');
        }
        if (StringUtils.isNotBlank(lang)) {
            sb.append(",\"lang\":\"")
                    .append(lang).append('\"');
        }

        sb.append(",\"data\":{");
        for (Map.Entry entry : data.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":{\"value\":\"").append(entry.getValue()).append("\"}").append(",");
        }
        sb.append('}');

        sb.append('}');
        return sb.toString();
    }
}
