package com.qding.community.common.weixin.constant;

public class Constant {
    public enum PayType {
        APP("app"),JSAPI("jsapi"),NATIVE("native"), H5("h5"),;
        private final String code;
        PayType(String code){
            this.code = code;
        }
        public String getCode() {
            return this.code;
        }
    }
    public enum EventType {
        PAY_SUCCESS("TRANSACTION.SUCCESS");
        private final String code;
        EventType(String code){
            this.code = code;
        }
        public String getCode() {
            return this.code;
        }
    }
    //交易类型，枚举值：
    public enum TradeType {
        JSAPI("JSAPI"),NATIVE("NATIVE"),APP("APP"), MICROPAY("MICROPAY"),MWEB("MWEB"),FACEPAY("FACEPAY");
        private final String code;
        TradeType(String code){
            this.code = code;
        }
        public String getCode() {
            return this.code;
        }
    }
    //交易状态，枚举值
    /**
     * 交易状态，枚举值：
     * SUCCESS：支付成功
     * REFUND：转入退款
     * NOTPAY：未支付
     * CLOSED：已关闭
     * REVOKED：已撤销（付款码支付）
     * USERPAYING：用户支付中（付款码支付）
     * PAYERROR：支付失败(其他原因，如银行返回失败)
    * */
    public enum TradeState {
        SUCCESS("SUCCESS"),REFUND("REFUND"),NOTPAY("NOTPAY"), CLOSED("CLOSED"),REVOKED("REVOKED"),USERPAYING("USERPAYING"),PAYERROR("PAYERROR");
        private final String code;
        TradeState(String code){
            this.code = code;
        }
        public String getCode() {
            return this.code;
        }
    }
}
