/*
 * Decompiled with CFR 0.152.
 */
package com.qding.community.common.weixin.vo.send;

import com.qding.common.util.DataUtils;
import com.qding.common.util.XmlUtil;
import com.qding.community.common.weixin.parser.WxMsgKit;
import com.qding.community.common.weixin.vo.Message;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.jdom.Element;

public class SendMessage
extends Message {
    private static final Log log = LogFactory.getLog(WxMsgKit.class);
    private boolean star;

    public SendMessage(String toUserName, String fromUserName, String createTime, String msgType, boolean star) {
        super(toUserName, fromUserName, createTime, msgType);
        this.star = star;
    }

    public SendMessage(Message msg) {
        this(msg.getToUserName(), msg.getFromUserName(), msg.getCreateTime(), msg.getMsgType(), false);
    }

    public SendMessage(SendMessage msg) {
        this(msg.getToUserName(), msg.getFromUserName(), msg.getCreateTime(), msg.getMsgType(), msg.isStar());
    }

    public boolean isStar() {
        return this.star;
    }

    public void setStar(boolean star) {
        this.star = star;
    }

    public org.jdom.Document toDocument() {
        org.jdom.Document doc = new org.jdom.Document();
        Element root = new Element("xml");
        doc.setRootElement(root);
        SendMessage.createElement(root, "ToUserName", this.getToUserName());
        SendMessage.createElement(root, "FromUserName", this.getFromUserName());
        SendMessage.createElement(root, "CreateTime", this.getCreateTime());
        SendMessage.createElement(root, "MsgType", this.getMsgType());
        SendMessage.createElement(root, "FuncFlag", this.isStar() ? "1" : "0");
        return doc;
    }

    public String toXmlString(String kfAccount) {
        Document document = XmlUtil.createDocument((String)"xml");
        XmlUtil.insertElement((String)"ToUserName", (String)this.getToUserName(), (Document)document, (boolean)true);
        XmlUtil.insertElement((String)"FromUserName", (String)this.getFromUserName(), (Document)document, (boolean)true);
        XmlUtil.insertElement((String)"CreateTime", (String)this.getCreateTime(), (Document)document, (boolean)false);
        XmlUtil.insertElement((String)"MsgType", (String)this.getMsgType(), (Document)document, (boolean)true);
        if (DataUtils.isNotNullOrEmpty((Object)kfAccount)) {
            XmlUtil.insertElement((String)"TransInfo", (String)("<KfAccount><![CDATA[" + kfAccount + "]]></KfAccount>"), (Document)document, (boolean)true);
        }
        document.getRootElement().asXML();
        return XmlUtil.docToString((Document)document);
    }

    protected static Element createElement(Element parent, String name, String value) {
        Element elem = new Element(name);
        elem.setText(value);
        parent.getChildren().add(elem);
        return elem;
    }

    public static void main(String[] args) throws TransformerException {
        org.jdom.Document doc = new org.jdom.Document();
        Element root = new Element("xml");
        doc.setRootElement(root);
        SendMessage.createElement(root, "ToUserName", "2");
        SendMessage.createElement(root, "FromUserName", "2");
        SendMessage.createElement(root, "CreateTime", "2");
        SendMessage.createElement(root, "MsgType", "2");
        SendMessage.createElement(root, "FuncFlag", "2");
        log.info((Object)doc.toString());
        SendMessage sendMessage = new SendMessage("1", "1", "1", "1", false);
        log.info((Object)sendMessage.toXmlString("kf2001"));
    }
}

