package com.qding.community.common.weixin.util;


import com.google.gson.*;
import com.qding.common.util.TimeUtil;
import com.qding.community.common.weixin.vo.pay.CertificateList;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author: chen
 * @date: 2019/7/24
 **/
public class JsonUtils {

    private static GsonBuilder builder = new GsonBuilder();
    private static Gson gson;

    static {
        gson = builder
                .registerTypeAdapter(Date.class, new OffsetDateTimeTypeAdapter())
                .create();
    }

    public static CertificateList convertJsonToCertList(String target) {
        return gson.fromJson(target, CertificateList.class);
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter implements JsonSerializer, JsonDeserializer {


        @Override
        public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                String oldDate= jsonElement.getAsJsonPrimitive().getAsString();
                DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                Date date = df.parse(oldDate);
                return date;

            } catch (ParseException e) {
                e.printStackTrace();
            }
            return null;

        }

        @Override
        public JsonElement serialize(Object o, Type type, JsonSerializationContext jsonSerializationContext) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            return new JsonPrimitive(sdf.format(o));
        }
    }

    public static void main(String[] args) {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        Date date = null;
        try {
            date = df.parse("2021-01-05T17:04:28+08:00");
            System.out.println(TimeUtil.convertLong2String(date.getTime(), "yyyy-MM-dd HH:mm:ss"));

        } catch (ParseException e) {
            e.printStackTrace();
        }

    }

}
