package com.qding.community.common.weixin.service;

import com.qding.community.common.weixin.vo.*;
import com.qding.community.common.weixin.vo.customservice.KfEntity;
import com.qding.community.common.weixin.vo.customservice.KfSend;
import com.qding.community.common.weixin.vo.customservice.RecKfSession;
import com.qding.community.common.weixin.vo.customservice.RecKfSessionEntity;
import com.qding.community.common.weixin.vo.pay.PayParam;
import com.qding.community.common.weixin.vo.pay.Receiver;
import com.qding.community.common.weixin.vo.recv.RecvMessage;
import com.qding.community.common.weixin.vo.request.AppConfigParam;
import com.qding.community.common.weixin.vo.request.RequestParam;
import com.qding.community.common.weixin.vo.request.WxaCodeParam;
import com.qding.community.common.weixin.vo.send.SendMessage;
import org.jdom.JDOMException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;

public interface WeiXinService {

	static public String Access_Type_Page = "page";
	static public String Access_Type_Normal = "normal";

	public boolean access(String token, String signature, String timestamp,
			String nonce);

	public RecvMessage recv(InputStream in) throws JDOMException, IOException;

	public void send(SendMessage msg, OutputStream out) throws JDOMException,
			IOException;

	public SendMessage builderSendByRecv(RecvMessage msg);

	public boolean publishMenu(String appid, String secret, String menu);

	public boolean removeMenu(String appid, String secret);

	public String queryMenu(String appid, String secret);

	public String getToken(String appid, String secret);
	public void setToken(String appid, String token);
    //追加app维护配置
	public void putAppid_secret(String appid, String secret);

	public String getQRTicket(String appid, String secret, Long sceneID,String sceneStr);

	public String createLimitQRCode(String ticket);

	public String createCodeRequestUrl(String appid, String secret, String url);

	public String createUnscribeCodeRequestUrl(String appid, String secret,
			String url);

	public String getOpenID(String appid, String secret, String code);

	public String getAppletOpenID(String appid, String secret, String code);
	/**
	 * 登录凭证校验。通过 wx.login 接口获得临时登录凭证 code 后传到开发者服务器调用此接口完成登录流程
	 *
	 * @param appid
	 * @param secret
	 * @param code
	 * @return ResponseEntity
	 */
	public ResponseEntity wxaCode2Session(String appid, String secret, String code);

	public WXUser getUserInfo(String appid, String secret, String openID
			);
	public List<WXUser> batchgetUserInfo(String appid, String secret, List<String> openidList
			);

	
	public WXUser getUserInfoByCode(String appid, String secret, String code);

	public String sendTemplateMessage(String appid, String secret,
			String content, boolean asynchrony);

	public SendMessage processMessage(SendMessage sendMsg, String url);

	public String sendCustomMessage(String appid, String secret,
			String content, boolean asynchrony);

	public String sendAppletMessage(String appid, String secret,
								  String content, boolean asynchrony);

	/**
	 * 用户支付完成后，获取该用户的 UnionId，无需用户授权
	 * 调用前需要用户完成支付，且在支付后的五分钟内有效。
	 *
	 * @param appid
	 * @param secret
	 * @param openId
	 * @param openId
	 * @return ResponseEntity
	 */
	public ResponseEntity getPaidUnionId(AppConfigParam appConfigParam,RequestParam requestParam);

	/**
	 * 获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制
	 *
	 *  @param appConfigParam appid信息
	 * 	@param wxaCodeParam 二维码配置信息
	 * @return  小程序bse64码，前端通过img的base渲染data:image/png;base64,xxxx
	 */
	public String getWxaCodeUnlimited(AppConfigParam appConfigParam, WxaCodeParam wxaCodeParam);
	/**
	 * 解密小程序数据
	 *
	 *  @param appId appid信息
	 * 	@param encryptedData 加密字符串
	 * 	@param sessionKey sessionKey
	 * 	@param iv iv
	 * @return  小程序bse64码，前端通过img的base渲染data:image/png;base64,xxxx
	 */
	public String decryptWxa(String appId, String encryptedData, String sessionKey, String iv);

	/**
	 * 上传媒体消息素材
	 * 
	 * @param appid
	 * @param secret
	 * @param file
	 * @param type
	 * @return 素材ID
	 */
	public String uploadMedia(String appid, String secret, File file,
			String type);

	/**
	 * 上传多图文消息，需要先上传媒体消息，获取媒体消息ID
	 * 
	 * @param appid
	 * @param secret
	 * @param content
	 * @return 素材ID
	 */
	public String uploadNews(String appid, String secret, String content);

	/**
	 * 根据OpenID群发消息
	 * 
	 * @param appid
	 * @param secret
	 * @param content
	 */
	public void massSendNewsMessageByOpenID(String appid, String secret,
			String content);

	/**
	 * 生成群发图文消息
	 * 
	 * @param mediaID
	 * @param openIDS
	 * @return
	 */

	public String generateMassMPNewsMessage(String mediaID, List<String> openIDS);

	/**
	 * 生成群发文本消息
	 * 
	 * @param text
	 * @param openIDS
	 * @return
	 */

	public String generateMassTextMessage(String text, List<String> openIDS);

	/**
	 * 生成群发语音消息
	 * 
	 * @param mediaID
	 * @param openIDS
	 * @return
	 */

	public String generateMassVoiceMessage(String mediaID, List<String> openIDS);

	/**
	 * 生成群发图片消息
	 * 
	 * @param mediaID
	 * @param openIDS
	 * @return
	 */

	public String generateMassImgMessage(String mediaID, List<String> openIDS);

	public OpenIDList getOpenIDList(String appid, String secret,
			String next_openid);

	/**
	 * 生成JSAPI
	 * 
	 * @return
	 */
	public JSAPI getJSAPI(String appid, String secret, String url);

	public void updateAccessToken(String appid,String secret);
	//统一更新AccessToken
	public void updateAccessToken();

	/**
	 * 获取客服列表
	 *
	 * @return
	 */
	public List<KfEntity> getKfList(String appid, String secret);
	/**
	 * 获取在线客服列表
	 *
	 * @return
	 */
	public List<KfEntity> getOnlineKfList(String appid, String secret);

	/**
	 * 添加客服账号
	 *
	 * @return
	 */
	public ErrorMsg addKfAccount(String appid, String secret, KfSend kfSend);

	/**
	 * 邀请绑定客服账号
	 *
	 * @return
	 */
	public ErrorMsg inviteKfAccount(String appid, String secret,KfSend kfSend);

	/**
	 * 设置客服信息
	 *
	 * @return
	 */
	public ErrorMsg updateKfAccount(String appid, String secret,KfSend kfSend);

	/**
	 * 删除客服账号
	 * @param kfAccount 客服账号
	 * @return
	 */
	public ErrorMsg delKfAccount(String appid, String secret,String kfAccount);

	/**
	 * 创建会话
	 *
	 * @return
	 */
	public ErrorMsg createKfSession(String appid, String secret,KfSend kfSend);

	/**
	 * 关闭会话
	 *
	 * @return
	 */
	public ErrorMsg closeKfSession(String appid, String secret,KfSend kfSend);

	/**
	 * 获取客户会话状态
	 * @param openid 客户openid
	 * @return
	 */
	public RecKfSessionEntity getKfSession(String appid, String secret,String openid);
	/**
	 * 获取客服会话列表
	 * @param kfAccount 客服账号
	 * @return
	 */
	public List<RecKfSessionEntity> getKfSessionList(String appid, String secret,String kfAccount);

	/**
	 * 获取未接入会话列表
	 * @return
	 */
	public RecKfSession getWaitcaseKfSessionList(String appid, String secret);

    /**
     * 服务商微信支付
     * @param payParam 支付配置
     * @param type 支付类型（）
     * @return
     */
    public Map<String,Object> partnerPayV3(PayParam payParam, String type);
    /**
     * v3报文解密
     * @param associatedData
     * @param nonce
     * @param ciphertext
     * @return
     */
    public String decryptV3 (String associatedData,String nonce, String ciphertext) throws GeneralSecurityException, IOException;
    /**
     * 下载平台证书(更新V3微信平台证书，12小时内调用一次)
     * @return
     */
    public void downloadPlatformCertificate();
    /**
     * 商户分账单次分账
     * @param transactionId 微信支付订单号
     * @param outOrderNo 商户系统内部的分账单号，在商户系统内部唯一（单次分账、多次分账、完结分账应使用不同的商户分账单号），同一分账单号多次请求等同一次。只能是数字、大小写字母_-|*@
     * @param subMchId 子商户号
     * @param  receivers 分账接收方
     * @param  subAppId 特约商户appid
     * @return
     */
    public String profitSharing(String subMchId,String transactionId, String outOrderNo, List<Receiver>receivers,String subAppId);
    /**
     * 商户分账多次分账
     * @param transactionId 微信支付订单号
     * @param outOrderNo 商户系统内部的分账单号，在商户系统内部唯一（单次分账、多次分账、完结分账应使用不同的商户分账单号），同一分账单号多次请求等同一次。只能是数字、大小写字母_-|*@
     * @param subMchId 子商户号
     * @param  receivers 分账接收方
     * @param  subAppId 特约商户appid
     * @return
     */
    public String multiProfitSharing(String subMchId,String appId,String transactionId, String outOrderNo, List<Receiver>receivers,String subAppId);
    /**
     * 添加分账接收方
     * @param subMchId 子商户号
     * @param  receivers 分账接收方
     * @param  subAppId 特约商户appid
     * @return
     */
    public String profitSharingAddReceiver(String subMchId, Receiver receiver,String subAppId);
    /**
     * 删除分账接收方
     * @param subMchId 子商户号
     * @param  receiver 分账接收方
     * @param  subAppId 特约商户appid
     * @return String
     */
    public String profitSharingRemoveReceiver(String subMchId, Receiver receiver,String subAppId);
    /**
     * 完结分账
     * @param transactionId 微信支付订单号
     * @param outOrderNo 商户系统内部的分账单号，在商户系统内部唯一（单次分账、多次分账、完结分账应使用不同的商户分账单号），同一分账单号多次请求等同一次。只能是数字、大小写字母_-|*@
     * @param description 描述
     * @param subMchId 特约商户号
     * @return String
     */
    public String profitSharingFinish(String subMchId, String transactionId, String outOrderNo, String description);
    /**
     * 查询订单最大分账比例
     * @param subMchId 特约商户号
     * @return String
     */
    public String profitSharingMerchantRatioQuery(String subMchId);
    /**
     * 查询订单最大分账比例
     * @param transactionId 微信支付订单号
     * @return
     */
    public String profitSharingOrderAmountQuery(String transactionId);

}
