/*
 * Decompiled with CFR 0.152.
 */
package com.qding.community.common.weixin.parser;

import com.qding.community.common.weixin.parser.WxRecvEventMsgParser;
import com.qding.community.common.weixin.parser.WxRecvGeoMsgParser;
import com.qding.community.common.weixin.parser.WxRecvLinkMsgParser;
import com.qding.community.common.weixin.parser.WxRecvMsgParser;
import com.qding.community.common.weixin.parser.WxRecvPicMsgParser;
import com.qding.community.common.weixin.parser.WxRecvTextMsgParser;
import com.qding.community.common.weixin.vo.recv.RecvMessage;
import com.qding.community.common.weixin.vo.send.SendMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class WxMsgKit {
    private static final Log log = LogFactory.getLog(WxMsgKit.class);
    private static final Map<String, WxRecvMsgParser> recvParserMap = new HashMap<String, WxRecvMsgParser>();

    public static RecvMessage parse(InputStream in) throws JDOMException, IOException {
        Document dom = new SAXBuilder().build(in);
        log.info((Object)(dom.toString() + " get message is " + dom));
        Element msgType = dom.getRootElement().getChild("MsgType");
        if (null != msgType) {
            String txt = msgType.getText().toLowerCase();
            WxRecvMsgParser parser = recvParserMap.get(txt);
            if (null != parser) {
                return parser.parser(dom);
            }
            System.out.println(txt);
        }
        return null;
    }

    public static Document parse(SendMessage msg) throws JDOMException {
        return msg.toDocument();
    }

    public static void main(String[] args) {
        Document doc = new Document();
        Element root = new Element("xml");
        doc.setRootElement(root);
        WxMsgKit.createElement(root, "ToUserName", "2");
        WxMsgKit.createElement(root, "FromUserName", "2");
        WxMsgKit.createElement(root, "CreateTime", "2");
        WxMsgKit.createElement(root, "MsgType", "2");
        WxMsgKit.createElement(root, "FuncFlag", "2");
        log.info((Object)doc);
    }

    static Element createElement(Element parent, String name, String value) {
        Element elem = new Element(name);
        elem.setText(value);
        parent.getChildren().add(elem);
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "/n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    static {
        recvParserMap.put("text", new WxRecvTextMsgParser());
        recvParserMap.put("link", new WxRecvLinkMsgParser());
        recvParserMap.put("location", new WxRecvGeoMsgParser());
        recvParserMap.put("image", new WxRecvPicMsgParser());
        recvParserMap.put("event", new WxRecvEventMsgParser());
    }
}

