/*
 * Decompiled with CFR 0.152.
 */
package com.qding.commnunity.common.weixin.service.impl;

import com.gemantic.common.util.OpenIDListUtil;
import com.gemantic.common.util.Sign;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.ObjectUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.community.common.weixin.parser.WxMsgKit;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.AES;
import com.qding.community.common.weixin.util.HashUtil;
import com.qding.community.common.weixin.util.WeiXinCodeToMessageUtil;
import com.qding.community.common.weixin.util.WeiXinPropertiesUtil;
import com.qding.community.common.weixin.util.WxPKCS7Encoder;
import com.qding.community.common.weixin.vo.ErrorMsg;
import com.qding.community.common.weixin.vo.JSAPI;
import com.qding.community.common.weixin.vo.OpenIDList;
import com.qding.community.common.weixin.vo.ResponseEntity;
import com.qding.community.common.weixin.vo.WXUser;
import com.qding.community.common.weixin.vo.customservice.KfEntity;
import com.qding.community.common.weixin.vo.customservice.KfSend;
import com.qding.community.common.weixin.vo.customservice.RecKfSession;
import com.qding.community.common.weixin.vo.customservice.RecKfSessionEntity;
import com.qding.community.common.weixin.vo.recv.RecvMessage;
import com.qding.community.common.weixin.vo.request.AppConfigParam;
import com.qding.community.common.weixin.vo.request.RequestParam;
import com.qding.community.common.weixin.vo.request.WxaCodeParam;
import com.qding.community.common.weixin.vo.send.SendMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.json.JSONObject;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WeiXinServiceImpl
implements WeiXinService {
    private static final Log log = LogFactory.getLog(WeiXinServiceImpl.class);
    private static final Executor exec = Executors.newFixedThreadPool(3);
    private static final String WATERMARK = "watermark";
    private static final String APPID = "appid";
    private Map<String, String> accessTokenMap;
    private Map<String, String> appid_secret;
    private boolean immediately = true;
    private Map<String, String> jsapi_ticketMap;

    public WeiXinServiceImpl(Map<String, String> appid_secret, boolean immediately) {
        this.accessTokenMap = new HashMap<String, String>();
        this.jsapi_ticketMap = new HashMap<String, String>();
        this.appid_secret = appid_secret;
        this.immediately = immediately;
        log.info((Object)("appid_secret=" + appid_secret + " ,immediately=" + immediately));
        if (immediately) {
            for (Map.Entry<String, String> entry : appid_secret.entrySet()) {
                this.updateAccessToken(entry.getKey(), entry.getValue());
            }
        }
    }

    public WeiXinServiceImpl() {
    }

    public Map<String, String> getAppid_secret() {
        return this.appid_secret;
    }

    public void setAppid_secret(Map<String, String> appid_secret) {
        this.appid_secret = appid_secret;
    }

    public Map<String, String> getAccessTokenMap() {
        return this.accessTokenMap;
    }

    public void setAccessTokenMap(Map<String, String> accessTokenMap) {
        this.accessTokenMap = accessTokenMap;
    }

    public Map<String, String> getJsapi_ticket() {
        return this.jsapi_ticketMap;
    }

    public void setJsapi_ticketMap(Map<String, String> jsapi_ticketMap) {
        this.jsapi_ticketMap = jsapi_ticketMap;
    }

    public boolean isImmediately() {
        return this.immediately;
    }

    public void setImmediately(boolean immediately) {
        this.immediately = immediately;
    }

    @Override
    public boolean access(String token, String signature, String timestamp, String nonce) {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);
        Collections.sort(ss);
        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashUtil.sha1(builder.toString()));
    }

    @Override
    public RecvMessage recv(InputStream in) throws JDOMException, IOException {
        return WxMsgKit.parse(in);
    }

    @Override
    public void send(SendMessage msg, OutputStream out) throws JDOMException, IOException {
        Document doc = WxMsgKit.parse(msg);
        if (null != doc) {
            new XMLOutputter().output(doc, out);
        } else {
            Logger.getAnonymousLogger().warning("\u53d1\u9001\u6d88\u606f\u65f6,\u89e3\u6790\u51fadom\u4e3a\u7a7a msg :" + msg);
        }
    }

    @Override
    public SendMessage builderSendByRecv(RecvMessage msg) {
        RecvMessage m = new RecvMessage(msg);
        String from = m.getFromUserName();
        m.setFromUserName(m.getToUserName());
        m.setToUserName(from);
        m.setCreateTime(System.currentTimeMillis() / 1000L + "");
        return new SendMessage(m);
    }

    @Override
    public boolean publishMenu(String appid, String secret, String menu) {
        String accessToken = this.getToken(appid, secret);
        boolean result = false;
        try {
            log.info((Object)accessToken);
            String menuUrl = WeiXinPropertiesUtil.getProperty("menu");
            menuUrl = menuUrl.replace("{accessToken}", accessToken);
            log.info((Object)("menuUrl url is " + menuUrl));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)menuUrl, (String)menu);
            log.info((Object)("generator:" + httpsresponse));
            String errcode = GsonUtil.get((String)"errcode", (String)httpsresponse);
            log.info((Object)("errcode is " + errcode));
            if ("0".equals(errcode)) {
                result = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getToken(String appid, String secret) {
        return this.accessTokenMap.get(appid);
    }

    @Override
    public void setToken(String appid, String token) {
        this.accessTokenMap.put(appid, token);
    }

    @Override
    public void updateAccessToken(String appid, String secret) {
        String url = WeiXinPropertiesUtil.getProperty("token");
        url = url.replace("{appid}", appid);
        url = url.replace("{secret}", secret);
        log.info((Object)("token url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getToken:" + response));
        Long start = System.currentTimeMillis();
        log.info((Object)("load gson use time " + (System.currentTimeMillis() - start)));
        String accessToken = GsonUtil.get((String)"access_token", (String)response);
        this.accessTokenMap.put(appid, accessToken);
        log.info((Object)accessToken);
        this.updateJSAPITicket(appid, secret);
    }

    private void updateJSAPITicket(String appid, String secret) {
        log.info((Object)("update jsapi jsAccessToken is " + this.accessTokenMap.get(appid)));
        String jsapiURL = WeiXinPropertiesUtil.getProperty("jsapi");
        jsapiURL = jsapiURL.replace("{accessToken}", this.accessTokenMap.get(appid));
        log.info((Object)("upload_news url is " + jsapiURL));
        String response3 = HttpClientUtil.sendGetRequest((String)jsapiURL, null);
        log.info((Object)("appid " + appid + " secret " + secret + " result is " + response3));
        String jsapi_ticket = GsonUtil.get((String)"ticket", (String)response3);
        if (StringUtils.isBlank((CharSequence)jsapi_ticket)) {
            log.error((Object)"not get any ticket ");
        }
        log.info((Object)("get jsapi_ticket is  " + jsapi_ticket));
        this.jsapi_ticketMap.put(appid, jsapi_ticket);
    }

    @Override
    public String getQRTicket(String appid, String secret, Long sceneID, String sceneStr) {
        try {
            if (DataUtils.isNotNullOrEmpty((Object)sceneID) && (sceneID > 100000L || sceneID < 0L)) {
                log.error((Object)("id " + appid + " secret " + secret + " sceneID " + sceneID + " is wrong format "));
                return "";
            }
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("qr");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("getQrCodeUrl url is " + getQrCodeUrl));
            String sendData = "{\"action_name\": \"QR_LIMIT_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": " + sceneID + "}}}";
            if (DataUtils.isNotNullOrEmpty((Object)sceneStr)) {
                log.info((Object)("sceneStr=" + sceneStr));
                sendData = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
            }
            log.info((Object)("send data is " + sendData));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)sendData);
            log.info((Object)("generator:" + httpsresponse));
            String ticket = GsonUtil.get((String)"ticket", (String)httpsresponse);
            return ticket;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String createLimitQRCode(String ticket) {
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return "";
        }
        try {
            String qcImgUrl = WeiXinPropertiesUtil.getProperty("qrImg");
            qcImgUrl = qcImgUrl.replace("{ticket}", ticket);
            return qcImgUrl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String createCodeRequestUrl(String appid, String secret, String url) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and url is " + url));
        String codeUrl = WeiXinPropertiesUtil.getProperty("code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}", URLEncoder.encode(url, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("create code url failure " + appid + " is appid, " + secret + " is secret and url is " + url));
            e.printStackTrace();
        }
        log.info((Object)("codeUrl url is " + codeUrl));
        return codeUrl;
    }

    @Override
    public String createUnscribeCodeRequestUrl(String appid, String secret, String url) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and url is " + url));
        String codeUrl = WeiXinPropertiesUtil.getProperty("unscribe_code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}", URLEncoder.encode(url, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("create code url failure " + appid + " is appid, " + secret + " is secret and url is " + url));
            e.printStackTrace();
        }
        log.info((Object)("codeUrl url is " + codeUrl));
        return codeUrl;
    }

    @Override
    public WXUser getUserInfo(String appid, String secret, String openID) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and openID is " + openID));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info((Object)("uinfo url is " + url));
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getUserInfo:" + response2));
        String errCode = GsonUtil.get((String)"errcode", (String)response2);
        if (!"42001".equals(errCode)) {
            log.info((Object)"ok,not get any token refresh  ");
        } else {
            log.info((Object)"bad news .token maybe invalid,dont worry,lets refresh it");
            this.updateAccessToken(appid, secret);
            token = this.getToken(appid, secret);
            log.info((Object)("after refresh token is  " + token));
            response2 = HttpClientUtil.sendGetRequest((String)url, null);
            log.info((Object)("after refresh response2 is  " + response2));
        }
        Gson gson = new GsonBuilder().create();
        WXUser user = (WXUser)gson.fromJson(response2, WXUser.class);
        return user;
    }

    @Override
    public List<WXUser> batchgetUserInfo(String appid, String secret, List<String> openidList) {
        ArrayList<WXUser> wxUserList = new ArrayList();
        log.info((Object)(appid + " is appid, " + secret + " is secret ,openid size " + openidList.size()));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("batchgetUinfo");
        url = url.replace("{accessToken}", token);
        log.info((Object)("batchgetUinfo url is " + url));
        StringBuilder stringBuilder = new StringBuilder();
        for (String i : openidList) {
            stringBuilder.append("{\"openid\": \"").append(i).append("\",\"lang\": \"zh_CN\"}").append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
        String content = "{\n    \"user_list\": [\n" + stringBuilder.toString() + "    ]\n}";
        String response2 = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
        log.info((Object)("batchgetUinfo:" + response2));
        JSONObject jsonObject = new JSONObject(response2);
        String result = jsonObject.getJSONArray("user_info_list").toString();
        Gson gson = new GsonBuilder().create();
        wxUserList = (List)gson.fromJson(result, new TypeToken<List<WXUser>>(){}.getType());
        return wxUserList;
    }

    @Override
    public String getOpenID(String appid, String secret, String code) {
        String defaultOpenID = null;
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        defaultOpenID = GsonUtil.get((String)"openid", (String)response2);
        return defaultOpenID;
    }

    @Override
    public String getAppletOpenID(String appid, String secret, String code) {
        String defaultOpenID = null;
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("appletcode2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        defaultOpenID = GsonUtil.get((String)"openid", (String)response2);
        return defaultOpenID;
    }

    @Override
    public ResponseEntity wxaCode2Session(String appid, String secret, String code) {
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("appletcode2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid).replace("{secret}", secret).replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        return (ResponseEntity)GsonUtil.fromJson((String)response2, ResponseEntity.class);
    }

    @Override
    public String sendCustomMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)("appid is " + appid + ",secret=" + secret + ",content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (asynchrony) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    String url = WeiXinPropertiesUtil.getProperty("custom");
                    url = url.replace("{accessToken}", token);
                    log.info((Object)("url is " + url));
                    String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                    log.info((Object)("generator:" + httpsresponse));
                }
            };
            exec.execute(task);
        } else {
            String url = WeiXinPropertiesUtil.getProperty("custom");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
        }
        return result;
    }

    @Override
    public String sendTemplateMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("template");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("template");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public String sendAppletMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("applet");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("applet");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public ResponseEntity getPaidUnionId(AppConfigParam appConfigParam, RequestParam requestParam) {
        log.info((Object)("appConfigParam :" + appConfigParam.toString()));
        log.info((Object)("requestParam :" + requestParam.toString()));
        String token = this.getToken(appConfigParam.getAppid(), null);
        String url = WeiXinPropertiesUtil.getProperty("getPaidUnionId");
        url = url.replace("{accessToken}", token).replace("{openid}", requestParam.getOpenid()).concat(ObjectUtil.toUrlParams((Object)requestParam, (String[])new String[]{"openid"}));
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        return (ResponseEntity)GsonUtil.fromJson((String)response2, ResponseEntity.class);
    }

    @Override
    public String getWxaCodeUnlimited(AppConfigParam appConfigParam, WxaCodeParam wxaCodeParam) {
        log.info((Object)("appConfigParam :" + appConfigParam.toString()));
        log.info((Object)("wxaCodeParam :" + wxaCodeParam.toString()));
        String token = this.getToken(appConfigParam.getAppid(), null);
        String url = WeiXinPropertiesUtil.getProperty("getUnlimited");
        url = url.replace("{accessToken}", token);
        byte[] bytes = HttpClientUtil.sendPostRequestByJavaByte((String)url, (String)GsonUtil.toJson((Object)wxaCodeParam));
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(bytes != null ? bytes : new byte[]{});
    }

    @Override
    public String decryptWxa(String appId, String encryptedData, String sessionKey, String iv) {
        String result = "";
        try {
            JSONObject jsonObject;
            String decryptAppid;
            AES aes = new AES();
            BASE64Decoder base64Decoder = new BASE64Decoder();
            byte[] resultByte = aes.decrypt(base64Decoder.decodeBuffer(encryptedData), base64Decoder.decodeBuffer(sessionKey), base64Decoder.decodeBuffer(iv));
            if (null != resultByte && resultByte.length > 0 && !appId.equals(decryptAppid = (jsonObject = new JSONObject(result = new String(WxPKCS7Encoder.decode(resultByte)))).getJSONObject(WATERMARK).getString(APPID))) {
                result = "";
            }
        }
        catch (Exception e) {
            result = "";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean removeMenu(String appid, String secret) {
        boolean result = false;
        String token = this.getToken(appid, secret);
        String removeMenuUrl = WeiXinPropertiesUtil.getProperty("menu_delete");
        removeMenuUrl = removeMenuUrl.replace("{accessToken}", token);
        log.info((Object)("removeMenuUrl url is " + removeMenuUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)removeMenuUrl, null);
        log.info((Object)("removeMenuUrl:" + response2));
        String errcode = GsonUtil.get((String)"errcode", (String)response2);
        log.info((Object)("errcode is " + errcode));
        if ("0".equals(errcode)) {
            result = true;
        }
        return result;
    }

    @Override
    public String queryMenu(String appid, String secret) {
        String token = this.getToken(appid, secret);
        String queryMenuUrl = WeiXinPropertiesUtil.getProperty("menu_query");
        queryMenuUrl = queryMenuUrl.replace("{accessToken}", token);
        log.info((Object)("queryMenuUrl url is " + queryMenuUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)queryMenuUrl, null);
        log.info((Object)("queryMenuUrl:" + response2));
        return response2;
    }

    @Override
    public SendMessage processMessage(SendMessage sendMsg, String url) {
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        return sendMsg;
    }

    @Override
    public String uploadNews(String appid, String secret, String content) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)(appid + " and secret " + secret + " get accessToken is " + accessToken));
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("upload_news");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("upload_news url is " + getQrCodeUrl));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            String media_id = GsonUtil.get((String)"media_id", (String)httpsresponse);
            log.info((Object)(appid + " and secret " + secret + " get media_id is " + media_id));
            return media_id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void massSendNewsMessageByOpenID(String appid, String secret, String content) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("mass");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("mass url is " + getQrCodeUrl));
            log.info((Object)(appid + " and secret " + secret + " want send media " + content + " want send data is " + content));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)content);
            log.info((Object)("generator:" + httpsresponse));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String uploadMedia(String appid, String secret, File file, String type) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String upload_media = WeiXinPropertiesUtil.getProperty("upload_media");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{type}", accessToken);
            log.info((Object)("upload_news url is " + upload_media));
            String httpsresponse = HttpClientUtil.postFile((File)file, (String)upload_media, (String)"media");
            String media_id = GsonUtil.get((String)"media_id", (String)httpsresponse);
            log.info((Object)("appid " + appid + " secret " + secret + " result is " + httpsresponse));
            return media_id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String generateMassMPNewsMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_wpnews");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassTextMessage(String text, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_text");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{content}", text);
        return message;
    }

    @Override
    public String generateMassVoiceMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_voice");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassImgMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_img");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public OpenIDList getOpenIDList(String appid, String secret, String next_openid) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String upload_media = WeiXinPropertiesUtil.getProperty("openID_list");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{next_openid}", next_openid);
            log.info((Object)("upload_news url is " + upload_media));
            String response2 = HttpClientUtil.sendGetRequest((String)upload_media, null);
            log.info((Object)("appid " + appid + " secret " + secret + " result is " + response2));
            OpenIDList list = OpenIDListUtil.parseContent2OpenIDList(response2);
            return list;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSAPI getJSAPI(String appid, String secret, String url) {
        try {
            Map<String, String> ret = Sign.sign(this.jsapi_ticketMap.get(appid), url);
            log.info(ret);
            JSAPI jsapi = new JSAPI(appid, ret.get("timestamp"), ret.get("nonceStr"), ret.get("signature"));
            return jsapi;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wx53bc3d04623a459f", "f064bf113b7990e117e3b21aa6db5d55");
        WeiXinServiceImpl wx = new WeiXinServiceImpl(map, true);
        wx.getUserInfoByCode("wx53bc3d04623a459f", "f064bf113b7990e117e3b21aa6db5d55", "031zceXw0w3AKm1dR0Xw020aXw0zceXc");
    }

    @Override
    public WXUser getUserInfoByCode(String appid, String secret, String code) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and code is " + code));
        Object defaultOpenID = null;
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        String token = GsonUtil.get((String)"access_token", (String)response2);
        String openID = GsonUtil.get((String)"openid", (String)response2);
        String url = WeiXinPropertiesUtil.getProperty("code_uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info((Object)("uinfo url is " + url));
        String response3 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getUserInfo:" + response3));
        Gson gson = new GsonBuilder().create();
        WXUser user = (WXUser)gson.fromJson(response3, WXUser.class);
        return user;
    }

    @Override
    public List<KfEntity> getKfList(String appid, String secret) {
        ArrayList<KfEntity> kfEntityList = new ArrayList();
        log.info((Object)(appid + " is appid, " + secret + " is secret"));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kflist");
        url = url.replace("{accessToken}", token);
        log.info((Object)("getKfList url is " + url));
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getKfList:" + response2));
        JSONObject jsonObject = new JSONObject(response2);
        String result = jsonObject.getJSONArray("kf_list").toString();
        Gson gson = new GsonBuilder().create();
        kfEntityList = (List)gson.fromJson(result, new TypeToken<List<KfEntity>>(){}.getType());
        return kfEntityList;
    }

    @Override
    public List<KfEntity> getOnlineKfList(String appid, String secret) {
        ArrayList<KfEntity> kfEntityList = new ArrayList();
        log.info((Object)(appid + " is appid, " + secret + " is secret"));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("onlinekflist");
        url = url.replace("{accessToken}", token);
        log.info((Object)("getKfList url is " + url));
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getKfList:" + response2));
        JSONObject jsonObject = new JSONObject(response2);
        String result = jsonObject.getJSONArray("kf_online_list").toString();
        log.info((Object)("result=" + result));
        Gson gson = new GsonBuilder().create();
        kfEntityList = (List)gson.fromJson(result, new TypeToken<List<KfEntity>>(){}.getType());
        return kfEntityList;
    }

    @Override
    public ErrorMsg addKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfSend=" + sendData));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount");
        url = url.replace("{accessToken}", token);
        log.info((Object)("getKfList url is " + url));
        String response = HttpClientUtil.sendPostRequestByJava((String)url, (String)sendData);
        log.info((Object)("addKfAccount:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg inviteKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfSend=" + sendData));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_inviteworker");
        url = url.replace("{accessToken}", token);
        log.info((Object)("inviteKfAccount url is " + url));
        String response = HttpClientUtil.sendPostRequestByJava((String)url, (String)sendData);
        log.info((Object)("inviteKfAccount:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg updateKfAccount(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfSend=" + sendData));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_update");
        url = url.replace("{accessToken}", token);
        log.info((Object)("updateKfAccount url is " + url));
        String response = HttpClientUtil.sendPostRequestByJava((String)url, (String)sendData);
        log.info((Object)("updateKfAccount:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg delKfAccount(String appid, String secret, String kfAccount) {
        ErrorMsg errorMsg = new ErrorMsg();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfAccount=" + kfAccount));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("kfaccount_del");
        url = url.replace("{accessToken}", token);
        url = url.replace("{kfAccount}", kfAccount);
        log.info((Object)("kfaccount_del url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("updateKfAccount:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg createKfSession(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfSend=" + sendData));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("create_kfsession");
        url = url.replace("{accessToken}", token);
        log.info((Object)("createKfSession url is " + url));
        String response = HttpClientUtil.sendPostRequestByJava((String)url, (String)sendData);
        log.info((Object)("createKfSession:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public ErrorMsg closeKfSession(String appid, String secret, KfSend kfSend) {
        ErrorMsg errorMsg = new ErrorMsg();
        String sendData = kfSend.toJson();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfSend=" + sendData));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("close_kfsession");
        url = url.replace("{accessToken}", token);
        log.info((Object)("closeKfSession url is " + url));
        String response = HttpClientUtil.sendPostRequestByJava((String)url, (String)sendData);
        log.info((Object)("closeKfSession:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        try {
            errorMsg.setCode(errcode);
            errorMsg.setMessage(WeiXinCodeToMessageUtil.codeToMessage(errcode));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return errorMsg;
    }

    @Override
    public RecKfSessionEntity getKfSession(String appid, String secret, String openid) {
        RecKfSessionEntity recKfSessionEntity = new RecKfSessionEntity();
        log.info((Object)(appid + " is appid, " + secret + " is secret, openid=" + openid));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("get_kfsession");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openid);
        log.info((Object)("getKfSession url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getKfSession:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        if ("0".equals(errcode)) {
            Gson gson = new GsonBuilder().create();
            recKfSessionEntity = (RecKfSessionEntity)gson.fromJson(response, RecKfSessionEntity.class);
        }
        return recKfSessionEntity;
    }

    @Override
    public List<RecKfSessionEntity> getKfSessionList(String appid, String secret, String kfAccount) {
        List<RecKfSessionEntity> recKfSessionEntityList = new ArrayList<RecKfSessionEntity>();
        log.info((Object)(appid + " is appid, " + secret + " is secret, kfAccount=" + kfAccount));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("list_kfsession");
        url = url.replace("{accessToken}", token);
        url = url.replace("{kfAccount}", kfAccount);
        log.info((Object)("getKfSession url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getKfSession:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        if ("0".equals(errcode)) {
            JSONObject jsonObject = new JSONObject(response);
            String result = jsonObject.getJSONArray("sessionlist").toString();
            Gson gson = new GsonBuilder().create();
            recKfSessionEntityList = (List)gson.fromJson(result, new TypeToken<List<RecKfSessionEntity>>(){}.getType());
        }
        return recKfSessionEntityList;
    }

    @Override
    public RecKfSession getWaitcaseKfSessionList(String appid, String secret) {
        RecKfSession recKfSession = new RecKfSession();
        log.info((Object)(appid + " is appid, " + secret + " is secret"));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("wait_kfsession");
        url = url.replace("{accessToken}", token);
        log.info((Object)("getWaitcaseKfSessionList url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getWaitcaseKfSessionList:" + response));
        String errcode = GsonUtil.get((String)"errcode", (String)response);
        log.info((Object)("errcode is " + errcode));
        if ("0".equals(errcode)) {
            Gson gson = new GsonBuilder().create();
            recKfSession = (RecKfSession)gson.fromJson(response, RecKfSession.class);
        }
        return recKfSession;
    }
}

