/*
 * Decompiled with CFR 0.152.
 */
package com.qding.commnunity.common.weixin.service.impl;

import com.gemantic.common.util.OpenIDListUtil;
import com.gemantic.common.util.Sign;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.community.common.weixin.parser.WxMsgKit;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.HashUtil;
import com.qding.community.common.weixin.util.WeiXinPropertiesUtil;
import com.qding.community.common.weixin.vo.JSAPI;
import com.qding.community.common.weixin.vo.OpenIDList;
import com.qding.community.common.weixin.vo.WXUser;
import com.qding.community.common.weixin.vo.recv.RecvMessage;
import com.qding.community.common.weixin.vo.send.SendMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public class WeiXinServiceImpl
implements WeiXinService {
    private static final Log log = LogFactory.getLog(WeiXinServiceImpl.class);
    private static final Executor exec = Executors.newFixedThreadPool(3);
    private String accessToken;
    private String appid = "";
    private String secret = "";
    private String jsapi_ticket;

    public WeiXinServiceImpl(String appid, String secret) {
        this.appid = appid;
        this.secret = secret;
        this.updateAccessToken();
    }

    public WeiXinServiceImpl() {
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getJsapi_ticket() {
        return this.jsapi_ticket;
    }

    public void setJsapi_ticket(String jsapi_ticket) {
        this.jsapi_ticket = jsapi_ticket;
    }

    @Override
    public boolean access(String token, String signature, String timestamp, String nonce) {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);
        Collections.sort(ss);
        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashUtil.sha1(builder.toString()));
    }

    @Override
    public RecvMessage recv(InputStream in) throws JDOMException, IOException {
        return WxMsgKit.parse(in);
    }

    @Override
    public void send(SendMessage msg, OutputStream out) throws JDOMException, IOException {
        Document doc = WxMsgKit.parse(msg);
        if (null != doc) {
            new XMLOutputter().output(doc, out);
        } else {
            Logger.getAnonymousLogger().warning("\u53d1\u9001\u6d88\u606f\u65f6,\u89e3\u6790\u51fadom\u4e3a\u7a7a msg :" + msg);
        }
    }

    @Override
    public SendMessage builderSendByRecv(RecvMessage msg) {
        RecvMessage m = new RecvMessage(msg);
        String from = m.getFromUserName();
        m.setFromUserName(m.getToUserName());
        m.setToUserName(from);
        m.setCreateTime(System.currentTimeMillis() / 1000L + "");
        return new SendMessage(m);
    }

    @Override
    public boolean publishMenu(String appid, String secret, String menu) {
        String accessToken = this.getToken(appid, secret);
        boolean result = false;
        try {
            log.info((Object)accessToken);
            String menuUrl = WeiXinPropertiesUtil.getProperty("menu");
            menuUrl = menuUrl.replace("{accessToken}", accessToken);
            log.info((Object)("menuUrl url is " + menuUrl));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)menuUrl, (String)menu);
            log.info((Object)("generator:" + httpsresponse));
            String errcode = GsonUtil.get((String)"errcode", (String)httpsresponse);
            log.info((Object)("errcode is " + errcode));
            if ("0".equals(errcode)) {
                result = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getToken(String appid, String secret) {
        return this.accessToken;
    }

    @Override
    public void updateAccessToken() {
        String accessToken;
        String url = WeiXinPropertiesUtil.getProperty("token");
        url = url.replace("{appid}", this.appid);
        url = url.replace("{secret}", this.secret);
        log.info((Object)("token url is " + url));
        String response = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getToken:" + response));
        Long start = System.currentTimeMillis();
        log.info((Object)("load gson use time " + (System.currentTimeMillis() - start)));
        this.accessToken = accessToken = GsonUtil.get((String)"access_token", (String)response);
        log.info((Object)accessToken);
        this.updateJSAPITicket();
    }

    private void updateJSAPITicket() {
        log.info((Object)("update jsapi jsAccessToken is " + this.accessToken));
        String jsapiURL = WeiXinPropertiesUtil.getProperty("jsapi");
        jsapiURL = jsapiURL.replace("{accessToken}", this.accessToken);
        log.info((Object)("upload_news url is " + jsapiURL));
        String response3 = HttpClientUtil.sendGetRequest((String)jsapiURL, null);
        log.info((Object)("appid " + this.appid + " secret " + this.secret + " result is " + response3));
        String jsapi_ticket = GsonUtil.get((String)"ticket", (String)response3);
        if (StringUtils.isBlank((CharSequence)jsapi_ticket)) {
            log.error((Object)"not get any ticket ");
        }
        log.info((Object)("get jsapi_ticket is  " + jsapi_ticket));
        this.jsapi_ticket = jsapi_ticket;
    }

    @Override
    public String getQRTicket(String appid, String secret, Long sceneID, String sceneStr) {
        try {
            if (DataUtils.isNotNullOrEmpty((Object)sceneID) && (sceneID > 100000L || sceneID < 0L)) {
                log.error((Object)("id " + appid + " secret " + secret + " sceneID " + sceneID + " is wrong format "));
                return "";
            }
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("qr");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("getQrCodeUrl url is " + getQrCodeUrl));
            String sendData = "{\"action_name\": \"QR_LIMIT_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": " + sceneID + "}}}";
            if (DataUtils.isNotNullOrEmpty((Object)sceneStr)) {
                log.info((Object)("sceneStr=" + sceneStr));
                sendData = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
            }
            log.info((Object)("send data is " + sendData));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)sendData);
            log.info((Object)("generator:" + httpsresponse));
            String ticket = GsonUtil.get((String)"ticket", (String)httpsresponse);
            return ticket;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String createLimitQRCode(String ticket) {
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return "";
        }
        try {
            String qcImgUrl = WeiXinPropertiesUtil.getProperty("qrImg");
            qcImgUrl = qcImgUrl.replace("{ticket}", ticket);
            return qcImgUrl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String createCodeRequestUrl(String appid, String secret, String url) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and url is " + url));
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        String codeUrl = WeiXinPropertiesUtil.getProperty("code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}", URLEncoder.encode(url, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("create code url failure " + appid + " is appid, " + secret + " is secret and url is " + url));
            e.printStackTrace();
        }
        log.info((Object)("codeUrl url is " + codeUrl));
        return codeUrl;
    }

    @Override
    public String createUnscribeCodeRequestUrl(String appid, String secret, String url) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and url is " + url));
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        String codeUrl = WeiXinPropertiesUtil.getProperty("unscribe_code");
        codeUrl = codeUrl.replace("{appid}", appid);
        try {
            codeUrl = codeUrl.replace("{redirect_uri}", URLEncoder.encode(url, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("create code url failure " + appid + " is appid, " + secret + " is secret and url is " + url));
            e.printStackTrace();
        }
        log.info((Object)("codeUrl url is " + codeUrl));
        return codeUrl;
    }

    @Override
    public WXUser getUserInfo(String appid, String secret, String openID) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        log.info((Object)(appid + " is appid, " + secret + " is secret and openID is " + openID));
        String token = this.getToken(appid, secret);
        String url = WeiXinPropertiesUtil.getProperty("uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info((Object)("uinfo url is " + url));
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getUserInfo:" + response2));
        String errCode = GsonUtil.get((String)"errcode", (String)response2);
        if (!"42001".equals(errCode)) {
            log.info((Object)"ok,not get any token refresh  ");
        } else {
            log.info((Object)"bad news .token maybe invalid,dont worry,lets refresh it");
            this.updateAccessToken();
            token = this.getToken(appid, secret);
            log.info((Object)("after refresh token is  " + token));
            response2 = HttpClientUtil.sendGetRequest((String)url, null);
            log.info((Object)("after refresh response2 is  " + response2));
        }
        Gson gson = new GsonBuilder().create();
        WXUser user = (WXUser)gson.fromJson(response2, WXUser.class);
        return user;
    }

    @Override
    public String getOpenID(String appid, String secret, String code) {
        String defaultOpenID = null;
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        defaultOpenID = GsonUtil.get((String)"openid", (String)response2);
        return defaultOpenID;
    }

    @Override
    public String getAppletOpenID(String appid, String secret, String code) {
        String defaultOpenID = null;
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("appletcode2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        defaultOpenID = GsonUtil.get((String)"openid", (String)response2);
        return defaultOpenID;
    }

    @Override
    public String sendCustomMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)("appid is " + appid + ",secret=" + secret + ",content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (asynchrony) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    String url = WeiXinPropertiesUtil.getProperty("custom");
                    url = url.replace("{accessToken}", token);
                    log.info((Object)("url is " + url));
                    String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                    log.info((Object)("generator:" + httpsresponse));
                }
            };
            exec.execute(task);
        } else {
            String url = WeiXinPropertiesUtil.getProperty("custom");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
        }
        return result;
    }

    @Override
    public String sendTemplateMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("template");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("template");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public String sendAppletMessage(String appid, String secret, final String content, boolean asynchrony) {
        log.info((Object)(appid + " is appid, " + secret + " is secret and content is " + content));
        String result = "";
        final String token = this.getToken(appid, secret);
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("applet");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("applet");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public boolean removeMenu(String appid, String secret) {
        boolean result = false;
        String token = this.getToken(appid, secret);
        String removeMenuUrl = WeiXinPropertiesUtil.getProperty("menu_delete");
        removeMenuUrl = removeMenuUrl.replace("{accessToken}", token);
        log.info((Object)("removeMenuUrl url is " + removeMenuUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)removeMenuUrl, null);
        log.info((Object)("removeMenuUrl:" + response2));
        String errcode = GsonUtil.get((String)"errcode", (String)response2);
        log.info((Object)("errcode is " + errcode));
        if ("0".equals(errcode)) {
            result = true;
        }
        return result;
    }

    @Override
    public String queryMenu(String appid, String secret) {
        String token = this.getToken(appid, secret);
        String queryMenuUrl = WeiXinPropertiesUtil.getProperty("menu_query");
        queryMenuUrl = queryMenuUrl.replace("{accessToken}", token);
        log.info((Object)("queryMenuUrl url is " + queryMenuUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)queryMenuUrl, null);
        log.info((Object)("queryMenuUrl:" + response2));
        return response2;
    }

    @Override
    public SendMessage processMessage(SendMessage sendMsg, String url) {
        String response2 = HttpClientUtil.sendGetRequest((String)url, null);
        return sendMsg;
    }

    @Override
    public String uploadNews(String appid, String secret, String content) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)(appid + " and secret " + secret + " get accessToken is " + accessToken));
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("upload_news");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("upload_news url is " + getQrCodeUrl));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            String media_id = GsonUtil.get((String)"media_id", (String)httpsresponse);
            log.info((Object)(appid + " and secret " + secret + " get media_id is " + media_id));
            return media_id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void massSendNewsMessageByOpenID(String appid, String secret, String content) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String getQrCodeUrl = WeiXinPropertiesUtil.getProperty("mass");
            getQrCodeUrl = getQrCodeUrl.replace("{accessToken}", accessToken);
            log.info((Object)("mass url is " + getQrCodeUrl));
            log.info((Object)(appid + " and secret " + secret + " want send media " + content + " want send data is " + content));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)getQrCodeUrl, (String)content);
            log.info((Object)("generator:" + httpsresponse));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String uploadMedia(String appid, String secret, File file, String type) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String upload_media = WeiXinPropertiesUtil.getProperty("upload_media");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{type}", accessToken);
            log.info((Object)("upload_news url is " + upload_media));
            String httpsresponse = HttpClientUtil.postFile((File)file, (String)upload_media, (String)"media");
            String media_id = GsonUtil.get((String)"media_id", (String)httpsresponse);
            log.info((Object)("appid " + appid + " secret " + secret + " result is " + httpsresponse));
            return media_id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String generateMassMPNewsMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_wpnews");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassTextMessage(String text, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_text");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{content}", text);
        return message;
    }

    @Override
    public String generateMassVoiceMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_voice");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public String generateMassImgMessage(String mediaID, List<String> openIDS) {
        Gson gson = new GsonBuilder().create();
        String openIDSString = gson.toJson(openIDS);
        String message = WeiXinPropertiesUtil.getProperty("mass_img");
        message = message.replace("{openIDS}", openIDSString);
        message = message.replace("{mediaID}", mediaID);
        return message;
    }

    @Override
    public OpenIDList getOpenIDList(String appid, String secret, String next_openid) {
        try {
            String accessToken = this.getToken(appid, secret);
            log.info((Object)accessToken);
            String upload_media = WeiXinPropertiesUtil.getProperty("openID_list");
            upload_media = upload_media.replace("{accessToken}", accessToken);
            upload_media = upload_media.replace("{next_openid}", next_openid);
            log.info((Object)("upload_news url is " + upload_media));
            String response2 = HttpClientUtil.sendGetRequest((String)upload_media, null);
            log.info((Object)("appid " + appid + " secret " + secret + " result is " + response2));
            OpenIDList list = OpenIDListUtil.parseContent2OpenIDList(response2);
            return list;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSAPI getJSAPI(String appid, String secret, String url) {
        try {
            if (StringUtils.isBlank((CharSequence)appid)) {
                appid = this.appid;
            }
            if (StringUtils.isBlank((CharSequence)secret)) {
                secret = this.secret;
            }
            Map<String, String> ret = Sign.sign(this.jsapi_ticket, url);
            log.info(ret);
            JSAPI jsapi = new JSAPI(appid, ret.get("timestamp"), ret.get("nonceStr"), ret.get("signature"));
            return jsapi;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        WeiXinServiceImpl wx = new WeiXinServiceImpl("wx53bc3d04623a459f", "f064bf113b7990e117e3b21aa6db5d55");
        wx.getUserInfoByCode(null, null, "031zceXw0w3AKm1dR0Xw020aXw0zceXc");
    }

    @Override
    public WXUser getUserInfoByCode(String appid, String secret, String code) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        log.info((Object)(appid + " is appid, " + secret + " is secret and code is " + code));
        Object defaultOpenID = null;
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.appid;
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.secret;
        }
        String code2TokenUrl = WeiXinPropertiesUtil.getProperty("code2token");
        code2TokenUrl = code2TokenUrl.replace("{appid}", appid);
        code2TokenUrl = code2TokenUrl.replace("{secret}", secret);
        code2TokenUrl = code2TokenUrl.replace("{code}", code);
        log.info((Object)("code2TokenUrl url is " + code2TokenUrl));
        String response2 = HttpClientUtil.sendGetRequest((String)code2TokenUrl, null);
        log.info((Object)("code2TokenUrl:" + response2));
        String token = GsonUtil.get((String)"access_token", (String)response2);
        String openID = GsonUtil.get((String)"openid", (String)response2);
        String url = WeiXinPropertiesUtil.getProperty("code_uinfo");
        url = url.replace("{accessToken}", token);
        url = url.replace("{openid}", openID);
        log.info((Object)("uinfo url is " + url));
        String response3 = HttpClientUtil.sendGetRequest((String)url, null);
        log.info((Object)("getUserInfo:" + response3));
        Gson gson = new GsonBuilder().create();
        WXUser user = (WXUser)gson.fromJson(response3, WXUser.class);
        return user;
    }
}

