/*
 * Decompiled with CFR 0.152.
 */
package com.qding.community.common.weixin.vo.send;

import com.qding.community.common.weixin.vo.send.SendMessage;
import com.qding.community.common.weixin.vo.send.SendNewsMessageItem;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendNewsMessage
extends SendMessage {
    private Integer articleCount;
    private List<SendNewsMessageItem> items = new LinkedList<SendNewsMessageItem>();

    public SendNewsMessage(SendMessage msg) {
        super(msg);
        this.setMsgType("news");
    }

    public void setItems(List<SendNewsMessageItem> items) {
        this.items = items;
    }

    public SendNewsMessage addItem(String title, String description, String picUrl, String url) {
        if (this.items.size() >= 10) {
            throw new IllegalArgumentException("\u53ea\u80fd\u63a5\u53d7\u6700\u591a10\u4e2aitem...");
        }
        this.items.add(new SendNewsMessageItem(title, description, picUrl, url));
        return this;
    }

    @Override
    public Document toDocument() {
        Document doc = super.toDocument();
        Element root = doc.getRootElement();
        SendNewsMessage.createElement(root, "ArticleCount", String.valueOf(this.items.size()));
        Element articles = SendNewsMessage.createElement(root, "Articles", "");
        for (SendNewsMessageItem item : this.items) {
            Element i = SendNewsMessage.createElement(articles, "item", "");
            SendNewsMessage.createElement(i, "Title", item.getTitle());
            SendNewsMessage.createElement(i, "Description", item.getDescription());
            SendNewsMessage.createElement(i, "PicUrl", item.getPicUrl());
            SendNewsMessage.createElement(i, "Url", item.getUrl());
        }
        return doc;
    }
}

