/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util.http.cookie;

import com.qding.common.util.http.cookie.ParamUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentityUtil {
    private static final Log log = LogFactory.getLog(IdentityUtil.class);
    public static String SPLITTER = "|";
    public static String SPLITTER_REGEX = "\\|";

    @Deprecated
    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String userName, Long userId, int maxAge) {
        if (!IdentityUtil.isValid(userName, userId)) {
            IdentityUtil.deleteIdentity(request, response);
            return;
        }
        String value = IdentityUtil.encodeCookie(userName, userId);
        RequestUtil.setCookie(response, "arthurtest", value, maxAge, null, null);
        Map userMap = IdentityUtil.getUserIdentity(userName, userId);
        request.setAttribute("currentVisitor", (Object)userMap);
    }

    @Deprecated
    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String userName, Long usrId) {
        IdentityUtil.setIdentity(request, response, userName, usrId, -1);
    }

    @Deprecated
    public static Map getIdentity(HttpServletRequest request) {
        Map userMap = null;
        Cookie c = RequestUtil.getCookie(request, "arthurtest");
        if (c != null) {
            userMap = IdentityUtil.decodeCookie(c.getValue());
        }
        return userMap;
    }

    @Deprecated
    public static void deleteIdentity(HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"deleteIdentity: arthurtest");
        Cookie c = RequestUtil.getCookie(request, "arthurtest");
        if (null != c) {
            c.setValue("");
            log.debug((Object)("deleteCookie: " + c.getName()));
            RequestUtil.deleteCookie(response, c, null, null);
        }
    }

    @Deprecated
    public static boolean checkIdentity(HttpServletRequest request) {
        Map userMap = IdentityUtil.getIdentity(request);
        if (userMap != null) {
            request.setAttribute("currentVisitor", (Object)userMap);
        }
        return userMap != null;
    }

    @Deprecated
    public static Map checkAndReturnIdentity(HttpServletRequest request) {
        Map userMap = IdentityUtil.getIdentity(request);
        if (userMap != null) {
            request.setAttribute("currentVisitor", (Object)userMap);
        }
        return userMap;
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, String userName, Long userId, int maxAge) {
        if (!IdentityUtil.isValid(userName, userId)) {
            IdentityUtil.deleteIdentity(request, response, homeName);
            return;
        }
        String value = IdentityUtil.encodeCookie(userName, userId);
        RequestUtil.setCookie(response, homeName, value, maxAge, null, null);
        Map userMap = IdentityUtil.getUserIdentity(userName, userId);
        request.setAttribute("currentVisitor", (Object)userMap);
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, String domain, Map<String, String> params, Long userId, int maxAge) {
        if (MapUtils.isEmpty(params) || StringUtils.isBlank((String)homeName) || StringUtils.isBlank((String)domain) || null == userId) {
            return;
        }
        String value = IdentityUtil.encodeCookie(params, userId);
        RequestUtil.setCookie(response, homeName, value, maxAge, domain, null);
        params.put("userId", ObjectUtils.toString((Object)userId));
        request.setAttribute("currentVisitor", params);
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, Map<String, String> params, Long userId, int maxAge) {
        if (MapUtils.isEmpty(params) || StringUtils.isBlank((String)homeName) || null == userId) {
            return;
        }
        String value = IdentityUtil.encodeCookie(params, userId);
        RequestUtil.setCookie(response, homeName, value, maxAge, null, null);
        params.put("userId", ObjectUtils.toString((Object)userId));
        request.setAttribute("currentVisitor", params);
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, String userName, Long usrId) {
        IdentityUtil.setIdentity(request, response, homeName, userName, usrId, -1);
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, String domain, Map<String, String> params, Long usrId) {
        IdentityUtil.setIdentity(request, response, homeName, domain, params, usrId, -1);
    }

    public static void setIdentity(HttpServletRequest request, HttpServletResponse response, String homeName, Map<String, String> params, Long usrId) {
        IdentityUtil.setIdentity(request, response, homeName, params, usrId, -1);
    }

    public static Map getUserIdentity(String userName, Long userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userName", userName);
        map.put("userId", userId);
        return map;
    }

    public static Map getIdentity(HttpServletRequest request, String homeName) {
        Map userMap = null;
        Cookie c = RequestUtil.getCookie(request, homeName);
        if (c != null) {
            userMap = IdentityUtil.decodeCookie(c.getValue());
        }
        return userMap;
    }

    public static Map<String, String> getMapFromCookie(HttpServletRequest request, String homeName) {
        Map<String, String> userMap = null;
        Cookie c = RequestUtil.getCookie(request, homeName);
        if (c != null) {
            userMap = IdentityUtil.decodeCookie(c);
        }
        return userMap;
    }

    public static void deleteIdentity(HttpServletRequest request, HttpServletResponse response, String homeName) {
        log.debug((Object)("deleteIdentity: " + homeName));
        Cookie c = RequestUtil.getCookie(request, homeName);
        if (null != c) {
            c.setValue("");
            c.setMaxAge(0);
            log.debug((Object)("deleteCookie: " + c.getName()));
            RequestUtil.deleteCookie(response, c, null, null);
        }
    }

    public static boolean checkIdentity(HttpServletRequest request, String homeName) {
        Map userMap = IdentityUtil.getIdentity(request, homeName);
        if (userMap != null) {
            request.setAttribute("currentVisitor", (Object)userMap);
        }
        return userMap != null;
    }

    public static Map checkAndReturnIdentity(HttpServletRequest request, String homeName) {
        Map userMap = IdentityUtil.getIdentity(request, homeName);
        if (userMap != null) {
            request.setAttribute("currentVisitor", (Object)userMap);
        }
        return userMap;
    }

    private static boolean isValid(String userName, Long userId) {
        return userName != null && StringUtils.isNotEmpty((String)userName) && null != userId;
    }

    public static long getPassportExpireTime(Cookie cookie) {
        long expireTime = -1L;
        String value = cookie.getValue();
        if (value == null) {
            return expireTime;
        }
        String[] array = StringUtils.split((String)value, (char)'|');
        if (array.length < 5) {
            return expireTime;
        }
        expireTime = ParamUtil.getLong(array[2], 0L);
        expireTime = expireTime <= 0L ? -1L : expireTime;
        return expireTime;
    }

    public static String encodeCookie(String userName, Long userId) {
        StringBuffer sb = new StringBuffer();
        sb.append(userId);
        try {
            String crypt = UserCryptUtil.userEncrypt(userName, userId);
            sb.append(SPLITTER + crypt);
        }
        catch (Exception e) {
            log.error((Object)(" UserCryptUtil.userEncrypt Exception : " + e.getMessage()));
        }
        return sb.toString();
    }

    public static String encodeCookie(Map<String, String> params, Long userId) {
        StringBuffer sb = new StringBuffer();
        sb.append(userId);
        try {
            String crypt = UserCryptUtil.userEncrypt(params, userId);
            sb.append(SPLITTER + crypt);
        }
        catch (Exception e) {
            log.error((Object)(" UserCryptUtil.userEncrypt Exception : " + e.getMessage()));
        }
        return sb.toString();
    }

    private static Map decodeCookie(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return IdentityUtil.getUserIdentity(userName, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Wrong cookie format: [" + value + "] message is:" + e.getMessage()));
            return null;
        }
        return null;
    }

    private static Map<String, String> decodeCookie(Cookie c) {
        if (null == c) {
            return null;
        }
        String value = c.getValue();
        Map<String, String> map = null;
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            map = UserCryptUtil.getMapFromPlain(plainUserInfo);
        }
        catch (Exception e) {
            log.error((Object)("Wrong cookie format: [" + value + "] message is:" + e.getMessage()));
            return null;
        }
        return map;
    }

    private static String getSplitter() {
        byte[] bytes = "|".getBytes();
        String spitter = new String(bytes);
        return "@" + spitter;
    }

    public static void main(String[] args) {
        String token = IdentityUtil.encodeCookie("xxx", (Long)-1L);
        System.out.println(token);
        Map m = IdentityUtil.decodeCookie(token);
        System.out.println(m);
    }
}

