/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.compare;

import java.lang.reflect.Field;
import java.util.Comparator;
import org.apache.commons.lang.math.NumberUtils;

public class ObjectCompare<E>
implements Comparator<E> {
    public static final String SORT_TYPE_TIME_MILLISECOND = "time_millisecond";
    public static final String SORT_TYPE_INDICATOR_VALUE = "indicator_value";
    public static final String SORT_TYPE_COMPARABLE_VALUE = "comparable_value";
    public static final String DIRECT_ASC = "asc";
    public static final String DIRECT_DESC = "desc";
    private Field sortField;
    private String direct;
    private String sortType;

    public ObjectCompare(Field sortField, String direct, String sortType) {
        this.sortField = sortField;
        this.sortField.setAccessible(true);
        this.direct = direct;
        this.sortType = sortType;
    }

    @Override
    public int compare(E o1, E o2) {
        if (null == o1 || null == o2) {
            return 0;
        }
        try {
            Comparable value1 = (Comparable)this.sortField.get(o1);
            Comparable value2 = (Comparable)this.sortField.get(o2);
            if (SORT_TYPE_TIME_MILLISECOND.equals(this.sortType)) {
                return this.compareTimeMillisecond(value1, value2);
            }
            if (SORT_TYPE_INDICATOR_VALUE.equals(this.sortType)) {
                return this.compareIndicatorValue(value1, value2);
            }
            if (SORT_TYPE_COMPARABLE_VALUE.equals(this.sortType)) {
                return this.compareComparableValue(value1, value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private int compareTimeMillisecond(Comparable value1, Comparable value2) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(this.direct)) {
            if (null != value1 && null != value2) {
                return value2.compareTo(value1);
            }
            if (null == value1) {
                return -1;
            }
            return 1;
        }
        if (null != value1 && null != value2) {
            return value1.compareTo(value2);
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    private int compareComparableValue(Comparable value1, Comparable value2) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(this.direct)) {
            if (null != value1 && null != value2) {
                return value2.compareTo(value1);
            }
            if (null == value1) {
                return 1;
            }
            return -1;
        }
        if (null != value1 && null != value2) {
            return value1.compareTo(value2);
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    private int compareIndicatorValue(Comparable value1, Comparable value2) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(this.direct)) {
            if (null != value1 && null != value2) {
                return NumberUtils.createBigDecimal((String)value2.toString()).compareTo(NumberUtils.createBigDecimal((String)value1.toString()));
            }
            if (null == value1) {
                return 1;
            }
            return -1;
        }
        if (null != value1 && null != value2) {
            return NumberUtils.createBigDecimal((String)value1.toString()).compareTo(NumberUtils.createBigDecimal((String)value2.toString()));
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    public Field getSortField() {
        return this.sortField;
    }

    public String getDirect() {
        return this.direct;
    }

    public String getSortType() {
        return this.sortType;
    }
}

