/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class MapUtil {
    private static final Logger log = Logger.getLogger(MapUtil.class);

    public static void mergeCounts(Map<String, Integer> counter, String key) {
        if (counter.containsKey(key)) {
            Integer count = counter.get(key);
            counter.put(key, count + 1);
        } else {
            counter.put(key, 1);
        }
    }

    public static void replaceMaxValue(Map<Integer, BigDecimal> maxKeeper, Integer key, BigDecimal value) {
        BigDecimal maxValue = value;
        BigDecimal oldValue = maxKeeper.get(key);
        if (oldValue == null || value.compareTo(oldValue) == 1) {
            maxValue = value;
        }
        maxKeeper.put(key, maxValue);
    }

    public static void fillMapValueByKey(Map target, Map source) {
        if (!MapUtils.isEmpty((Map)target) && !MapUtils.isEmpty((Map)source)) {
            for (Map.Entry entry : target.entrySet()) {
                Object value;
                if (null == entry || null == entry.getKey() || null == (value = source.get(entry.getKey()))) continue;
                entry.setValue(value);
            }
        }
    }

    public static void fillMapCollection(Map source, Object key, Object value) {
        if (null != source && null != key && null != value) {
            ArrayList<Object> keyValue = (ArrayList<Object>)source.get(key);
            if (null == keyValue) {
                keyValue = new ArrayList<Object>();
            }
            if (!keyValue.contains(value)) {
                keyValue.add(value);
                source.put(key, keyValue);
            }
        }
    }

    public static void fillMapCollectionIgnoreExist(Map source, Object key, Object value) {
        if (null != source && null != key && null != value) {
            ArrayList<Object> keyValue = (ArrayList<Object>)source.get(key);
            if (null == keyValue) {
                keyValue = new ArrayList<Object>();
            }
            keyValue.add(value);
            source.put(key, keyValue);
        }
    }

    public static Map intersectKeyMap(Map map, List keys) {
        if (null != map && null != keys) {
            HashMap result = new HashMap();
            Iterator i$ = map.entrySet().iterator();
            block0: while (true) {
                if (!i$.hasNext()) {
                    return result;
                }
                Map.Entry entry = i$.next();
                if (null == entry || null == entry.getKey()) continue;
                if (entry.getKey() instanceof Object[]) {
                    int keysSize = keys.size();
                    int i = 0;
                    while (true) {
                        if (i >= keysSize) continue block0;
                        if (null != keys.get(i) && keys.get(i) instanceof Object[] && ArrayUtils.isEquals(entry.getKey(), keys.get(i))) {
                            result.put(entry.getKey(), entry.getValue());
                        }
                        ++i;
                    }
                }
                if (!keys.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return new HashMap();
    }

    public static <R, T> List<T> getMapValues(Map<R, T> map, List<R> keys) {
        if (null != map && null != keys) {
            ArrayList<T> result = new ArrayList<T>();
            for (Map.Entry<R, T> entry : map.entrySet()) {
                if (null == entry || null == entry.getKey() || null == entry.getValue() || !keys.contains(entry.getKey())) continue;
                result.add(entry.getValue());
            }
            return result;
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, T extends V> V lookUpValueByKey(Map<K, V> map, K key, Class<T> tClazz) {
        Object value = map.get(key);
        if (null == value) {
            try {
                value = tClazz.newInstance();
            }
            catch (InstantiationException var9) {
                log.error((Object)var9);
                var9.printStackTrace();
            }
            catch (IllegalAccessException var10) {
                log.error((Object)var10);
                var10.printStackTrace();
            }
            finally {
                map.put(key, value);
            }
        }
        return value;
    }

    public static <R, T> Map<R, List<T>> convertMap(List<R> keys, List<T> values) {
        if (null != keys && null != values && keys.size() == values.size()) {
            HashMap<R, ArrayList<T>> map = new HashMap<R, ArrayList<T>>();
            for (int i = 0; i < keys.size(); ++i) {
                if (null == keys.get(i)) continue;
                ArrayList<T> value = (ArrayList<T>)map.get(keys.get(i));
                if (null == value) {
                    value = new ArrayList<T>();
                    map.put(keys.get(i), value);
                }
                value.add(values.get(i));
            }
            return map;
        }
        return new HashMap();
    }

    public static Map convertMap(List values, String keySplit, Field ... fields) throws IllegalArgumentException, IllegalAccessException {
        if (!ArrayUtils.isEmpty((Object[])fields) && !CollectionUtils.isEmpty((Collection)values)) {
            Field[] arr$ = fields;
            int len$ = fields.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Field field = arr$[i$];
                field.setAccessible(true);
            }
            HashMap map = new HashMap();
            StringBuilder sb = new StringBuilder();
            Iterator i$ = values.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return map;
                }
                Object o = i$.next();
                if (null == o) continue;
                sb.delete(0, sb.length());
                for (int i = 0; i < fields.length; ++i) {
                    Object fieldValue;
                    if (i > 0) {
                        sb.append(keySplit);
                    }
                    if (null == (fieldValue = fields[i].get(o))) continue;
                    sb.append(fieldValue);
                }
                map.put(sb.toString(), o);
            }
        }
        return new HashMap();
    }

    public static List getSubordinateValueMap(Map sourceTree, List keys) {
        if (null != sourceTree && null != keys) {
            ArrayList result = new ArrayList();
            MapUtil.fillSubordinateValueMap(sourceTree, keys, result);
            return result;
        }
        return new ArrayList();
    }

    private static void fillSubordinateValueMap(Map inSourceTree, List inKeys, List outResult) {
        ArrayList sub = new ArrayList();
        for (Object o : inKeys) {
            List value = (List)inSourceTree.get(o);
            if (null == value) continue;
            sub.addAll(value);
        }
        outResult.addAll(sub);
        if (sub.size() > 0) {
            MapUtil.fillSubordinateValueMap(inSourceTree, sub, outResult);
        }
    }

    public static Map reverseKeyAndValue(Map map) {
        HashMap reverseMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        return reverseMap;
    }

    public static <R, T> Map<R, T> convertList2Map(List<R> keys, List<T> values) {
        if (!CollectionUtils.isEmpty(keys) && !CollectionUtils.isEmpty(values)) {
            int keySize = keys.size();
            int valueSize = values.size();
            HashMap<R, Object> result = new HashMap<R, Object>();
            for (int i = 0; i < keySize; ++i) {
                if (null == keys.get(i)) continue;
                Object value = null;
                if (i + 1 <= valueSize) {
                    value = values.get(i);
                }
                result.put(keys.get(i), value);
            }
            return result;
        }
        return new HashMap();
    }

    public static <R, T> Map<R, T> removeAllNullValueEntry(Map<R, T> source) {
        if (null == source) {
            return new HashMap();
        }
        HashMap<R, T> map = new HashMap<R, T>();
        for (Map.Entry<R, T> entry : source.entrySet()) {
            if (null == entry.getValue() || null == entry.getKey()) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static Map<Object, List<Object[]>> getMapFromListObjArr(List<Object[]> stockQueryParam, int index, boolean removeNull) {
        HashMap<Object, List<Object[]>> stockQueryParamMap = new HashMap<Object, List<Object[]>>();
        for (Object[] arrParam : stockQueryParam) {
            Object keyParam = arrParam[index - 1];
            if (null == keyParam) continue;
            ArrayList<Object[]> queryList = (ArrayList<Object[]>)stockQueryParamMap.get(keyParam);
            if (null == queryList) {
                queryList = new ArrayList<Object[]>();
                stockQueryParamMap.put(keyParam, queryList);
            }
            queryList.add(arrParam);
        }
        return stockQueryParamMap;
    }

    public static <K, V> List<Map.Entry<K, V>> converMapToEntryList(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entryList = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entryList.add(entry);
        }
        return entryList;
    }
}

