package com.qding.common.util;

public final class SessionKeyStore {
	private static ThreadLocal<String> DEVICEID = new ThreadLocal<String>();

	private static ThreadLocal<String> TOKEN = new ThreadLocal<String>();
	private static ThreadLocal<Long>  USERID= new ThreadLocal<Long>();

	private static ThreadLocal<String> VERSION = new ThreadLocal<String>();

	// call by web client;
	public static void setDeviceId(String did) {
		DEVICEID.set(did);
	}

	// call by service;
	public static String getDeviceId() {
		return DEVICEID.get();
	}

	// call by web client;
	public static void setToken(String token) {
        TOKEN.set(token);
	}

	// call by service;
	public static String getToken() {
		return TOKEN.get();
	}

	public static void setVersion(String version) {
		VERSION.set(version);
	}

	public static String getVersion() {
		return VERSION.get();
	}

	public static void setUserId(Long userId) {
        USERID.set(userId);
	}

	public static Long getUserId() {
		return USERID.get();
	}

}
