package com.qding.common.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

public class MapUtil {
    private static final Logger log = Logger.getLogger(MapUtil.class);

    public MapUtil() {
    }

    public static void mergeCounts(Map<String, Integer> counter, String key) {
        if (counter.containsKey(key)) {
            Integer count = (Integer)counter.get(key);
            counter.put(key, count + 1);
        } else {
            counter.put(key, 1);
        }

    }

    public static void replaceMaxValue(Map<Integer, BigDecimal> maxKeeper, Integer key, BigDecimal value) {
        BigDecimal maxValue = value;
        BigDecimal oldValue = (BigDecimal)maxKeeper.get(key);
        if (oldValue == null || value.compareTo(oldValue) == 1) {
            maxValue = value;
        }

        maxKeeper.put(key, maxValue);
    }

    public static void fillMapValueByKey(Map target, Map source) {
        if (!MapUtils.isEmpty(target) && !MapUtils.isEmpty(source)) {
            Iterator i$ = target.entrySet().iterator();

            while(i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                if (null != entry && null != entry.getKey()) {
                    Object value = source.get(entry.getKey());
                    if (null != value) {
                        entry.setValue(value);
                    }
                }
            }

        }
    }

    public static void fillMapCollection(Map source, Object key, Object value) {
        if (null != source && null != key && null != value) {
            Collection keyValue = (Collection)source.get(key);
            if (null == keyValue) {
                keyValue = new ArrayList();
            }

            if (!((Collection)keyValue).contains(value)) {
                ((Collection)keyValue).add(value);
                source.put(key, keyValue);
            }
        }
    }

    public static void fillMapCollectionIgnoreExist(Map source, Object key, Object value) {
        if (null != source && null != key && null != value) {
            Collection keyValue = (Collection)source.get(key);
            if (null == keyValue) {
                keyValue = new ArrayList();
            }

            ((Collection)keyValue).add(value);
            source.put(key, keyValue);
        }
    }

    public static Map intersectKeyMap(Map map, List keys) {
        if (null != map && null != keys) {
            Map result = new HashMap();
            Iterator i$ = map.entrySet().iterator();

            while(true) {
                while(true) {
                    Map.Entry entry;
                    do {
                        do {
                            if (!i$.hasNext()) {
                                return result;
                            }

                            entry = (Map.Entry)i$.next();
                        } while(null == entry);
                    } while(null == entry.getKey());

                    if (entry.getKey() instanceof Object[]) {
                        int keysSize = keys.size();

                        for(int i = 0; i < keysSize; ++i) {
                            if (null != keys.get(i) && keys.get(i) instanceof Object[] && ArrayUtils.isEquals(entry.getKey(), keys.get(i))) {
                                result.put(entry.getKey(), entry.getValue());
                            }
                        }
                    } else if (keys.contains(entry.getKey())) {
                        result.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        } else {
            return new HashMap();
        }
    }

    public static <R, T> List<T> getMapValues(Map<R, T> map, List<R> keys) {
        if (null != map && null != keys) {
            List<T> result = new ArrayList();
            Iterator i$ = map.entrySet().iterator();

            while(i$.hasNext()) {
                Map.Entry<R, T> entry = (Map.Entry)i$.next();
                if (null != entry && null != entry.getKey() && null != entry.getValue() && keys.contains(entry.getKey())) {
                    result.add(entry.getValue());
                }
            }

            return result;
        } else {
            return new ArrayList();
        }
    }


    public static <K, V, T extends V> V lookUpValueByKey(Map<K, V> map, K key, Class<T> tClazz) {
        V value = map.get(key);
        if (null == value) {
            try {
                value = tClazz.newInstance();
            } catch (InstantiationException var9) {
                log.error(var9);
                var9.printStackTrace();
            } catch (IllegalAccessException var10) {
                log.error(var10);
                var10.printStackTrace();
            } finally {
                map.put(key, value);
            }
        }

        return value;
    }

    public static <R, T> Map<R, List<T>> convertMap(List<R> keys, List<T> values) {
        if (null != keys && null != values && keys.size() == values.size()) {
            Map<R, List<T>> map = new HashMap();

            for(int i = 0; i < keys.size(); ++i) {
                if (null != keys.get(i)) {
                    List<T> value = (List)map.get(keys.get(i));
                    if (null == value) {
                        value = new ArrayList();
                        map.put(keys.get(i), value);
                    }

                    ((List)value).add(values.get(i));
                }
            }

            return map;
        } else {
            return new HashMap();
        }
    }

    public static Map convertMap(List values, String keySplit, Field... fields) throws IllegalArgumentException, IllegalAccessException {
        if (!ArrayUtils.isEmpty(fields) && !CollectionUtils.isEmpty(values)) {
            Field[] arr$ = fields;
            int len$ = fields.length;

            for(int i$ = 0; i$ < len$; ++i$) {
                Field field = arr$[i$];
                field.setAccessible(true);
            }

            Map map = new HashMap();
            StringBuilder sb = new StringBuilder();
            Iterator i$ = values.iterator();

            while(true) {
                Object o;
                do {
                    if (!i$.hasNext()) {
                        return map;
                    }

                    o = i$.next();
                } while(null == o);

                sb.delete(0, sb.length());

                for(int i = 0; i < fields.length; ++i) {
                    if (i > 0) {
                        sb.append(keySplit);
                    }

                    Object fieldValue = fields[i].get(o);
                    if (null != fieldValue) {
                        sb.append(fieldValue);
                    }
                }

                map.put(sb.toString(), o);
            }
        } else {
            return new HashMap();
        }
    }

    public static List getSubordinateValueMap(Map sourceTree, List keys) {
        if (null != sourceTree && null != keys) {
            List result = new ArrayList();
            fillSubordinateValueMap(sourceTree, keys, result);
            return result;
        } else {
            return new ArrayList();
        }
    }

    private static void fillSubordinateValueMap(Map inSourceTree, List inKeys, List outResult) {
        List sub = new ArrayList();
        Iterator i$ = inKeys.iterator();

        while(i$.hasNext()) {
            Object o = i$.next();
            List value = (List)inSourceTree.get(o);
            if (null != value) {
                sub.addAll(value);
            }
        }

        outResult.addAll(sub);
        if (sub.size() > 0) {
            fillSubordinateValueMap(inSourceTree, sub, outResult);
        }

    }

    public static Map reverseKeyAndValue(Map map) {
        Map reverseMap = new HashMap();
        Iterator i$ = map.entrySet().iterator();

        while(i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            reverseMap.put(entry.getValue(), entry.getKey());
        }

        return reverseMap;
    }

    public static <R, T> Map<R, T> convertList2Map(List<R> keys, List<T> values) {
        if (!CollectionUtils.isEmpty(keys) && !CollectionUtils.isEmpty(values)) {
            int keySize = keys.size();
            int valueSize = values.size();
            Map<R, T> result = new HashMap();

            for(int i = 0; i < keySize; ++i) {
                if (null != keys.get(i)) {
                    T value = null;
                    if (i + 1 <= valueSize) {
                        value = values.get(i);
                    }

                    result.put(keys.get(i), value);
                }
            }

            return result;
        } else {
            return new HashMap();
        }
    }

    public static <R, T> Map<R, T> removeAllNullValueEntry(Map<R, T> source) {
        if (null == source) {
            return new HashMap();
        } else {
            Map<R, T> map = new HashMap();
            Iterator i$ = source.entrySet().iterator();

            while(i$.hasNext()) {
                Map.Entry<R, T> entry = (Map.Entry)i$.next();
                if (null != entry.getValue() && null != entry.getKey()) {
                    map.put(entry.getKey(), entry.getValue());
                }
            }

            return map;
        }
    }

    public static Map<Object, List<Object[]>> getMapFromListObjArr(List<Object[]> stockQueryParam, int index, boolean removeNull) {
        Map<Object, List<Object[]>> stockQueryParamMap = new HashMap();
        Iterator i$ = stockQueryParam.iterator();

        while(i$.hasNext()) {
            Object[] arrParam = (Object[])i$.next();
            Object keyParam = arrParam[index - 1];
            if (null != keyParam) {
                List<Object[]> queryList = (List)stockQueryParamMap.get(keyParam);
                if (null == queryList) {
                    queryList = new ArrayList();
                    stockQueryParamMap.put(keyParam, queryList);
                }

                ((List)queryList).add(arrParam);
            }
        }

        return stockQueryParamMap;
    }


    public static <K, V> List<Map.Entry<K, V>> converMapToEntryList(Map<K, V> map) {
        List<Map.Entry<K, V>> entryList = new ArrayList();
        Iterator i$ = map.entrySet().iterator();

        while(i$.hasNext()) {
            Map.Entry<K, V> entry = (Map.Entry)i$.next();
            entryList.add(entry);
        }

        return entryList;
    }

}
