/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.compare;

import com.qding.common.util.PinyinUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinYinCompare
implements Comparator<String> {
    private static final Log log = LogFactory.getLog(PinYinCompare.class);

    @Override
    public int compare(String o1, String o2) {
        for (int i = 0; i < o1.length() && i < o2.length(); ++i) {
            char c1 = o1.charAt(i);
            char c2 = o2.charAt(i);
            String pinyin1 = PinYinCompare.pinyin(c1);
            String pinyin2 = PinYinCompare.pinyin(c2);
            if (pinyin1 != null && pinyin2 != null) {
                if (pinyin1.equals(pinyin2)) continue;
                return pinyin1.compareTo(pinyin2);
            }
            if (o1.length() != o2.length() || c1 == c2) continue;
            return c1 - c2;
        }
        if (o1.length() > o2.length()) {
            return 1;
        }
        if (o1.length() < o2.length()) {
            return -1;
        }
        return 0;
    }

    private static String pinyin(char c) {
        String[] values = PinyinUtil.getPinyin(String.valueOf(c));
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static void main(String[] args) {
        PinYinCompare comparator = new PinYinCompare();
        ArrayList<String> userlist = new ArrayList<String>();
        userlist.add("\u51af");
        userlist.add("\u51af\u57f9\u5b87");
        userlist.add("\u51af\u57f9");
        userlist.add("\u4efb\u6d77\u4e3d");
        userlist.add("\u4efb\u5927\u4e3d");
        userlist.add("\u963f\u6668\u98de");
        userlist.add("bad");
        userlist.add("\u83dc\u9e1f");
        userlist.add("\u5927\u529b");
        Collections.sort(userlist, comparator);
        log.info(userlist);
    }
}

