package com.qding.common.util;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

public class TimeUtil {
    private static final Log log = LogFactory.getLog(TimeUtil.class);
    private static final String dateFormat1 = "yyyy-MM-dd HH:mm:ss";

    public TimeUtil() {
    }

    public static Date getDatebyString(String day, String dataFormat) {
        if (StringUtils.isBlank(day)) {
            return null;
        } else {
            if (StringUtils.isBlank(dataFormat)) {
                dataFormat = "yyyy-MM-dd HH:mm:ss";
            }

            DateFormat format = new SimpleDateFormat(dataFormat);
            Date date = null;

            try {
                date = format.parse(day);
            } catch (ParseException var5) {
                log.error("error@parse date", var5);
                var5.printStackTrace();
            }

            return date;
        }
    }


    public static String convertLong2String(Long time, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date myDate = new Date(time);
        return formatter.format(myDate);
    }

    public static Integer convertHour(Long createAt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(createAt);
        return cal.get(10);
    }

    public static Integer convertHHHour(Long createAt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(createAt);
        return cal.get(11);
    }

    public static Long convertString2Long(String time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static Long convertDate2Long(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.getTimeInMillis();
    }

    public static int getUnit(String time, String format, int circle) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(circle);
    }

    public static Date convertLong2Date(Long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime();
    }

    /**
     * string类型date转为毫秒
     *
     * @param string data string
     * @param locale default  Locale.CHINA
     * @return Millions
     */
    public static Long stringToTimeMillions(String string, Locale locale) {
        if (locale==null) {
            locale = Locale.CHINA;
        }
        String[] possibleDateFormats =
                {
                        "yyyy-MM-dd HH:mm:ss",
                        "yyyy-MM-dd HH:mm",
                        "MM-dd-yyyy HH:mm:ss",
                        "MM-dd-yyyy HH:mm:",
                        "yyyy/MM/dd HH:mm:ss",
                        "yyyy/MM/dd HH:mm",
                        "MM/dd/yyyy HH:mm:ss",
                        "MM/dd/yyyy HH:mm:",
                };
        try {
            return  DateUtils.parseDate(string,locale,possibleDateFormats).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getYearByCurrentTime() {
        String lastYear = "0000";
        lastYear = convertLong2String(System.currentTimeMillis(), "yyyy");
        return lastYear;
    }

    public static Long getPreZeroTimeMillions(int preday) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -preday);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static Long getPreEndTimeMillions(int preday) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -preday);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static Date getDateZeroTimeMillions(Long begin) {
        Calendar calendar = Calendar.getInstance();
        Date value = new Date(begin);

        try {
            calendar.setTime(value);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } catch (Exception var4) {
            log.error("getDateZeroTimeMillions error", var4);
        }

        return calendar.getTime();
    }

    public static Date getYearEndDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);

            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } catch (Exception var4) {
                log.error("getYearEndDate error", var4);
            }

            return calendar.getTime();
        } else {
            return null;
        }
    }

    public static Integer getYearEndInteger(Long time) {
        if (null != time && !time.equals(0)) {
            SimpleDateFormat formate = new SimpleDateFormat("yyyyMMdd");
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);

            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 12);
            } catch (Exception var5) {
                log.error("getYearEndInteger error", var5);
            }

            return MyMathUtil.getInteger(formate.format(calendar.getTime()));
        } else {
            return null;
        }
    }

    public static Date get2YearsAgoDate(Long time) {
        String day = convertLong2String(time, "yyyy") + "0101";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        Date date = null;

        try {
            date = formatter.parse(day);
            calendar.setTime(date);
            calendar.add(1, -2);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } catch (ParseException var6) {
            log.error("get2YearsAgoDate error", var6);
        }

        return calendar.getTime();
    }

    public static Date getYearBeginDayZeroTimeDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);

            try {
                calendar.setTime(value);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } catch (Exception var4) {
                log.error("getDateZeroTimeMillions error", var4);
            }

            return calendar.getTime();
        } else {
            return null;
        }
    }

    public static Date getYearEndDayZeroTimeDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);

            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } catch (Exception var4) {
                log.error("getDateZeroTimeMillions error", var4);
            }

            return calendar.getTime();
        } else {
            return null;
        }
    }

    public static Date getDateEndTimeMillions(Long end) {
        Calendar calendar = Calendar.getInstance();
        Date value = new Date(end);

        try {
            calendar.setTime(value);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        } catch (Exception var4) {
            log.error("getLongEndTimeMillions error", var4);
        }

        return calendar.getTime();
    }

    public static String convertDate2String(Date date, String pattern) {
        if (date == null) {
            log.error("date is null; pattern = " + pattern);
            return "";
        } else {
            return convertLong2String(date.getTime(), pattern);
        }
    }

    public static String cutDate(String time, String format, int circle) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String month;
        switch(circle) {
            case 1:
                return String.valueOf(calendar.get(1));
            case 2:
                month = calendar.get(2) < 9 ? "0" + (calendar.get(2) + 1) : "" + (calendar.get(2) + 1);
                return calendar.get(1) + month;
            case 3:
            case 4:
            default:
                return null;
            case 5:
                month = calendar.get(2) < 9 ? "0" + (calendar.get(2) + 1) : "" + (calendar.get(2) + 1);
                String day = calendar.get(5) < 10 ? "0" + calendar.get(5) : "" + calendar.get(5);
                return calendar.get(1) + month + day;
        }
    }

    public static Date getDateZeroTime(String date) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        Date value = new Date();

        try {
            value = formate.parse(date);
        } catch (ParseException var4) {
            log.error("got error when parse dateString:", var4);
        }

        return value;
    }

    public static Date getDateEndTime(String date) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        new Date();

        try {
            Date value = formate.parse(date);
            calendar.setTime(value);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        } catch (ParseException var5) {
            log.error("got error when parse dateString:", var5);
        }

        return calendar.getTime();
    }

    public static Long getTimeInyyyyMMddHHmmss() {
        SimpleDateFormat fullDate = new SimpleDateFormat("yyyyMMddHHmmss");
        Long updateTime = MyMathUtil.getLong(fullDate.format(new Date()));
        return updateTime;
    }

    public static Long getTimeInyyyyMMdd() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Long updateTime = MyMathUtil.getLong(dateFormat.format(date));
        return updateTime;
    }

    // 获得本日0点毫秒
    public static Long getTimesTodayZoreMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得本日X点毫秒
    public static Long getTimesTodayHourInMillis(Integer hour) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, hour);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得本日最后毫秒
    public static Long getTimesTodayLastMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得某日开始毫秒
    public static Long getTimesFirstInMillisByMillis( Long times) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(times);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得某日最后毫秒
    public static Long getDayTimesLastInMillis(Long times) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(times);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return  cal.getTimeInMillis()/1000L*1000L;
    }

    // 获得本周一0点时间毫秒
    public static Long getTimesWeekmorningInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY), cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得本周日24点时间毫秒
    public  static Long getTimesWeeknightInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getTimesWeekmorning());
        cal.add(Calendar.DAY_OF_WEEK, 7);
        return cal.getTimeInMillis()/1000L*1000L;
    }

    // 获得本周一0点时间date
    public static Date getTimesWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY), cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        return  cal.getTime();

    }

    // 获得本周日24点时间date
    public  static Date getTimesWeeknight() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getTimesWeekmorning());
        cal.add(Calendar.DAY_OF_WEEK, 7);
        return cal.getTime();
    }
    // 获得本月1号0点时间毫秒
    public static Long getTimesMonthStart() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.MONTH,-1);
        cal.set(Calendar.DAY_OF_MONTH,1);
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    // 获得本月最后一天时间毫秒
    public static Long getTimesMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH,cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        return  cal.getTimeInMillis()/1000L*1000L;
    }
    //获得今天周几
    public static int getWeekDay () {
        Date today = new Date();
        int[] weekDays = {7, 1, 2, 3, 4, 5, 6};
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int w = c.get(Calendar.DAY_OF_WEEK) - 1;
        if (w<0) {
            w = 0;
        }
        return weekDays[w];
    }

    //时分转秒
    public static int getTimeSecond(String time) {
        String[] times =  time.split(":");
        return (Integer.valueOf(times[0])*60*60+Integer.valueOf(times[1])*60);
    }

    //获取当前时间距离0点秒数
    public static int getCurrentSecond() {
        Long zero = getTimesTodayZoreMillis();
        Long ms = (System.currentTimeMillis() - zero)/1000;
        return ms.intValue();
    }

    public static String toDate(String time) {
        //这个是你要转成后的时间的格式
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(Long.parseLong(time)));
    }
    
    public static boolean isSameDay(long firstTime, long secondTime) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		boolean result=false;
		Calendar calendar = Calendar.getInstance();
		Calendar calendar2 = Calendar.getInstance();
		calendar.setTimeInMillis(firstTime);
		int y1 = calendar.get(Calendar.YEAR);//获取年份
		int d1 = calendar.get(Calendar.DAY_OF_YEAR);//获取年中第几天
		calendar2.setTimeInMillis(secondTime);
		
		int y2 = calendar2.get(Calendar.YEAR);
		int d2 = calendar2.get(Calendar.DAY_OF_YEAR);
		if (y1 == y2 && d1 == d2){
			result=true;
		}else{
			result=false;
		}	
		return result;

	
	}
	
	public static void main(String[] args) {
		Long first=System.currentTimeMillis();
		long second=first-24*3600*1000+10*3600*1000;
		boolean result=TimeUtil.isSameDay(first,second);
		log.info(result);
	}


}
