/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinyinUtil {
    private static final Log log = LogFactory.getLog(PinyinUtil.class);
    private static String defaultPropertyFile = "unicode_to_hanyu_pinyin.txt";
    public static Map<String, String[]> pinyinMap = new HashMap<String, String[]>();

    /*
     * WARNING - void declaration
     */
    public static String[] getPinyinAcronym(String key) {
        if (key == null) {
            return null;
        }
        ArrayList<Object> acronyms = new ArrayList<Object>();
        for (int i = 0; i < key.length(); ++i) {
            LinkedHashSet acronym = new LinkedHashSet();
            char c = key.charAt(i);
            String ascii = Integer.toHexString(c).toUpperCase();
            String[] values = pinyinMap.get(ascii);
            if (values == null || values.length <= 0) {
                acronym.add(Character.valueOf(c));
            } else {
                for (int v = 0; v < values.length; ++v) {
                    String word;
                    String value = values[v];
                    if (value.trim().toUpperCase().length() <= 0 || StringUtils.isEmpty((String)(word = value.trim().toUpperCase()))) continue;
                    acronym.add(Character.valueOf(word.charAt(0)));
                }
            }
            acronyms.add(acronym);
        }
        List<String> result = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(acronyms)) {
            for (Set set : acronyms) {
                List<String> sub = PinyinUtil.composeChar(result, set);
                result = sub;
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return new String[0];
        }
        String[] r = new String[result.size()];
        boolean bl = false;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            void var4_8;
            String s;
            r[var4_8] = s = (String)iterator.next();
            ++var4_8;
        }
        return r;
    }

    private static List<String> composeChar(List<String> subList, Set<Character> chars) {
        if (CollectionUtils.isEmpty(chars)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Character c : chars) {
            if (CollectionUtils.isEmpty(subList)) {
                result.add(String.valueOf(c).trim());
                continue;
            }
            for (String sub : subList) {
                result.add((sub + String.valueOf(c)).trim());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getPinyin(String key) {
        if (key == null) {
            return null;
        }
        ArrayList<Set<String>> acronyms = new ArrayList<Set<String>>();
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            Set<String> set = PinyinUtil.getCharPinyin(ch);
            acronyms.add(set);
        }
        List<String> result = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(acronyms)) {
            for (Set set : acronyms) {
                List<String> sub = PinyinUtil.composeStr(result, set);
                result = sub;
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return new String[0];
        }
        String[] r = new String[result.size()];
        boolean bl = false;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            void var4_11;
            String s;
            r[var4_11] = s = (String)iterator.next();
            ++var4_11;
        }
        return r;
    }

    public static String getAcronymFromPinyin(String full) {
        if (StringUtils.isEmpty((String)full)) {
            return "";
        }
        String[] words = full.split(" ");
        StringBuffer acronym = new StringBuffer("");
        for (int j = 0; j < words.length; ++j) {
            String word = words[j].trim().toUpperCase();
            if (StringUtils.isEmpty((String)word)) {
                log.info((Object)("in-correct pinyin : " + full));
                continue;
            }
            acronym.append(word.charAt(0));
        }
        return acronym.toString();
    }

    private static List<String> composeStr(List<String> subList, Set<String> strs) {
        if (CollectionUtils.isEmpty(strs)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String c : strs) {
            if (CollectionUtils.isEmpty(subList)) {
                result.add(c.trim());
                continue;
            }
            for (String sub : subList) {
                result.add((sub + " " + c).trim());
            }
        }
        return result;
    }

    public static Set<String> getCharPinyin(char ch) {
        LinkedHashSet<String> acronym = new LinkedHashSet<String>();
        String ascii = Integer.toHexString(ch).toUpperCase();
        String[] values = pinyinMap.get(ascii);
        if (values == null) {
            acronym.add(String.valueOf(ch));
        } else {
            for (int v = 0; v < values.length; ++v) {
                String value = values[v];
                if (value.trim().toUpperCase().length() <= 0) continue;
                acronym.add(value.trim());
            }
        }
        return acronym;
    }

    public static String[] judgeByPinyin(String key) {
        char ch = key.charAt(0);
        String ascii = Integer.toHexString(ch).toUpperCase();
        String[] value = pinyinMap.get(ascii);
        return value;
    }

    public static void main(String[] args) {
        String[] v = PinyinUtil.judgeByPinyin("z");
        log.info((Object)v);
    }

    public static void Load() {
    }

    public static boolean isChinese(String key) {
        char ch = key.charAt(0);
        String ascii = Integer.toHexString(ch).toUpperCase();
        String[] value = pinyinMap.get(ascii);
        return value != null && value.length > 0;
    }

    static {
        String fileName = PinyinUtil.class.getClassLoader().getResource(defaultPropertyFile).getFile();
        File file = new File(fileName);
        int count = 0;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(fileReader);
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                log.debug((Object)line);
                String[] lines = line.split(" ");
                String[] values = new String[]{};
                if (lines.length >= 2) {
                    String value = lines[1];
                    value = value.replace("(", "").replace(")", "");
                    String[] res = value.split(",");
                    values = new String[res.length];
                    if (null != res && res.length >= 1) {
                        for (int i = 0; i < res.length; ++i) {
                            values[i] = res[i].substring(0, res[i].length() - 1);
                        }
                    }
                }
                pinyinMap.put(lines[0], values);
                log.debug((Object)(lines[0] + " " + values));
                ++count;
            }
            bufReader.close();
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)count);
    }
}

