package com.ptteng.sca.common.takeout.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.takeout.model.TakeoutCategory;
import com.ptteng.common.takeout.model.TakeoutGoods;
import com.ptteng.common.takeout.service.TakeoutGoodsService;

import java.util.List;

/**
 * Created by Master on 2018/3/14.
 */
public class TakeoutGoodsSCAClient implements TakeoutGoodsService{
    private TakeoutGoodsService takeoutGoodsService;

    public TakeoutGoodsService getTakeoutGoodsService () {return takeoutGoodsService;}
    public void setTakeoutGoodsService (TakeoutGoodsService takeoutGoodsService){ this.takeoutGoodsService = takeoutGoodsService;}

    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long categoryId, TakeoutCategory takeoutCategory)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.saveDishGroup(mchId,storeId,categoryId,takeoutCategory);
    }
    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long categoryId, TakeoutCategory takeoutCategory)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.updateDishGroup(mchId,storeId,categoryId,takeoutCategory);
    }
    @Override
    public void onlineDish(Long mchId, Long storeId, Long goodsId, TakeoutGoods takeoutGoods)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.onlineDish(mchId,storeId,goodsId,takeoutGoods);
    }
    @Override
    public void offlineDish(Long mchId, Long storeId, Long goodsId)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.offlineDish(mchId,storeId,goodsId);
    }
    @Override
    public void updateDish(Long mchId, Long storeId, Long goodsId, TakeoutGoods takeoutGoodsList)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.updateDish(mchId,storeId,goodsId,takeoutGoodsList);
    }
    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<TakeoutGoods> takeoutGoodsList)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.batchUpdateDish(mchId,storeId,takeoutGoodsList);
    }
    @Override
    public void batchCreateDish(Long mchId, Long storeId, List<TakeoutGoods> takeoutGoodsList)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.batchCreateDish(mchId,storeId,takeoutGoodsList);
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long goodsId, int stock)throws ServiceException, ServiceDaoException {
        takeoutGoodsService.setThreshold(mchId,storeId,goodsId,stock);
    }

}
