package com.ptteng.common.takeout.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.takeout.model.TakeoutComment;
import com.ptteng.common.takeout.model.TakeoutShop;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 * Created on 17-11-14
 * @author Master
 */
@Remotable
public interface TakeoutStoreService {

    /**
     * 查询门店信息
     * @param mchId 品牌id
     * @param storeId 门店id
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public TakeoutShop getStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;
    /**
     *  更新门店信息
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param takeoutShop 门店信息
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void updateStore(Long mchId, Long storeId, TakeoutShop takeoutShop,String platform) throws ServiceException, ServiceDaoException;


    /**
     * 门店上线（所有外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    /**
     * 门店下线（所有外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    /**
     * 门店上线（单个外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param platform 平台代码
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException;

    /**
     * 门店下线（单个外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param platform 平台代码
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException;

    /**
     * 获取门店评论
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param startTime 开始时间（单位秒）
     * @param endTime 结束时间（单位秒）
     * @param pageSize 页面数据大小
     * @param offset 页面偏移量
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    List<TakeoutComment> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize,int offset
    ) throws ServiceException, ServiceDaoException;

    /**
     * 回复门店评论
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param commentId 评论id
     * @param replyContent 回复内容
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException;
}
