package com.ptteng.common.takeout.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.takeout.model.TakeoutCategory;
import com.ptteng.common.takeout.model.TakeoutGoods;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 *
 * @author Master
 * @date 2018/3/14
 */
@Remotable
public interface TakeoutGoodsService {
    /**
     *  创建菜品分类
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param categoryId 分类id
     * @param takeoutCategory 分类信息
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void saveDishGroup(Long mchId, Long storeId, Long categoryId, TakeoutCategory takeoutCategory) throws ServiceException, ServiceDaoException;

    /**
     *  修改菜品分类
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param categoryId 分类id
     * @param takeoutCategory 分类信息
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void updateDishGroup(Long mchId, Long storeId, Long categoryId, TakeoutCategory takeoutCategory) throws ServiceException, ServiceDaoException;
    //菜品上架
    void onlineDish(Long mchId, Long storeId, Long goodsId, TakeoutGoods takeoutGoods) throws ServiceException, ServiceDaoException;
    //菜品下架
    void offlineDish(Long mchId, Long storeId, Long goodsId) throws ServiceException, ServiceDaoException;
    //修改菜品
    void updateDish(Long mchId, Long storeId, Long goodsId, TakeoutGoods takeoutGoodsList) throws ServiceException, ServiceDaoException;
    /**
     *  批量修改菜品
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param takeoutGoodsList 菜品信息列表
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void batchUpdateDish(Long mchId, Long storeId, List<TakeoutGoods> takeoutGoodsList) throws ServiceException, ServiceDaoException;
    /**
     *  批量添加菜品
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param takeoutGoodsList 菜品信息列表
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    void batchCreateDish(Long mchId, Long storeId, List<TakeoutGoods> takeoutGoodsList) throws ServiceException, ServiceDaoException;
    //设置菜品库存
    void setThreshold(Long mchId, Long storeId, Long goodsId, int stock) throws ServiceException, ServiceDaoException;

}
