package com.ptteng.common.takeout.model.meituan;

import com.ptteng.common.takeout.model.meituan.AvailableTimes;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;

/**
 * Author wanglei
 * Created on 17-11-15
 */
public class SkusEPR implements Serializable {

    private static final long serialVersionUID = 6569865771931835136L;
    private String skuId; //erp方sku ID
    private String spec;  //sku的规格
    private String upc;  //sku的upc码
    private Integer stock;//库存数量，stock不能为负数，也不能为小数，传 "*" 表示库存无限
    private AvailableTimes availableTimes;//表示sku起售时间，要保证不同时间段之间不存在交集，默认与门店营业时间一致 {"monday":"19:00-21:00,23:00-23:59","tuesday":"19:00-21:00","wednesday":"23:00-23:59","thursday":"23:00-23:59","friday":"19:00-21:00","saturday":"23:00-23:59","sunday":"19:00-21:00"}
    private String locationCode;//esku的料位码
    private BigDecimal price;//价格，price不能为负数，不能超过10个字

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUpc() {
        return upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public AvailableTimes getAvailableTimes() {
        return availableTimes;
    }

    public void setAvailableTimes(AvailableTimes availableTimes) {
        this.availableTimes = availableTimes;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

}
