package com.ptteng.common.takeout.model.meituan;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 美团EPR订单优惠信息
 * Created by shaobo on 2017/12/7.
 */
public class OrderExtrasEPR implements Serializable {
    private static final long serialVersionUID = 6569856771931835137L;
    private BigDecimal mt_charge; //该活动中美团承担的费用
    private BigDecimal poi_charge;//餐盒数量 餐盒总数量，例如一份菜A需要1个餐盒，订单中点了2份菜A，餐盒数量为2
    private BigDecimal reduce_fee;//活动优惠金额，是在原价基础上减免的金额。并非一定等于美团承担活动费用和商户承担费用的总和，如type=23，即买赠活动时，赠品的成本虽然由商家承担，但这部分不算在活动优惠金额内
    private String remark;//优惠说明
    /*
    * 优惠活动类型（1-新用户立减；2-满减；4-套餐赠送；5-满赠；9-使用红包；11-提前下单减；16-满免配送费(即将废弃)；
    * 17-折扣商品；18-美团专送再减(即将废弃)；
    * 19-点评券；
    * 20-第二份半价；
    * 21-会员免配送费；
    * 22-门店新客立减；
    * 23-买赠；
    * 24-平台新用户立减；
    * 25-满减配送费；
    * 100-满返商家代金券；
    * 101-使用商家代金券；
    * 103-进店领券）
    * */
    private Integer type;


    public BigDecimal getMtCarge (){return mt_charge;}
    public void setMtCarge (BigDecimal mt_charge) { this.mt_charge = mt_charge;}

    public BigDecimal getPoiCharge (){return poi_charge;}
    public void setPoiCharge (BigDecimal poi_charge) { this.poi_charge = poi_charge;}

    public BigDecimal getReduceFee (){return reduce_fee;}
    public void setReduceFee (BigDecimal reduce_fee) { this.reduce_fee = reduce_fee;}

    public String getRemark (){return remark;}
    public void setRemark (String remark) { this.remark = remark;}

    public Integer getType (){return type;}
    public void setType (Integer type) { this.type = type;}

}
