package com.ptteng.common.takeout.model.ele;

import java.io.Serializable;
import java.math.BigDecimal;

public class OSpec implements Serializable {

    private static final long serialVersionUID = 6569231273331225136L;
    private Long specId;//规格Id
    private String name;//名称
    private BigDecimal price;//商品价格
    private int stock;//库存量
    private int maxStock;//最大库存量
    private Integer stockStatus;//库存状态
    private BigDecimal packingFee;//包装费
    private int onShelf;//是否上架
    private String extendCode;//商品扩展码
    private String barCode;//商品条形码
    private Integer weight;//商品重量，单位为克。如果商品的店铺的类型是新零售，那么该属性必选
    private int activityLevel;//商品活动信息，1:有活动，0:无活动，活动商品不支持修改，如需修改请先取消活动，activityLevel字段只能查询，不能更新
    private String supplyLink;//配送链路配置

    public Long getSpecId() {
        return specId;
    }

    public void setSpecId(Long specId) {
        this.specId = specId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public int getStock() {
        return stock;
    }

    public void setStock(int stock) {
        this.stock = stock;
    }

    public int getMaxStock() {
        return maxStock;
    }

    public void setMaxStock(int maxStock) {
        this.maxStock = maxStock;
    }

    public Integer getStockStatus() {
        return stockStatus;
    }

    public void setStockStatus(Integer stockStatus) {
        this.stockStatus = stockStatus;
    }

    public BigDecimal getPackingFee() {
        return packingFee;
    }

    public void setPackingFee(BigDecimal packingFee) {
        this.packingFee = packingFee;
    }

    public int getOnShelf() {
        return onShelf;
    }

    public void setOnShelf(int onShelf) {
        this.onShelf = onShelf;
    }

    public String getExtendCode() {
        return extendCode;
    }

    public void setExtendCode(String extendCode) {
        this.extendCode = extendCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public int getActivityLevel() {
        return activityLevel;
    }

    public void setActivityLevel(int activityLevel) {
        this.activityLevel = activityLevel;
    }

    public String getSupplyLink() {
        return supplyLink;
    }

    public void setSupplyLink(String supplyLink) {
        this.supplyLink = supplyLink;
    }
}