/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.service.Ks3;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.utils.StringUtils;
import com.ptteng.common.storage.util.ImgStorageUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImgStorageUtilJSImpl
implements ImgStorageUtil {
    private static final Log log = LogFactory.getLog(ImgStorageUtilJSImpl.class);
    private String akey;
    private String skey;
    private String bucketName;
    private Ks3 client;
    private String domain = ".kssws.ks-cdn.com";

    public ImgStorageUtilJSImpl(String akey, String skey) {
        this.akey = akey;
        this.skey = skey;
        this.client = new Ks3Client(akey, skey);
        log.info((Object)" init client success ");
    }

    public ImgStorageUtilJSImpl() {
        this.client = new Ks3Client(this.akey, this.skey);
        log.info((Object)" init client success ");
    }

    public void initClient() {
        this.client = new Ks3Client(this.akey, this.skey);
        log.info((Object)" init client success ");
    }

    public String getAkey() {
        return this.akey;
    }

    public void setAkey(String akey) {
        this.akey = akey;
    }

    public String getSkey() {
        return this.skey;
    }

    public void setSkey(String skey) {
        this.skey = skey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public Ks3 getClient() {
        return this.client;
    }

    public void setClient(Ks3 client) {
        this.client = client;
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        String bucket = this.bucketName;
        if (StringUtils.isBlank((String)dir)) {
            log.info((Object)"dir is empty,use default bucket ");
        } else {
            bucket = dir;
        }
        PutObjectRequest request = new PutObjectRequest(bucket, yunFileName, new File(picFile));
        request.setCannedAcl(CannedAccessControlList.PublicRead);
        this.client.putObject(request);
        String url2 = this.generateUrl(bucket, yunFileName);
        log.info((Object)(bucket + " and key " + yunFileName + " get url2 is " + url2));
        return url2;
    }

    private String generateUrl(String dir, String yunFileName) {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("http://");
        sb = sb.append(dir);
        sb = sb.append(this.domain);
        sb = sb.append("/");
        sb = sb.append(yunFileName);
        return sb.toString();
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }
}

