/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qcloud.cosapi.api.CosCloud;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class ImgStorageTencentServiceImpl
implements ImgStorageUtil {
    private static final Log log = LogFactory.getLog(ImgStorageTencentServiceImpl.class);
    private String APP_ID;
    private String SECRET_ID;
    private String SECRET_KEY;
    private String bucketName;
    private CosCloud cos;

    public ImgStorageTencentServiceImpl(String APP_ID, String SECRET_ID, String SECRET_KEY) {
        this.APP_ID = APP_ID;
        this.SECRET_ID = SECRET_ID;
        this.SECRET_KEY = SECRET_KEY;
        if (null != APP_ID) {
            this.cos = new CosCloud(Integer.valueOf(APP_ID).intValue(), SECRET_ID, SECRET_KEY, 60);
        }
    }

    public void initClient() {
        log.info((Object)" init start ");
        if (null != this.APP_ID) {
            this.cos = new CosCloud(Integer.valueOf(this.APP_ID).intValue(), this.SECRET_ID, this.SECRET_KEY, 60);
        }
        log.info((Object)" init cos success ");
    }

    public ImgStorageTencentServiceImpl() {
        if (null != this.APP_ID) {
            this.cos = new CosCloud(Integer.valueOf(this.APP_ID).intValue(), this.SECRET_ID, this.SECRET_KEY, 60);
        }
        log.info((Object)" init cos success ");
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        log.info((Object)" storage start  ");
        try {
            String result = this.cos.getFolderList(this.bucketName, "/", 20, "", 0, CosCloud.FolderPattern.Both);
            log.info((Object)("  getFolderList result: = " + result));
            result = this.cos.createFolder(this.bucketName, "/" + dir + "/");
            log.info((Object)("createFolder result: " + result));
            result = this.cos.uploadFile(this.bucketName, yunFileName, picFile);
            log.info((Object)(" result = " + result));
            System.out.println(" result = " + result);
            JSONObject jsonObject = new JSONObject(result);
            Integer code = (Integer)jsonObject.get("code");
            Integer success = 0;
            if (success.equals(code)) {
                log.info((Object)" upload file success ");
                JSONObject data = new JSONObject(jsonObject.get("data").toString());
                String url = data.get("access_url").toString();
                System.out.println(" url = " + url);
                return url;
            }
            log.info((Object)" upload file failure ");
            log.info((Object)("uploadFile result:" + result));
            return null;
        }
        catch (Exception e) {
            log.info((Object)" upload file failure ");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    public String getAPP_ID() {
        return this.APP_ID;
    }

    public void setAPP_ID(String APP_ID) {
        this.APP_ID = APP_ID;
    }

    public String getSECRET_ID() {
        return this.SECRET_ID;
    }

    public void setSECRET_ID(String SECRET_ID) {
        this.SECRET_ID = SECRET_ID;
    }

    public String getSECRET_KEY() {
        return this.SECRET_KEY;
    }

    public void setSECRET_KEY(String SECRET_KEY) {
        this.SECRET_KEY = SECRET_KEY;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public CosCloud getCos() {
        return this.cos;
    }

    public void setCos(CosCloud cos) {
        this.cos = cos;
    }

    public static void main(String[] args) {
        log.info((Object)" start  ");
        ImgStorageTencentServiceImpl tensent = new ImgStorageTencentServiceImpl("10047330", "AKIDORGABt7yubFPO4NVyw3yF2fwPmD6GiJH", "xtacEMxQTGTBMsavFoTJ57NL20llisTs");
        tensent.setBucketName("learn");
        tensent.initClient();
        try {
            tensent.imgStorage("article", "test3.png", "C:\\Users\\liangxj\\Desktop\\hahahha.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

