/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

public class FastdfsUtil {
    private static final Log log = LogFactory.getLog(FastdfsUtil.class);
    public static final String DEFAULT_FDFS_CLIENT_CONF_FILE = "fdfs_client.conf";
    private static String GROUP_NAME = null;

    public static final String upload(String local_filename) throws Exception {
        log.info((Object)("start upload file : " + local_filename));
        long start = System.currentTimeMillis();
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        StorageClient1 client = new StorageClient1(trackerServer, storageServer);
        NameValuePair[] metaList = new NameValuePair[]{new NameValuePair("fileName", local_filename)};
        String fileId = null;
        fileId = StringUtils.isBlank((String)GROUP_NAME) ? client.upload_file1(local_filename, null, metaList) : client.upload_file1(GROUP_NAME, local_filename, null, metaList);
        trackerServer.close();
        log.info((Object)("success upload file : groupName = " + GROUP_NAME + "; localname = " + local_filename + "; fileId = " + fileId + ", time : " + (System.currentTimeMillis() - start) + "ms"));
        return fileId;
    }

    public static final String uploadFileBytes(byte[] fileBytes, String local_filename, String ext_name) throws Exception {
        log.info((Object)("start upload file : " + local_filename));
        long start = System.currentTimeMillis();
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        StorageClient1 client = new StorageClient1(trackerServer, storageServer);
        NameValuePair[] metaList = new NameValuePair[]{new NameValuePair("fileName", local_filename)};
        String fileId = client.upload_file1(fileBytes, ext_name, metaList);
        trackerServer.close();
        log.info((Object)("success upload file : localname = " + local_filename + "; fileId = " + fileId + ", time : " + (System.currentTimeMillis() - start) + "ms"));
        return fileId;
    }

    public static final int delete(String file_id) throws Exception {
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        StorageClient1 client = new StorageClient1(trackerServer, storageServer);
        return client.delete_file1(file_id);
    }

    static {
        URL configFile = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_FDFS_CLIENT_CONF_FILE);
        try {
            ClientGlobal.init((String)configFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Properties properties = new Properties();
            properties.load(configFile.openStream());
            Object obj = properties.get("group_name");
            if (null != obj) {
                GROUP_NAME = (String)obj;
                GROUP_NAME = GROUP_NAME.trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

