/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.aliyuncs.exceptions.ClientException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImgStorageTencentServiceImpl
implements ImgStorageUtil {
    private static final Log log = LogFactory.getLog(ImgStorageTencentServiceImpl.class);
    private String APP_ID;
    private String SECRET_ID;
    private String SECRET_KEY;
    private String bucketName;
    private String region;
    private COSClient cosClient;

    public ImgStorageTencentServiceImpl(String APP_ID, String SECRET_ID, String SECRET_KEY, String bucketName, String region) {
        this.APP_ID = APP_ID;
        this.SECRET_ID = SECRET_ID;
        this.SECRET_KEY = SECRET_KEY;
        this.bucketName = bucketName;
        this.region = region;
        this.initClient();
    }

    public ImgStorageTencentServiceImpl() {
    }

    public void initClient() {
        log.info((Object)" init start ");
        if (null != this.APP_ID) {
            BasicCOSCredentials cred = new BasicCOSCredentials(this.SECRET_ID, this.SECRET_KEY);
            Region regions = new Region(this.region);
            ClientConfig clientConfig = new ClientConfig(regions);
            this.cosClient = new COSClient((COSCredentials)cred, clientConfig);
            log.info((Object)(" init cos success: " + this.cosClient));
        } else {
            log.info((Object)(" init cos error: " + this.cosClient));
        }
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        String url = null;
        log.info((Object)("dir: " + dir + ". yunFileName: " + yunFileName + ". picFile: " + picFile));
        try {
            File localFile = new File(picFile);
            String key = dir + yunFileName;
            log.info((Object)("bucketName: " + this.bucketName + ". key: " + key));
            log.info((Object)("file: " + localFile));
            ExecutorService threadPool = Executors.newFixedThreadPool(16);
            TransferManager transferManager = new TransferManager((COS)this.cosClient, threadPool);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, key, localFile);
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            transferManager.shutdownNow(false);
            url = "https://" + this.bucketName + ".cos." + this.region + ".myqcloud.com/" + key;
            log.info((Object)("url : " + url));
        }
        catch (CosServiceException serverException) {
            serverException.printStackTrace();
            log.info((Object)"CosServiceException error.");
        }
        catch (CosClientException clientException) {
            clientException.printStackTrace();
            log.info((Object)"CosClientException error.");
        }
        catch (InterruptedException interException) {
            interException.printStackTrace();
            log.info((Object)"InterruptedException error.");
        }
        return url;
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        return null;
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getOptions(Map<String, String> options) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getVodOptions(Map<String, String> options, boolean transcoding) throws ClientException {
        return null;
    }

    public String getAPP_ID() {
        return this.APP_ID;
    }

    public void setAPP_ID(String APP_ID) {
        this.APP_ID = APP_ID;
    }

    public String getSECRET_ID() {
        return this.SECRET_ID;
    }

    public void setSECRET_ID(String SECRET_ID) {
        this.SECRET_ID = SECRET_ID;
    }

    public String getSECRET_KEY() {
        return this.SECRET_KEY;
    }

    public void setSECRET_KEY(String SECRET_KEY) {
        this.SECRET_KEY = SECRET_KEY;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public COSClient getCosClient() {
        return this.cosClient;
    }

    public void setCosClient(COSClient cosClient) {
        this.cosClient = cosClient;
    }

    public static void main(String[] args) {
        System.out.println(" start  ");
        String appId = "1258752615";
        String secretId = "AKIDYzd5Kb5WDoETXUlBPExVt56weGj35D2J";
        String secretKey = "KNG3f5KNI7ckhT3StCOQp3nM4bDetreG";
        String region = "ap-beijing";
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region regions = new Region("ap-beijing");
        ClientConfig clientConfig = new ClientConfig(regions);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        String bucket = "gene-1258752615";
        try {
            File localFile = new File("/data/webs/gene-admin-web/pdf/1a4a6d07-e05b-46e9-a1e3-e0651967a800.pdf");
            String key = "file/test.pdf";
            PutObjectResult putObjectResult = cosClient.putObject(bucket, key, localFile);
            String etag = putObjectResult.getETag();
            String url = "\thttps://" + bucket + ".cos." + region + ".myqcloud.com/" + key;
            System.out.println(url);
        }
        catch (CosServiceException serverException) {
            serverException.printStackTrace();
        }
        catch (CosClientException clientException) {
            clientException.printStackTrace();
        }
    }
}

