/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoResponse;
import com.ksyun.ks3.utils.StringUtils;
import com.ptteng.common.storage.util.ImgStorageTencentServiceImpl;
import com.ptteng.common.storage.util.ImgStorageUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImgStorageAliServiceImpl
implements ImgStorageUtil {
    private static final Log log = LogFactory.getLog(ImgStorageTencentServiceImpl.class);
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private String callbackUrl;
    private OSSClient ossClient;
    private String regionId;
    private String templateGroupId;
    private DefaultAcsClient vodClient;

    public ImgStorageAliServiceImpl(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String url) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName = bucketName;
        this.ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        log.info((Object)" init cos success ");
    }

    public ImgStorageAliServiceImpl(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String url, String regionId, String callbackUrl, String templateGroupId) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName = bucketName;
        this.callbackUrl = callbackUrl;
        this.regionId = regionId;
        this.templateGroupId = templateGroupId;
        this.ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        log.info((Object)" init cos success ");
    }

    public ImgStorageAliServiceImpl() {
        log.info((Object)" init cos success ");
    }

    public void initClient() {
        DefaultAcsClient vodClient;
        log.info((Object)" init start ");
        String regionId = this.regionId;
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)this.accessKeyId, (String)this.accessKeySecret);
        this.vodClient = vodClient = new DefaultAcsClient((IClientProfile)profile);
        log.info((Object)" init cos success ");
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        log.info((Object)(" bucketName = " + this.bucketName));
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        PutObjectResult putObjectResult = ossClient.putObject(new PutObjectRequest(this.bucketName, yunFileName, new File(picFile)));
        log.info((Object)("  putObjectResult eTag =  " + putObjectResult.getETag()));
        System.out.println("  eTag = " + putObjectResult.getETag());
        String fileUrl = "http://" + this.bucketName + "." + this.endpoint + "/" + yunFileName;
        log.info((Object)(" fileUrl = " + fileUrl));
        ossClient.shutdown();
        return fileUrl;
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        return null;
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getOptions(Map<String, String> options) throws IOException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        long expireTime = 3600L;
        if (options.containsKey("expireTime")) {
            expireTime = Long.parseLong(options.get("expireTime"));
        }
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", "");
        String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = ossClient.calculatePostSignature(postPolicy);
        LinkedHashMap<String, Object> respMap = new LinkedHashMap<String, Object>();
        respMap.put("accessid", this.accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        if (options.containsKey("dir")) {
            respMap.put("dir", options.get("dir"));
        } else {
            respMap.put("dir", "");
        }
        respMap.put("host", "https://" + this.bucketName + "." + this.endpoint);
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        if (!StringUtils.isBlank((String)this.callbackUrl)) {
            JSONObject jasonCallback = new JSONObject();
            jasonCallback.put("callbackUrl", (Object)this.callbackUrl);
            jasonCallback.put("callbackBody", (Object)"bucket=${bucket}&object=${object}&etag=${etag}&size=${size}&mimeType=${mimeType}&imageInfo.height=${imageInfo.height}&imageInfo.width=${imageInfo.width}&imageInfo.format=${imageInfo.format}");
            jasonCallback.put("callbackBodyType", (Object)"application/x-www-form-urlencoded");
            String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
            respMap.put("callback", base64CallbackBody);
        }
        ossClient.shutdown();
        return respMap;
    }

    @Override
    public Map<String, Object> getVodOptions(Map<String, String> options, boolean transcoding) throws ClientException {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)MapUtils.getString(options, (Object)"videoId"))) {
            RefreshUploadVideoRequest request = new RefreshUploadVideoRequest();
            request.setVideoId(MapUtils.getString(options, (Object)"videoId"));
            RefreshUploadVideoResponse response = (RefreshUploadVideoResponse)this.vodClient.getAcsResponse((AcsRequest)request);
            objectMap.put("requestId", response.getRequestId());
            objectMap.put("uploadAddress", response.getUploadAddress());
            objectMap.put("uploadAuth", response.getUploadAuth());
            objectMap.put("videoId", response.getVideoId());
        } else {
            CreateUploadVideoRequest request = new CreateUploadVideoRequest();
            request.setTitle(MapUtils.getString(options, (Object)"title"));
            request.setFileName(MapUtils.getString(options, (Object)"fileName"));
            if (transcoding) {
                request.setTemplateGroupId(this.templateGroupId);
            }
            if (!StringUtils.isBlank((String)this.callbackUrl)) {
                JSONObject userData = new JSONObject();
                JSONObject messageCallback = new JSONObject();
                messageCallback.put("CallbackURL", (Object)this.callbackUrl);
                messageCallback.put("CallbackType", (Object)"http");
                userData.put("MessageCallback", (Object)messageCallback.toString());
                request.setUserData(userData.toString());
            }
            CreateUploadVideoResponse response = (CreateUploadVideoResponse)this.vodClient.getAcsResponse((AcsRequest)request);
            objectMap.put("requestId", response.getRequestId());
            objectMap.put("uploadAddress", response.getUploadAddress());
            objectMap.put("uploadAuth", response.getUploadAuth());
            objectMap.put("videoId", response.getVideoId());
        }
        return objectMap;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public OSSClient getOssClient() {
        return this.ossClient;
    }

    public void setOssClient(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getTemplateGroupId() {
        return this.templateGroupId;
    }

    public void setTemplateGroupId(String templateGroupId) {
        this.templateGroupId = templateGroupId;
    }

    private static void displayTextInputStream(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "utf-8"));
        while ((line = reader.readLine()) != null) {
            System.out.println("\t" + line);
        }
        System.out.println();
        reader.close();
    }

    public static void main(String[] args) {
        log.info((Object)" start  ");
        ImgStorageAliServiceImpl tensent = new ImgStorageAliServiceImpl();
        tensent.setEndpoint("oss-cn-shanghai.aliyuncs.com");
        tensent.setAccessKeyId("LTAIEPMkD80uYm0p");
        tensent.setAccessKeySecret("vMFgog16wRsTnmbFtwBnbgJ8hcRfi6");
        tensent.setBucketName("jinxin-uk");
        tensent.initClient();
        try {
            String url = tensent.imgStorage("article", "test5.png", "C:\\Users\\liangxj\\Desktop\\hahahha.png");
            System.out.println(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

