/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class CaptchaUtil {
    private int width = 100;
    private int height = 30;
    private Random random = new Random();
    private BufferedImage image;
    private String code;
    private int twistLevel = 2;
    private int noiseLineNumber = 3;
    private Color backgroundColor = Color.WHITE;
    private Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.BLACK, Color.CYAN, Color.MAGENTA};

    private Color getRandomColor() {
        return this.colors[this.random.nextInt(this.colors.length)];
    }

    public CaptchaUtil generate(int width, int height, String randomStr) {
        this.width = width;
        this.height = height;
        this.code = randomStr;
        if (StringUtils.isBlank((String)this.code)) {
            throw new RuntimeException("randomStr can not be empty.");
        }
        int xWidth = width / (this.code.length() + 2);
        int yIndex = height - 4;
        Graphics2D graphics = this.graphicsInit();
        for (int i = 0; i < this.code.length(); ++i) {
            graphics.setColor(this.getRandomColor());
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawString(this.code.charAt(i) + "", (i + 1) * xWidth, yIndex);
        }
        this.setBuffImg(this.disturb());
        return this;
    }

    private Graphics2D graphicsInit() {
        Graphics2D graphics = this.buffImgInit().createGraphics();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(new Font("Fixedsys", 2, this.height - 2));
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        return graphics;
    }

    private BufferedImage buffImgInit() {
        this.image = new BufferedImage(this.width, this.height, 1);
        return this.image;
    }

    private BufferedImage disturb() {
        this.drawNoiseLine(this.image.createGraphics());
        return this.twistImage();
    }

    private void drawNoiseLine(Graphics2D graphics) {
        int x = 0;
        int y = 0;
        int xl = 0;
        int yl = 0;
        for (int i = 0; i < this.noiseLineNumber; ++i) {
            x = this.random.nextInt(this.width * 2 / 3);
            y = this.random.nextInt(this.height * 2 / 3);
            xl = this.random.nextInt(this.width / 2);
            yl = this.random.nextInt(this.height / 2);
            graphics.setColor(this.getRandomColor());
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawLine(x, y, x + xl, y + yl);
        }
    }

    private BufferedImage twistImage() {
        double dMultValue = this.random.nextInt(9) + this.twistLevel;
        double dPhase = this.random.nextInt(6);
        BufferedImage destBi = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
        Graphics2D graphics = destBi.createGraphics();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.width, this.height);
        for (int i = 0; i < destBi.getWidth(); ++i) {
            for (int j = 0; j < destBi.getHeight(); ++j) {
                int nOldX = this.getXPosition4Twist(dPhase, dMultValue, destBi.getHeight(), i, j);
                int nOldY = j;
                if (nOldX < 0 || nOldX >= destBi.getWidth() || nOldY < 0 || nOldY >= destBi.getHeight()) continue;
                destBi.setRGB(nOldX, nOldY, this.image.getRGB(i, j));
            }
        }
        return destBi;
    }

    private int getXPosition4Twist(double dPhase, double dMultValue, int height, int xPosition, int yPosition) {
        double PI = Math.PI;
        double dx = PI * (double)yPosition / (double)height + dPhase;
        double dy = Math.sin(dx);
        return xPosition + (int)(dy * dMultValue);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setBuffImg(BufferedImage buffImg) {
        this.image = buffImg;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

