/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.common.storage.util.UpYun;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ImgStorageUtilYPImpl
implements ImgStorageUtil {
    private String bucketName;
    private String userName;
    private String userPwd;
    private String URL;
    private static final String DIR_ROOT = "/";
    private static final String PIC_NAME = "sample.jpeg";
    private static final String fileUrl = System.getProperty("user.dir") + "/sample.jpeg";
    private static UpYun upyun = null;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPwd() {
        return this.userPwd;
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = userPwd;
    }

    public void UpYunInit() {
        upyun = new UpYun(this.bucketName, this.userName, this.userPwd);
        this.URL = "http://" + this.bucketName + ".b0.upaiyun.com";
        upyun.setDebug(true);
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String fileUrl) throws IOException {
        this.UpYunInit();
        if (yunFileName == null || yunFileName == "") {
            yunFileName = UUID.randomUUID().toString();
        }
        String newfilename = yunFileName + fileUrl.substring(fileUrl.lastIndexOf(46));
        String filePath = DIR_ROOT + dir + DIR_ROOT + newfilename;
        File file = new File(fileUrl);
        upyun.setContentMD5(UpYun.md5(file));
        boolean result = upyun.writeFile(filePath, file, true);
        System.out.println(filePath + " \u4e0a\u4f20" + ImgStorageUtilYPImpl.isSuccess(result));
        System.out.println("\r\n****** " + file.getName() + " \u7684\u56fe\u7247\u4fe1\u606f *******");
        System.out.println("\u56fe\u7247\u5bbd\u5ea6:" + upyun.getPicWidth());
        System.out.println("\u56fe\u7247\u9ad8\u5ea6:" + upyun.getPicHeight());
        System.out.println("\u56fe\u7247\u5e27\u6570:" + upyun.getPicFrames());
        System.out.println("\u56fe\u7247\u7c7b\u578b:" + upyun.getPicType());
        System.out.println("****************************************\r\n");
        System.out.println("\u82e5\u8bbe\u7f6e\u8fc7\u8bbf\u95ee\u5bc6\u94a5(bac)\uff0c\u4e14\u7f29\u7565\u56fe\u95f4\u9694\u6807\u5fd7\u7b26\u4e3a'!'\uff0c\u5219\u53ef\u4ee5\u901a\u8fc7\u4ee5\u4e0b\u8def\u5f84\u6765\u8bbf\u95ee\u56fe\u7247\uff1a");
        System.out.println(this.URL + filePath + "!bac");
        System.out.println();
        if (result) {
            return this.URL + filePath;
        }
        return "\u7f29\u7565\u56fe\u4e0a\u4f20\u5931\u8d25\uff01";
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        return null;
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        this.UpYunInit();
        if (yunFileName == null || yunFileName == "") {
            yunFileName = UUID.randomUUID().toString();
        }
        String newfilename = yunFileName + fileUrl.substring(fileUrl.lastIndexOf(46));
        String filePath = DIR_ROOT + dir + DIR_ROOT + newfilename;
        File file = new File(picFile);
        params.put(PARAMS.KEY_X_GMKERL_TYPE.getValue(), PARAMS.VALUE_FIX_BOTH.getValue());
        params.put(PARAMS.KEY_X_GMKERL_VALUE.getValue(), "150x150");
        params.put(PARAMS.KEY_X_GMKERL_QUALITY.getValue(), "95");
        params.put(PARAMS.KEY_X_GMKERL_UNSHARP.getValue(), "true");
        params.put(PARAMS.KEY_X_GMKERL_THUMBNAIL.getValue(), "small");
        boolean result = upyun.writeFile(filePath, file, true, params);
        System.out.println(filePath + " \u5236\u4f5c\u7f29\u7565\u56fe" + ImgStorageUtilYPImpl.isSuccess(result));
        System.out.println("\u53ef\u4ee5\u901a\u8fc7\u8be5\u8def\u5f84\u6765\u8bbf\u95ee\u56fe\u7247\uff1a" + this.URL + filePath);
        System.out.println();
        if (result) {
            return this.URL + filePath;
        }
        return "\u7f29\u7565\u56fe\u4e0a\u4f20\u5931\u8d25\uff01";
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String param) throws IOException {
        this.UpYunInit();
        if (yunFileName == null || yunFileName == "") {
            yunFileName = UUID.randomUUID().toString();
        }
        String newfilename = yunFileName + fileUrl.substring(fileUrl.lastIndexOf(46));
        String filePath = DIR_ROOT + dir + DIR_ROOT + newfilename;
        File file = new File(picFile);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAMS.KEY_X_GMKERL_ROTATE.getValue(), param);
        boolean result = upyun.writeFile(filePath, file, true, params);
        System.out.println(filePath + " \u56fe\u7247\u65cb\u8f6c" + ImgStorageUtilYPImpl.isSuccess(result));
        System.out.println("\u53ef\u4ee5\u901a\u8fc7\u8be5\u8def\u5f84\u6765\u8bbf\u95ee\u56fe\u7247\uff1a" + this.URL + filePath);
        System.out.println();
        if (result) {
            return this.URL + filePath;
        }
        return "\u7f29\u7565\u56fe\u4e0a\u4f20\u5931\u8d25\uff01";
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String cropParams) throws IOException {
        this.UpYunInit();
        if (yunFileName == null || yunFileName == "") {
            yunFileName = UUID.randomUUID().toString();
        }
        String newfilename = yunFileName + fileUrl.substring(fileUrl.lastIndexOf(46));
        String filePath = DIR_ROOT + dir + DIR_ROOT + newfilename;
        File file = new File(picFile);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAMS.KEY_X_GMKERL_CROP.getValue(), cropParams);
        boolean result = upyun.writeFile(filePath, file, true, params);
        System.out.println(filePath + " \u56fe\u7247\u88c1\u526a" + ImgStorageUtilYPImpl.isSuccess(result));
        System.out.println("\u53ef\u4ee5\u901a\u8fc7\u8be5\u8def\u5f84\u6765\u8bbf\u95ee\u56fe\u7247\uff1a" + this.URL + filePath);
        System.out.println();
        if (result) {
            return this.URL + filePath;
        }
        return "\u7f29\u7565\u56fe\u4e0a\u4f20\u5931\u8d25\uff01";
    }

    private static String isSuccess(boolean result) {
        return result ? " \u6210\u529f" : " \u5931\u8d25";
    }

    private static String isFile(String fileUrl) {
        File picFile = new File(fileUrl);
        if (!picFile.isFile()) {
            System.out.println("\u672c\u5730\u5f85\u4e0a\u4f20\u7684\u6d4b\u8bd5\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return fileUrl;
    }

    public static enum PARAMS {
        KEY_X_GMKERL_TYPE("x-gmkerl-type"),
        KEY_X_GMKERL_VALUE("x-gmkerl-value"),
        KEY_X_GMKERL_QUALITY("x-gmkerl-quality"),
        KEY_X_GMKERL_UNSHARP("x-gmkerl-unsharp"),
        KEY_X_GMKERL_THUMBNAIL("x-gmkerl-thumbnail"),
        KEY_X_GMKERL_ROTATE("x-gmkerl-rotate"),
        KEY_X_GMKERL_CROP("x-gmkerl-crop"),
        KEY_X_GMKERL_EXIF_SWITCH("x-gmkerl-exif-switch"),
        KEY_MAKE_DIR("folder"),
        VALUE_FIX_MAX("fix_max"),
        VALUE_FIX_MIN("fix_min"),
        VALUE_FIX_WIDTH_OR_HEIGHT("fix_width_or_height"),
        VALUE_FIX_WIDTH("fix_width"),
        VALUE_FIX_HEIGHT("fix_height"),
        VALUE_SQUARE("square"),
        VALUE_FIX_BOTH("fix_both"),
        VALUE_FIX_SCALE("fix_scale"),
        VALUE_ROTATE_AUTO("auto"),
        VALUE_ROTATE_90("90"),
        VALUE_ROTATE_180("180"),
        VALUE_ROTATE_270("270");

        private final String value;

        private PARAMS(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

