/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.storage.util;

import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.http.HttpClientConfig;
import com.ksyun.ks3.service.Ks3;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.utils.StringUtils;
import com.ptteng.common.storage.util.ImgStorageUtil;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImgStorageUtilJSImpl
implements ImgStorageUtil {
    private static final Log log = LogFactory.getLog(ImgStorageUtilJSImpl.class);
    private String akey;
    private String skey;
    private String bucketName;
    private Ks3 client;
    private String domain;

    public ImgStorageUtilJSImpl(String akey, String skey) {
        this.akey = akey;
        this.skey = skey;
        this.client = new Ks3Client(akey, skey);
        log.info((Object)" init client success ");
    }

    public ImgStorageUtilJSImpl() {
        this.client = new Ks3Client(this.akey, this.skey);
        log.info((Object)" init client success ");
    }

    public void initClient() {
        this.client = new Ks3Client(this.akey, this.skey);
        log.info((Object)" init client success ");
    }

    public void initClientConfig() {
        Ks3ClientConfig config = new Ks3ClientConfig();
        config.setEndpoint("ks3-cn-beijing.ksyun.com");
        config.setProtocol(Ks3ClientConfig.PROTOCOL.http);
        config.setPathStyleAccess(false);
        config.setDomainMode(false);
        HttpClientConfig hconfig = new HttpClientConfig();
        config.setHttpClientConfig(hconfig);
        this.client = new Ks3Client(this.akey, this.skey, config);
        log.info((Object)" init client success ");
    }

    public void initHZClientConfig() {
        Ks3ClientConfig config = new Ks3ClientConfig();
        config.setEndpoint("kss.ksyun.com");
        config.setProtocol(Ks3ClientConfig.PROTOCOL.http);
        config.setPathStyleAccess(false);
        config.setDomainMode(false);
        HttpClientConfig hconfig = new HttpClientConfig();
        config.setHttpClientConfig(hconfig);
        this.client = new Ks3Client(this.akey, this.skey, config);
        log.info((Object)" init client success ");
    }

    public String getAkey() {
        return this.akey;
    }

    public void setAkey(String akey) {
        this.akey = akey;
    }

    public String getSkey() {
        return this.skey;
    }

    public void setSkey(String skey) {
        this.skey = skey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public Ks3 getClient() {
        return this.client;
    }

    public void setClient(Ks3 client) {
        this.client = client;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        System.out.println(" bucketName = " + this.bucketName + " akey = " + this.akey + " skey = " + this.skey + "yunFileName= " + yunFileName + " picFile = " + picFile);
        log.info((Object)(" bucketName = " + this.bucketName + " akey = " + this.akey + " skey = " + this.skey + "yunFileName= " + yunFileName + " picFile = " + picFile));
        String bucket = this.bucketName;
        if (StringUtils.isBlank((String)dir)) {
            log.info((Object)"dir is empty,use default bucket ");
        } else {
            bucket = dir;
        }
        PutObjectRequest request = new PutObjectRequest(bucket, yunFileName, new File(picFile));
        request.setCannedAcl(CannedAccessControlList.PublicRead);
        this.client.putObject(request);
        String url2 = this.generateUrl(bucket, yunFileName);
        log.info((Object)(bucket + " and key " + yunFileName + " get url2 is " + url2));
        return url2;
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        System.out.println(" url = " + url + " timeOneHour = " + timeOneHour);
        String[] url1 = url.split("\\/");
        String realKey = "";
        for (int i = 3; i < url1.length; ++i) {
            realKey = i == url1.length - 1 ? url1[i] : url1[i] + "/";
        }
        realKey = URLDecoder.decode(realKey, "utf-8");
        log.info((Object)(" realKey = " + realKey + " buketName = " + this.bucketName));
        String link = this.client.generatePresignedUrl(this.bucketName, realKey, timeOneHour);
        log.info((Object)(" link = " + link));
        return link;
    }

    public static void main(String[] args) {
        ImgStorageUtilJSImpl imgStorageUtil = new ImgStorageUtilJSImpl();
        imgStorageUtil.setBucketName("jns.img.bucket");
        imgStorageUtil.setAkey("7f1+ognHaShOCgVMkXnV");
        imgStorageUtil.setSkey("w1fyop45mnIwlJj0g2l4UBrjuZeIlZMbgS4nicL2");
        imgStorageUtil.setDomain(".ks3-cn-beijing.ksyun.com");
        imgStorageUtil.initClientConfig();
        try {
            String url = imgStorageUtil.imgStorage(null, "im/c486fe54-599f-4024-82dd-b8e048ddd120.jpg", "/data/temp/2.jpg");
            System.out.print(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generateUrl(String dir, String yunFileName) {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("http://");
        sb = sb.append(dir);
        sb = sb.append(this.domain);
        sb = sb.append("/");
        sb = sb.append(yunFileName);
        return sb.toString();
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }
}

