/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.sms.service.impl;

import com.google.gson.Gson;
import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.common.sms.service.util.GetMd5StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ZTHYSMSSendServiceImpl
implements SMSSendService {
    protected Log log = LogFactory.getLog(this.getClass());
    private String url;
    private String username;
    private String password;
    private String signature;

    private Map<String, Object> getBaseParam() {
        Long t = System.currentTimeMillis() / 1000L;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("username", this.username);
        param.put("password", GetMd5StrUtil.GetMD5Code(this.password + t));
        param.put("tKey", t);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPost(String url, String json) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(json, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String sendSMS(String mobile, String content) {
        try {
            this.log.info((Object)("will send code to " + mobile + ",content is " + content));
            Map<String, Object> param = this.getBaseParam();
            param.put("mobile", mobile);
            param.put("content", content);
            Gson gson = new Gson();
            String result = this.sendPost(this.url + "sendSms", gson.toJson(param));
            this.log.info((Object)("send result is " + result));
            return result;
        }
        catch (Throwable t) {
            this.log.error((Object)t.getMessage(), t);
            return "";
        }
    }

    @Override
    public String sendSMSByParams(Map<String, Object> params) {
        try {
            this.log.info((Object)("will send code ,params=  " + params));
            Map<String, Object> param = this.getBaseParam();
            param.putAll(params);
            Gson gson = new Gson();
            String result = this.sendPost(this.url + "sendSms", gson.toJson(param));
            this.log.info((Object)("send result is " + result));
            return result;
        }
        catch (Throwable t) {
            this.log.error((Object)t.getMessage(), t);
            return "";
        }
    }

    @Override
    public String sendSMSByTemplate(String mobile, String template, String[] params) {
        try {
            this.log.info((Object)("will send code " + mobile + "tempate is " + template + " ,params=  " + Arrays.toString(params)));
            Map<String, Object> param = this.getBaseParam();
            param.put("tpId", template);
            if (StringUtils.isBlank((String)this.signature)) {
                this.signature = params[1];
            }
            param.put("signature", this.signature);
            ArrayList records = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mobile", mobile);
            HashMap<String, String> pMap = new HashMap<String, String>();
            pMap.put("valid_code", params[0]);
            map.put("tpContent", pMap);
            param.put("records", map);
            Gson gson = new Gson();
            String result = this.sendPost(this.url + "sendSmsTp", gson.toJson(param));
            this.log.info((Object)("send result is " + result));
            return result;
        }
        catch (Throwable t) {
            this.log.error((Object)t.getMessage(), t);
            return "";
        }
    }

    @Override
    public String sendSMSByTemplateByMore(String mobile, String template, Map<String, String> params) {
        try {
            this.log.info((Object)("will send code " + mobile + "tempate is " + template + " ,params=  " + params));
            Map<String, Object> param = this.getBaseParam();
            param.put("tpId", template);
            if (StringUtils.isBlank((String)this.signature)) {
                this.signature = params.get("signature");
            }
            params.remove("signature");
            param.put("signature", this.signature);
            ArrayList records = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mobile", mobile);
            map.put("tpContent", params);
            records.add(map);
            param.put("records", records);
            Gson gson = new Gson();
            String result = this.sendPost(this.url + "sendSmsTp", gson.toJson(param));
            this.log.info((Object)("send result is " + result));
            return result;
        }
        catch (Throwable t) {
            this.log.error((Object)t.getMessage(), t);
            return "";
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password = GetMd5StrUtil.GetMD5Code(password);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

