package com.ptteng.common.sms.service.impl;

import com.ptteng.common.sms.service.SMSSendService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.net.URI;
import java.net.URL;
import java.util.Map;

/**
 * Created by lishaobo on 2018/08/08
 * 畅天游
 */
public class CTUSMSSendServiceImpl implements SMSSendService {

    protected Log log = LogFactory.getLog(this.getClass());

    private String url;
    private String account;
    private String password;

    @Override
    public String sendSMS(String mobile, String content) {
        HttpClient httpClient = new DefaultHttpClient();
        try {
            String strUrl = "http://sms.800617.com:4400/sms/SendSMS.aspx?un="+account+"&pwd="+password+"&mobile="+mobile+"&msg="+content;
            URL url = new URL(strUrl);
            URI uri = new URI(url.getProtocol(), url.getHost() + ":" + url.getPort(), url.getPath(), url.getQuery(), null);
            HttpGet httpGet = new HttpGet(uri);
            log.info(uri);
            HttpResponse response = httpClient.execute(httpGet);
            HttpEntity entity = response.getEntity();
            log.info(System.currentTimeMillis()+"- return: "+getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return  "";
    }

    @Override
    public String sendSMSByParams(Map<String, Object> params) {
        return null;
    }

    @Override
    public String sendSMSByTemplate(String mobile, String template, String[] params) {
        HttpClient httpClient = new DefaultHttpClient();
        try {
            template = template.replace("{TITLE}", params[0]).replace("{CODE}", params[1]);
            String strUrl = "http://sms.800617.com:4400/sms/SendSMS.aspx?un="+account+"&pwd="+password+"&mobile="+mobile+"&msg="+template;
            URL url = new URL(strUrl);
            URI uri = new URI(url.getProtocol(), url.getHost() + ":" + url.getPort(), url.getPath(), url.getQuery(), null);
            HttpGet httpget = new HttpGet(uri);
            log.info(uri);
            HttpResponse response = httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            log.info(System.currentTimeMillis()+"- return: "+getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return  "";
    }

    @Override
    public String sendSMSByTemplateByMore(String mobile, String template, Map params) {
        return null;
    }

    public static String getResponseContent(HttpEntity responseEntity)  throws Exception {
        byte[] bytes = EntityUtils.toByteArray(responseEntity);
        return new String(bytes, "GBK");
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}