package com.ptteng.common.sms.service.impl;

import com.google.gson.Gson;
import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.common.sms.service.util.GetMd5StrUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import java.io.IOException;
import java.util.*;

public class ZTHYSMSSendServiceImpl implements SMSSendService {
    protected Log log = LogFactory.getLog(this.getClass());
    private String url;
    private String username;
    private String password;
    private String signature;
    private Map<String, Object> getBaseParam() {
        Long t = System.currentTimeMillis()/1000;
        Map<String, Object> param = new HashMap<>();
        param.put("username", username);
        param.put("password", GetMd5StrUtil.GetMD5Code(password + t));
        param.put("tKey", t);
        return param;
    }

    private String sendPost(String url, String json) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try {
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(url);

            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(json, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity(requestEntity);

            //第四步：发送HttpPost请求，获取返回值
            result = httpClient.execute(httpPost, responseHandler); //调接口获取返回值时，必须用此方法

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        //第五步：处理返回值
        return result;

    }

    @Override
    public String sendSMS(String mobile, String content) {
        try {
            log.info("will send code to " + mobile + ",content is " + content);
            Map<String, Object> param = getBaseParam();
            param.put("mobile", mobile);
            param.put("content", content);
            Gson gson = new Gson();
            String result = sendPost(url+"sendSms", gson.toJson(param));
            log.info("send result is " + result);
            return result;
        } catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        return "";
    }

    @Override
    public String sendSMSByParams(Map<String, Object> params) {
        try {
            log.info("will send code ,params=  " + params);
            Map<String, Object> param = getBaseParam();
            param.putAll(params);
            Gson gson = new Gson();
            String result = sendPost(url+"sendSms", gson.toJson(param));
            log.info("send result is " + result);
            return result;
        } catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        return "";
    }

    @Override
    public String sendSMSByTemplate(String mobile, String template, String[] params) {
        try {
            log.info("will send code "+mobile+"tempate is "+template+" ,params=  " + Arrays.toString(params));
            Map<String, Object> param = getBaseParam();
            param.put("tpId", template);
            if (StringUtils.isBlank(signature)) {
                signature = params[1];
            }
            param.put("signature",signature);
            List<Map<String, Object>> records = new ArrayList<>();
            Map<String, Object> map = new HashMap<>();
            map.put("mobile", mobile);
            Map<String, String> pMap = new HashMap<>();
            pMap.put("valid_code", params[0]);
            map.put("tpContent", pMap);
            param.put("records", map);
            Gson gson = new Gson();
            String result = sendPost(url+"sendSmsTp", gson.toJson(param));
            log.info("send result is " + result);
            return result;
        } catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        return "";
    }

    @Override
    public String sendSMSByTemplateByMore(String mobile, String template, Map<String, String> params) {
        try {
            log.info("will send code "+mobile+"tempate is "+template+" ,params=  " + params);
            Map<String, Object> param = getBaseParam();
            param.putAll(params);
            Gson gson = new Gson();
            String result = sendPost(url+"sendSmsTp", gson.toJson(param));
            log.info("send result is " + result);
            return result;
        } catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        return "";
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        password = GetMd5StrUtil.GetMD5Code(password);
        this.password = password;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}
