package com.ptteng.common.sms.service.impl;

import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.common.sms.service.util.GetMd5StrUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by liangxj on 2016/7/5.
 * 索游短信
 */
public class SuoyouSMSSendServiceImpl implements SMSSendService {
    protected Log log = LogFactory.getLog(this.getClass());

    private String url;//接口地址
    private String usr;//索游用户ID
    private String passwd;//索游密码

    private Integer priority;//没用
    private String extsrcid;//没用

    @Override
    public String sendSMS(String mobile, String content) {
        return null;
    }

    @Override
    public String sendSMSByParams(Map<String, Object> params) {
        return null;
    }

    @Override
    public String sendSMSByTemplate(String mobile, String template, String[] params) {
        HttpClient httpClient = new DefaultHttpClient();
        String result = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> nvps = new ArrayList<NameValuePair>();
            nvps.add(new BasicNameValuePair("usr", usr));
            //nvps.add(new BasicNameValuePair("pwd", passwd));
            nvps.add(new BasicNameValuePair("mobile", mobile));
            nvps.add(new BasicNameValuePair("sms", params[0]));
//            nvps.add(new BasicNameValuePair("extdsrcid", extsrcid));
//            nvps.add(new BasicNameValuePair("priority", priority+""));
            StringBuilder signStr = new StringBuilder();
            signStr.append(""+usr+"|"+passwd+"|"+mobile);
            log.info(" signStr = " + signStr);
            String sign = GetMd5StrUtil.GetMD5Code(signStr.toString());
            nvps.add(new BasicNameValuePair("sign", sign));

            httpPost.setEntity(new UrlEncodedFormEntity(nvps, "GBK"));
            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity);
            log.info("result is : "+result);
            log.info(System.currentTimeMillis()+"- return: "+getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return  result;    }

    @Override
    public String sendSMSByTemplateByMore(String mobile, String template, Map<String, String> params) {
        return null;
    }
    public static String getResponseContent(HttpEntity responseEntity)  throws Exception {
        byte[] bytes = EntityUtils.toByteArray(responseEntity);
        return new String(bytes, "GBK");
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsr() {
        return usr;
    }

    public void setUsr(String usr) {
        this.usr = usr;
    }

    public String getPasswd() {
        return passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getExtsrcid() {
        return extsrcid;
    }

    public void setExtsrcid(String extsrcid) {
        this.extsrcid = extsrcid;
    }
}
